/*
 * Decompiled with CFR 0.152.
 */
package com.sdicons.json.serializer.marshall;

import com.sdicons.json.helper.HelperRepository;
import com.sdicons.json.model.JSONObject;
import com.sdicons.json.model.JSONString;
import com.sdicons.json.serializer.helper.MarshallHelper;
import com.sdicons.json.serializer.helper.impl.ArrayHelper;
import com.sdicons.json.serializer.helper.impl.BigDecimalHelper;
import com.sdicons.json.serializer.helper.impl.BigIntegerHelper;
import com.sdicons.json.serializer.helper.impl.BooleanHelper;
import com.sdicons.json.serializer.helper.impl.ByteHelper;
import com.sdicons.json.serializer.helper.impl.CharacterHelper;
import com.sdicons.json.serializer.helper.impl.CollectionHelper;
import com.sdicons.json.serializer.helper.impl.ColorHelper;
import com.sdicons.json.serializer.helper.impl.DateHelper;
import com.sdicons.json.serializer.helper.impl.DoubleHelper;
import com.sdicons.json.serializer.helper.impl.EnumHelper;
import com.sdicons.json.serializer.helper.impl.FloatHelper;
import com.sdicons.json.serializer.helper.impl.FontHelper;
import com.sdicons.json.serializer.helper.impl.IntegerHelper;
import com.sdicons.json.serializer.helper.impl.LongHelper;
import com.sdicons.json.serializer.helper.impl.MapHelper;
import com.sdicons.json.serializer.helper.impl.ObjectHelper;
import com.sdicons.json.serializer.helper.impl.ShortHelper;
import com.sdicons.json.serializer.helper.impl.StringHelper;
import com.sdicons.json.serializer.marshall.Marshall;
import com.sdicons.json.serializer.marshall.MarshallException;
import com.sdicons.json.serializer.marshall.MarshallValue;
import com.sdicons.json.serializer.marshall.MarshallValueImpl;
import com.sdicons.json.serializer.marshall.Reference;
import java.util.HashMap;

public class JSONMarshall
implements Marshall {
    private static final String IDPREFIX = "id";
    private long idCounter = 0L;
    public static final String RNDR_NULL = "null";
    public static final String RNDR_OBJ = "O";
    public static final String RNDR_OBJREF = "R";
    public static final String RNDR_PRIM = "P";
    public static final String RNDR_ARR = "A";
    public static final String RNDR_ATTR_ID = "&";
    public static final String RNDR_ATTR_KIND = ">";
    public static final String RNDR_ATTR_TYPE = "t";
    public static final String RNDR_ATTR_VALUE = "=";
    public static final String RNDR_ATTR_CLASS = "c";
    public static final String RNDR_ATTR_REF = "*";
    public static final String RNDR_PRTITYP_BOOLEAN = "boolean";
    public static final String RNDR_PRTITYP_BYTE = "byte";
    public static final String RNDR_PRTITYP_CHAR = "char";
    public static final String RNDR_PRTITYP_SHORT = "short";
    public static final String RNDR_PRTITYP_INT = "int";
    public static final String RNDR_PRTITYP_LONG = "long";
    public static final String RNDR_PRTITYP_FLOAT = "float";
    public static final String RNDR_PRTITYP_DOUBLE = "double";
    public static final String ERR_MISSINGATTR = "Attribute is missing: ";
    public static final String ERR_MISSINGATTRVAL = "Attribute value is missing: ";
    public static final String ERR_MISSINGSTRING = "Attribute is not a string value: ";
    private HelperRepository<MarshallHelper> repo = new HelperRepository();

    public JSONMarshall() {
        this.repo.addHelper(new ObjectHelper());
        this.repo.addHelper(new StringHelper());
        this.repo.addHelper(new BooleanHelper());
        this.repo.addHelper(new ByteHelper());
        this.repo.addHelper(new ShortHelper());
        this.repo.addHelper(new IntegerHelper());
        this.repo.addHelper(new LongHelper());
        this.repo.addHelper(new FloatHelper());
        this.repo.addHelper(new DoubleHelper());
        this.repo.addHelper(new BigIntegerHelper());
        this.repo.addHelper(new BigDecimalHelper());
        this.repo.addHelper(new CharacterHelper());
        this.repo.addHelper(new DateHelper());
        this.repo.addHelper(new CollectionHelper());
        this.repo.addHelper(new MapHelper());
        this.repo.addHelper(new ColorHelper());
        this.repo.addHelper(new FontHelper());
        this.repo.addHelper(new EnumHelper());
    }

    public JSONObject marshall(boolean aValue) {
        return this.marshallPrimitive(RNDR_PRTITYP_BOOLEAN, "" + aValue);
    }

    public JSONObject marshall(byte aValue) {
        return this.marshallPrimitive(RNDR_PRTITYP_BYTE, "" + aValue);
    }

    public JSONObject marshall(short aValue) {
        return this.marshallPrimitive(RNDR_PRTITYP_SHORT, "" + aValue);
    }

    public JSONObject marshall(char aValue) {
        return this.marshallPrimitive(RNDR_PRTITYP_CHAR, "" + aValue);
    }

    public JSONObject marshall(int aValue) {
        return this.marshallPrimitive(RNDR_PRTITYP_INT, "" + aValue);
    }

    public JSONObject marshall(long aValue) {
        return this.marshallPrimitive(RNDR_PRTITYP_LONG, "" + aValue);
    }

    public JSONObject marshall(float aValue) {
        return this.marshallPrimitive(RNDR_PRTITYP_FLOAT, "" + aValue);
    }

    public JSONObject marshall(double aValue) {
        return this.marshallPrimitive(RNDR_PRTITYP_DOUBLE, "" + aValue);
    }

    private JSONObject marshallPrimitive(String aType, String aValue) {
        JSONObject lElement = new JSONObject();
        lElement.getValue().put(RNDR_ATTR_KIND, new JSONString(RNDR_PRIM));
        lElement.getValue().put(RNDR_ATTR_TYPE, new JSONString(aType));
        lElement.getValue().put(RNDR_ATTR_VALUE, new JSONString(aValue));
        return lElement;
    }

    public JSONObject marshall(Object aObj) throws MarshallException {
        return this.marshallImpl(aObj, new HashMap());
    }

    public JSONObject marshallImpl(Object aObj, HashMap aPool) throws MarshallException {
        if (aObj == null) {
            JSONObject lElement = new JSONObject();
            lElement.getValue().put(RNDR_ATTR_KIND, new JSONString(RNDR_NULL));
            return lElement;
        }
        Class<?> lObjectClass = aObj.getClass();
        String lObjectClassName = lObjectClass.getName();
        Reference lRef = new Reference(aObj);
        if (aPool.containsKey(lRef)) {
            JSONObject lElement = new JSONObject();
            lElement.getValue().put(RNDR_ATTR_KIND, new JSONString(RNDR_OBJREF));
            lElement.getValue().put(RNDR_ATTR_REF, new JSONString((String)aPool.get(lRef)));
            return lElement;
        }
        String lObjectId = this.generateId();
        aPool.put(lRef, lObjectId);
        if (lObjectClass.isArray()) {
            return this.marshallImplArray(aObj, aPool);
        }
        return this.marshallImplObject(aObj, lObjectId, lObjectClass, lObjectClassName, aPool);
    }

    private JSONObject marshallImplArray(Object aObj, HashMap aPool) throws MarshallException {
        Class<?> lClass = aObj.getClass();
        String lObjClassName = lClass.getName();
        String lComponentClassName = "unknown";
        lComponentClassName = lObjClassName.startsWith("[L") ? lObjClassName.substring(2, lObjClassName.length() - 1) : lObjClassName.substring(1);
        JSONObject lArrElement = new JSONObject();
        lArrElement.getValue().put(RNDR_ATTR_KIND, new JSONString(RNDR_ARR));
        lArrElement.getValue().put(RNDR_ATTR_CLASS, new JSONString(lComponentClassName));
        ArrayHelper lAh = new ArrayHelper();
        lAh.renderValue(aObj, lArrElement, this, aPool);
        return lArrElement;
    }

    private JSONObject marshallImplObject(Object aObj, String aObjId, Class aObjClass, String aObjClassName, HashMap aPool) throws MarshallException {
        JSONObject lObjElement = new JSONObject();
        lObjElement.getValue().put(RNDR_ATTR_KIND, new JSONString(RNDR_OBJ));
        lObjElement.getValue().put(RNDR_ATTR_ID, new JSONString(aObjId));
        lObjElement.getValue().put(RNDR_ATTR_CLASS, new JSONString(aObjClassName));
        MarshallHelper lHelper = this.repo.findHelper(aObjClass);
        lHelper.renderValue(aObj, lObjElement, this, aPool);
        return lObjElement;
    }

    private String generateId() {
        String lId = IDPREFIX + this.idCounter;
        ++this.idCounter;
        return lId;
    }

    public MarshallValue unmarshall(JSONObject aElement) throws MarshallException {
        JSONMarshall.requireStringAttribute(aElement, RNDR_ATTR_KIND);
        String lElementKind = ((JSONString)aElement.get(RNDR_ATTR_KIND)).getValue();
        Object lUnmarshalled = this.unmarshallImpl(aElement, new HashMap());
        if (RNDR_PRIM.equals(lElementKind)) {
            if (lUnmarshalled instanceof Boolean) {
                return new MarshallValueImpl((Boolean)lUnmarshalled);
            }
            if (lUnmarshalled instanceof Byte) {
                return new MarshallValueImpl((Byte)lUnmarshalled);
            }
            if (lUnmarshalled instanceof Short) {
                return new MarshallValueImpl((Short)lUnmarshalled);
            }
            if (lUnmarshalled instanceof Character) {
                return new MarshallValueImpl(((Character)lUnmarshalled).charValue());
            }
            if (lUnmarshalled instanceof Integer) {
                return new MarshallValueImpl((Integer)lUnmarshalled);
            }
            if (lUnmarshalled instanceof Long) {
                return new MarshallValueImpl((Long)lUnmarshalled);
            }
            if (lUnmarshalled instanceof Float) {
                return new MarshallValueImpl(((Float)lUnmarshalled).floatValue());
            }
            if (lUnmarshalled instanceof Double) {
                return new MarshallValueImpl((Double)lUnmarshalled);
            }
            String lMsg = "Unknown primitive type encountered: " + lUnmarshalled.getClass().getName() + aElement.getLine() + ":" + aElement.getCol() + ".";
            throw new MarshallException(lMsg);
        }
        return new MarshallValueImpl(lUnmarshalled);
    }

    public Object unmarshallImpl(JSONObject aElement, HashMap aObjectPool) throws MarshallException {
        JSONMarshall.requireStringAttribute(aElement, RNDR_ATTR_KIND);
        String lElementKind = ((JSONString)aElement.get(RNDR_ATTR_KIND)).getValue();
        if (RNDR_OBJREF.equals(lElementKind)) {
            JSONMarshall.requireStringAttribute(aElement, RNDR_ATTR_REF);
            String lRef = ((JSONString)aElement.get(RNDR_ATTR_REF)).getValue();
            Object lObjFromPool = aObjectPool.get(lRef);
            if (lObjFromPool == null) {
                String lMsg = "Unknown reference: " + lRef;
                throw new MarshallException(lMsg);
            }
            return lObjFromPool;
        }
        if (RNDR_PRIM.equals(lElementKind)) {
            return this.unmarshallImplPrimitive(aElement);
        }
        if (RNDR_NULL.equals(lElementKind)) {
            return null;
        }
        if (RNDR_ARR.equals(lElementKind)) {
            ArrayHelper lAh = new ArrayHelper();
            return lAh.parseValue(aElement, this, aObjectPool);
        }
        if (RNDR_OBJ.equals(lElementKind)) {
            try {
                JSONMarshall.requireStringAttribute(aElement, RNDR_ATTR_CLASS);
                String lBeanClassName = ((JSONString)aElement.get(RNDR_ATTR_CLASS)).getValue();
                if (lBeanClassName == null) {
                    String lMsg = "Attribute value is missing: c";
                    throw new MarshallException("Attribute value is missing: c");
                }
                String lId = null;
                try {
                    JSONMarshall.requireStringAttribute(aElement, RNDR_ATTR_ID);
                    lId = ((JSONString)aElement.get(RNDR_ATTR_ID)).getValue();
                }
                catch (Exception eIgnore) {
                    // empty catch block
                }
                Class<?> lBeanClass = Class.forName(lBeanClassName);
                MarshallHelper lHelper = this.repo.findHelper(lBeanClass);
                Object lResult = lHelper.parseValue(aElement, this, aObjectPool);
                if (lId != null) {
                    aObjectPool.put(lId, lResult);
                }
                return lResult;
            }
            catch (ClassNotFoundException e) {
                String lMsg = "Tried to unmarshall unknown class.";
                throw new MarshallException("Tried to unmarshall unknown class.");
            }
        }
        String lMsg = "Unknown type encountered: " + lElementKind;
        throw new MarshallException(lMsg);
    }

    private Object unmarshallImplPrimitive(JSONObject aElement) throws MarshallException {
        JSONMarshall.requireStringAttribute(aElement, RNDR_ATTR_TYPE);
        JSONMarshall.requireStringAttribute(aElement, RNDR_ATTR_VALUE);
        String lType = ((JSONString)aElement.get(RNDR_ATTR_TYPE)).getValue();
        String lValue = ((JSONString)aElement.get(RNDR_ATTR_VALUE)).getValue();
        try {
            if (RNDR_PRTITYP_BOOLEAN.equals(lType)) {
                return new Boolean(lValue);
            }
            if (RNDR_PRTITYP_BYTE.equals(lType)) {
                return new Byte(lValue);
            }
            if (RNDR_PRTITYP_SHORT.equals(lType)) {
                return new Short(lValue);
            }
            if (RNDR_PRTITYP_CHAR.equals(lType)) {
                return new Character(lValue.charAt(0));
            }
            if (RNDR_PRTITYP_INT.equals(lType)) {
                return new Integer(lValue);
            }
            if (RNDR_PRTITYP_LONG.equals(lType)) {
                return new Long(lValue);
            }
            if (RNDR_PRTITYP_FLOAT.equals(lType)) {
                return new Float(lValue);
            }
            if (RNDR_PRTITYP_DOUBLE.equals(lType)) {
                return new Double(lValue);
            }
            String lMsg = "Unknown primitive type encountered: " + lType;
            throw new MarshallException(lMsg);
        }
        catch (MarshallException passtrough) {
            throw passtrough;
        }
        catch (Exception e) {
            String lMsg = "Error while unmarshalling primitive type: " + lType + ", value: " + lValue;
            throw new MarshallException(lMsg);
        }
    }

    public static void requireStringAttribute(JSONObject aElement, String anAttribute) throws MarshallException {
        if (!aElement.containsKey(anAttribute)) {
            String lMsg = ERR_MISSINGATTRVAL + anAttribute + " for object at location " + aElement.getLine() + ":" + aElement.getCol() + ".";
            throw new MarshallException(lMsg);
        }
        if (!(aElement.get(anAttribute) instanceof JSONString)) {
            String lMsg = ERR_MISSINGSTRING + anAttribute + " for object at location " + aElement.getLine() + ":" + aElement.getCol() + ".";
            throw new MarshallException(lMsg);
        }
    }
}

