/*
 * Decompiled with CFR 0.152.
 */
package com.sdicons.json.model;

import com.sdicons.json.model.JSONComplex;
import com.sdicons.json.model.JSONValue;
import com.sdicons.json.parser.impl.ParserUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONObject
extends JSONComplex {
    private HashMap<String, JSONValue> map = new LinkedHashMap<String, JSONValue>();

    @Override
    public int size() {
        return this.map.size();
    }

    public HashMap<String, JSONValue> getValue() {
        return this.map;
    }

    public String toString() {
        StringBuffer lBuf = new StringBuffer();
        lBuf.append("JSONObject(").append(this.getLine()).append(":").append(this.getCol()).append(")[");
        Iterator<String> lIter = this.map.keySet().iterator();
        while (lIter.hasNext()) {
            String lKey = lIter.next();
            lBuf.append(lKey).append(":").append(this.map.get(lKey).toString());
            if (!lIter.hasNext()) continue;
            lBuf.append(", ");
        }
        lBuf.append("]");
        return lBuf.toString();
    }

    @Override
    protected String render(boolean aPretty, String aIndent) {
        StringBuffer lBuf = new StringBuffer();
        Iterator<String> lKeyIter = this.map.keySet().iterator();
        if (aPretty) {
            lBuf.append(aIndent).append("{\n");
            String lIndent = aIndent + "   ";
            String lIndent2 = aIndent + "      ";
            while (lKeyIter.hasNext()) {
                String lKey = lKeyIter.next();
                JSONValue jsonValue = this.map.get(lKey);
                lBuf.append(lIndent).append(ParserUtil.render(lKey, false, ""));
                if (jsonValue.isSimple()) {
                    lBuf.append(" : ").append(jsonValue.render(false, ""));
                } else {
                    lBuf.append(" :\n").append(jsonValue.render(true, lIndent2));
                }
                if (lKeyIter.hasNext()) {
                    lBuf.append(",\n");
                    continue;
                }
                lBuf.append("\n");
            }
            lBuf.append(aIndent).append("}");
        } else {
            lBuf.append("{");
            while (lKeyIter.hasNext()) {
                String lKey = lKeyIter.next();
                JSONValue jsonValue = this.map.get(lKey);
                lBuf.append(ParserUtil.render(lKey, false, "")).append(":").append(jsonValue.render(false));
                if (!lKeyIter.hasNext()) continue;
                lBuf.append(",");
            }
            lBuf.append(aIndent).append("}");
        }
        return lBuf.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSONObject that = (JSONObject)o;
        return this.map.equals(that.map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean containsKey(String aKey) {
        return this.map.containsKey(aKey);
    }

    public JSONValue get(String aKey) {
        return this.map.get(aKey);
    }

    @Override
    public Object strip() {
        HashMap<String, Object> lResult = new HashMap<String, Object>();
        for (String lKey : this.map.keySet()) {
            lResult.put(lKey, this.map.get(lKey).strip());
        }
        return lResult;
    }
}

