/*
 * Decompiled with CFR 0.152.
 */
package com.sdicons.json.mapper.helper.impl;

import com.sdicons.json.mapper.JSONMapper;
import com.sdicons.json.mapper.MapperException;
import com.sdicons.json.mapper.helper.ComplexMapperHelper;
import com.sdicons.json.model.JSONObject;
import com.sdicons.json.model.JSONValue;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;

public class MapMapper
implements ComplexMapperHelper {
    public Class getHelpedClass() {
        return Map.class;
    }

    public Object toJava(JSONValue aValue, Class aRequestedClass) throws MapperException {
        return this.toJava(aValue, aRequestedClass, new Type[0]);
    }

    public Object toJava(JSONValue aValue, Class aRawClass, Type[] aTypes) throws MapperException {
        LinkedHashMap<String, Object> lMapObj;
        if (!aValue.isObject()) {
            throw new MapperException("MapMapper cannot map: " + aValue.getClass().getName());
        }
        if (!Map.class.isAssignableFrom(aRawClass)) {
            throw new MapperException("MapMapper cannot map: " + aValue.getClass().getName());
        }
        JSONObject aObject = (JSONObject)aValue;
        try {
            lMapObj = (LinkedHashMap<String, Object>)aRawClass.newInstance();
        }
        catch (Exception e) {
            lMapObj = new LinkedHashMap<String, Object>();
        }
        if (aTypes.length == 0) {
            for (String lKey : aObject.getValue().keySet()) {
                JSONValue lVal = aObject.getValue().get(lKey);
                lMapObj.put(lKey, JSONMapper.toJava(lVal));
            }
        } else if (aTypes.length == 2) {
            if (!aTypes[0].equals(String.class)) {
                throw new MapperException("MapMapper currently only supports String keys.");
            }
            for (String lKey : aObject.getValue().keySet()) {
                JSONValue lVal = aObject.getValue().get(lKey);
                if (aTypes[1] instanceof Class) {
                    lMapObj.put(lKey, JSONMapper.toJava(lVal, (Class)aTypes[1]));
                    continue;
                }
                lMapObj.put(lKey, JSONMapper.toJava(lVal, (ParameterizedType)aTypes[1]));
            }
        } else {
            throw new MapperException("MapMapper cannot map: " + aValue.getClass().getName());
        }
        return lMapObj;
    }

    public JSONValue toJSON(Object aPojo) throws MapperException {
        JSONObject lObj = new JSONObject();
        if (!Map.class.isAssignableFrom(aPojo.getClass())) {
            throw new MapperException("MapMapper cannot map: " + aPojo.getClass().getName());
        }
        Map lMap = (Map)aPojo;
        for (Object lKey : lMap.keySet()) {
            lObj.getValue().put(lKey.toString(), JSONMapper.toJSON(lMap.get(lKey)));
        }
        return lObj;
    }
}

