/*
 * Decompiled with CFR 0.152.
 */
package com.sdicons.json.helper;

import com.sdicons.json.helper.Helper;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HelperRepository<T extends Helper> {
    private HelperTreeNode<T> root = new HelperTreeNode<RootHelper>(new RootHelper());

    public void addHelper(T aHelper) {
        this.root.insertNode(new HelperTreeNode<T>(aHelper));
    }

    public T findHelper(Class aClass) {
        return this.root.findHelper(aClass);
    }

    private class RootHelper
    implements Helper {
        private RootHelper() {
        }

        public Class getHelpedClass() {
            return Object.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HelperTreeNode<T extends Helper> {
        private T helper;
        private List<HelperTreeNode<T>> children;

        public HelperTreeNode(T aClass) {
            this.helper = aClass;
            this.children = new LinkedList<HelperTreeNode<T>>();
        }

        public T getHelper() {
            return this.helper;
        }

        public boolean insertNode(HelperTreeNode<T> aNode) {
            if (aNode.getHelper().getHelpedClass() == this.helper.getHelpedClass()) {
                this.helper = aNode.getHelper();
                return true;
            }
            if (this.helper.getHelpedClass().isAssignableFrom(aNode.getHelper().getHelpedClass())) {
                boolean insertedToSomeChild = false;
                for (HelperTreeNode<T> aChildren : this.children) {
                    HelperTreeNode<T> lChild = aChildren;
                    boolean lSuccess = lChild.insertNode(aNode);
                    if (!lSuccess) continue;
                    insertedToSomeChild = true;
                    break;
                }
                if (!insertedToSomeChild) {
                    Iterator<HelperTreeNode<T>> lIter2 = this.children.iterator();
                    while (lIter2.hasNext()) {
                        HelperTreeNode<T> lChild = lIter2.next();
                        if (!aNode.getHelper().getHelpedClass().isAssignableFrom(lChild.getHelper().getHelpedClass())) continue;
                        lIter2.remove();
                        aNode.insertNode(lChild);
                    }
                    this.children.add(aNode);
                }
                return true;
            }
            return false;
        }

        T findHelper(Class aClass) {
            if (this.helper.getHelpedClass() == aClass) {
                return this.helper;
            }
            for (HelperTreeNode<T> lChildNode : this.children) {
                T lHelper = lChildNode.findHelper(aClass);
                if (lHelper == null) continue;
                return lHelper;
            }
            if (this.helper.getHelpedClass().isAssignableFrom(aClass)) {
                return this.helper;
            }
            return null;
        }
    }
}

