/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.translate.cache.impl;

import java.time.Duration;
import java.util.HashMap;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.config.Builder;
import org.ehcache.config.ResourceUnit;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ExpiryPolicyBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.units.EntryUnit;
import org.ehcache.config.units.MemoryUnit;
import org.sagacity.sqltoy.translate.cache.TranslateCacheManager;
import org.sagacity.sqltoy.translate.model.TranslateConfigModel;
import org.sagacity.sqltoy.utils.IdUtil;
import org.sagacity.sqltoy.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranslateEhcacheManager
extends TranslateCacheManager {
    protected static final Logger logger = LoggerFactory.getLogger(TranslateEhcacheManager.class);
    private String diskStorePath = null;
    protected static CacheManager cacheManager;

    public void setDiskStorePath(String diskStorePath) {
        this.diskStorePath = diskStorePath;
    }

    @Override
    public HashMap<String, Object[]> getCache(String cacheName, String cacheType) {
        if (cacheManager == null) {
            return null;
        }
        Cache cache = cacheManager.getCache(cacheName, String.class, HashMap.class);
        if (cache == null) {
            return null;
        }
        Object cacheValue = cache.get((Object)(StringUtil.isNotBlank(cacheType) ? cacheType : cacheName));
        if (cacheValue != null) {
            return (HashMap)cacheValue;
        }
        return null;
    }

    @Override
    public boolean hasCache(String cacheName) {
        Cache cache = cacheManager.getCache(cacheName, String.class, HashMap.class);
        return null != cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(TranslateConfigModel cacheConfig, String cacheName, String cacheKey, HashMap<String, Object[]> cacheValue) {
        if (cacheManager == null) {
            return;
        }
        String string = cacheName.intern();
        synchronized (string) {
            Cache cache = cacheManager.getCache(cacheName, String.class, HashMap.class);
            if (cache == null) {
                ResourcePoolsBuilder resBuilder = ResourcePoolsBuilder.newResourcePoolsBuilder();
                resBuilder = resBuilder.heap(cacheConfig.getHeap() < 1 ? 1000L : (long)cacheConfig.getHeap(), (ResourceUnit)EntryUnit.ENTRIES);
                if (cacheConfig.getOffHeap() > 0) {
                    resBuilder = resBuilder.offheap((long)cacheConfig.getOffHeap(), MemoryUnit.MB);
                }
                if (cacheConfig.getDiskSize() > 0) {
                    resBuilder = resBuilder.disk((long)cacheConfig.getDiskSize(), MemoryUnit.MB, true);
                }
                cache = cacheManager.createCache(cacheName, CacheConfigurationBuilder.newCacheConfigurationBuilder(String.class, HashMap.class, (Builder)resBuilder).withExpiry(cacheConfig.getKeepAlive() > 0 ? ExpiryPolicyBuilder.timeToLiveExpiration((Duration)Duration.ofSeconds(cacheConfig.getKeepAlive())) : ExpiryPolicyBuilder.noExpiration()).build());
            }
            if (cacheValue == null) {
                if (StringUtil.isBlank(cacheKey)) {
                    cache.clear();
                } else {
                    cache.remove((Object)cacheKey);
                }
            } else {
                cache.put((Object)(StringUtil.isBlank(cacheKey) ? cacheName : cacheKey), cacheValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear(String cacheName, String cacheType) {
        if (cacheManager == null) {
            return;
        }
        String string = cacheName.intern();
        synchronized (string) {
            Cache cache = cacheManager.getCache(cacheName, String.class, HashMap.class);
            if (cache != null) {
                if (StringUtil.isBlank(cacheType)) {
                    cache.clear();
                } else {
                    cache.remove((Object)cacheType);
                }
            }
        }
    }

    @Override
    public boolean init() {
        if (cacheManager != null) {
            return true;
        }
        logger.debug("\u542f\u52a8ehcache \u7f13\u5b58\u7ba1\u7406\u5668--------------------------------------");
        if (StringUtil.isBlank(this.diskStorePath)) {
            cacheManager = CacheManagerBuilder.newCacheManagerBuilder().build(true);
            return true;
        }
        try {
            cacheManager = CacheManagerBuilder.newCacheManagerBuilder().with(CacheManagerBuilder.persistence((String)this.diskStorePath)).build(true);
            return true;
        }
        catch (Exception e) {
            logger.error("cache file:{} is locked,create cacheManager failure,please stop running progress!", (Object)this.diskStorePath);
            if (cacheManager == null) {
                String realCacheFile = this.diskStorePath.concat(IdUtil.getShortNanoTimeId(null).toPlainString());
                try {
                    logger.warn("sqltoy ehcacheManager create cache file:{}", (Object)realCacheFile);
                    cacheManager = CacheManagerBuilder.newCacheManagerBuilder().with(CacheManagerBuilder.persistence((String)realCacheFile)).build(true);
                    return true;
                }
                catch (Exception e2) {
                    logger.error("cann't create cacheManager with file:{},you cann't use cacheTranslate!", (Object)realCacheFile);
                }
            }
            return false;
        }
    }

    @Override
    public void destroy() {
        if (cacheManager != null) {
            cacheManager.close();
            cacheManager = null;
        }
    }
}

