/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.plugins.sharding.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.sql.DataSource;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.config.model.ShardingDBModel;
import org.sagacity.sqltoy.integration.impl.SpringAppContext;
import org.sagacity.sqltoy.integration.impl.SpringConnectionFactory;
import org.sagacity.sqltoy.model.IgnoreCaseLinkedMap;
import org.sagacity.sqltoy.plugins.sharding.IdleConnectionMonitor;
import org.sagacity.sqltoy.plugins.sharding.ShardingStrategy;
import org.sagacity.sqltoy.utils.DateUtil;
import org.sagacity.sqltoy.utils.NumberUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DefaultShardingStrategy
implements ShardingStrategy,
ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(DefaultShardingStrategy.class);
    private Map<String, String> tableNamesMap = new HashMap<String, String>();
    private Integer[] days = new Integer[]{180};
    @Deprecated
    private String[] dateParams = new String[]{"begindate", "begintime", "bizdate", "biztime", "businessdate", "businesstime"};
    private int checkSeconds = 180;
    private Map<String, Integer> dataSourceWeight;
    private Object[][] dataSourceWeightConfig;
    private int[] weights;
    private ApplicationContext applicationContext;

    @Autowired
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public void initialize() {
        if (this.dataSourceWeight == null || this.dataSourceWeight.isEmpty()) {
            return;
        }
        this.dataSourceWeightConfig = new Object[this.dataSourceWeight.size()][2];
        this.weights = new int[this.dataSourceWeight.size()];
        Iterator<Map.Entry<String, Integer>> entryIter = this.dataSourceWeight.entrySet().iterator();
        int i = 0;
        while (entryIter.hasNext()) {
            Map.Entry<String, Integer> entry = entryIter.next();
            this.dataSourceWeightConfig[i] = new Object[]{entry.getKey(), entry.getValue()};
            this.weights[i] = entry.getValue();
            ++i;
        }
        if (this.checkSeconds <= 0) {
            return;
        }
        if (this.checkSeconds < 60) {
            this.checkSeconds = 60;
        }
        SpringAppContext appContext = new SpringAppContext();
        appContext.setContext(this.applicationContext);
        IdleConnectionMonitor monitor = new IdleConnectionMonitor(appContext, new SpringConnectionFactory(), this.dataSourceWeightConfig, this.weights, 60, this.checkSeconds);
        monitor.start();
    }

    @Override
    public String getShardingTable(SqlToyContext sqlToyContext, Class entityClass, String baseTableName, String decisionType, IgnoreCaseLinkedMap<String, Object> paramsMap) {
        if (paramsMap == null || baseTableName == null || this.tableNamesMap == null) {
            return null;
        }
        if (this.tableNamesMap.get(baseTableName.toUpperCase()) == null) {
            return null;
        }
        Object bizDate = null;
        String[] shardingTable = this.tableNamesMap.get(baseTableName.toUpperCase()).split("\\,");
        if (paramsMap.size() == 1) {
            bizDate = paramsMap.values().iterator().next();
        } else if (this.dateParams != null) {
            for (int i = 0; i < this.dateParams.length && (bizDate = paramsMap.get(this.dateParams[i])) == null; ++i) {
            }
        }
        if (bizDate == null) {
            logger.error("\u5206\u8868\u64cd\u4f5c\u5bf9\u5e94\u7684\u53c2\u6570\u503c\u4e3anull,\u5bfc\u81f4\u65e0\u6cd5\u5206\u8868,\u8bf7\u68c0\u67e5\u53c2\u6570\u914d\u7f6e!");
            return null;
        }
        int intervalDays = Math.abs(DateUtil.getIntervalDays(DateUtil.getNowTime(), bizDate));
        int index = -1;
        for (int i = 0; i < this.days.length; ++i) {
            if (intervalDays < this.days[i]) continue;
            index = i;
            break;
        }
        if (index == -1) {
            logger.debug("\u65e5\u671f\u95f4\u9694:{} \u5929,\u5c0f\u4e8e\u6700\u5c0f\u5206\u8868\u533a\u95f4\u5219\u4f7f\u7528\u5f53\u524dsql\u4e2d\u7684\u8868!", (Object)intervalDays);
            return null;
        }
        String tableName = index > shardingTable.length - 1 ? shardingTable[shardingTable.length - 1].trim() : shardingTable[index].trim();
        logger.debug("\u5206\u8868\u5b9e\u9645\u53d6\u5f97\u8868\u540d:{}", (Object)tableName);
        return tableName;
    }

    @Override
    public ShardingDBModel getShardingDB(SqlToyContext sqlToyContext, Class entityClass, String tableOrSql, String decisionType, IgnoreCaseLinkedMap<String, Object> paramsMap) {
        if (this.dataSourceWeight == null || this.dataSourceWeight.isEmpty()) {
            return null;
        }
        return this.getDataSource();
    }

    private ShardingDBModel getDataSource() {
        int index = 0;
        String chooseDataSource = null;
        if (this.dataSourceWeightConfig.length > 1) {
            index = NumberUtil.getProbabilityIndex(this.weights);
        }
        chooseDataSource = this.dataSourceWeightConfig[index][0].toString();
        logger.debug("\u5206\u5e93\u53d6\u5f97\u7684\u6570\u636e\u5e93\u4e3a:{},index={}", (Object)chooseDataSource, (Object)index);
        ShardingDBModel shardingModel = new ShardingDBModel();
        shardingModel.setDataSourceName(chooseDataSource);
        shardingModel.setDataSource((DataSource)this.applicationContext.getBean(chooseDataSource));
        return shardingModel;
    }

    public void setDataSourceWeight(Map<String, Integer> dataSourceWeight) {
        this.dataSourceWeight = dataSourceWeight;
    }

    public void setCheckSeconds(int checkSeconds) {
        this.checkSeconds = checkSeconds;
    }

    public void setTableNamesMap(Map<String, String> tableMap) {
        for (Map.Entry<String, String> entry : tableMap.entrySet()) {
            this.tableNamesMap.put(entry.getKey().toUpperCase(), entry.getValue());
        }
    }

    public void setDays(String days) {
        String[] daysAry = days.split("\\,");
        this.days = new Integer[daysAry.length];
        for (int i = 0; i < daysAry.length; ++i) {
            this.days[i] = Integer.parseInt(daysAry[i].trim());
        }
    }

    public void setDateParams(String dateParams) {
        this.dateParams = dateParams.toLowerCase().split("\\,");
    }
}

