/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.sagacity.sqltoy.SqlToyConstants;
import org.sagacity.sqltoy.config.ScanEntityAndSqlResource;
import org.sagacity.sqltoy.config.SqlConfigParseUtils;
import org.sagacity.sqltoy.config.SqlFileModifyWatcher;
import org.sagacity.sqltoy.config.SqlXMLConfigParse;
import org.sagacity.sqltoy.config.model.ParamFilterModel;
import org.sagacity.sqltoy.config.model.SqlToyConfig;
import org.sagacity.sqltoy.config.model.SqlType;
import org.sagacity.sqltoy.dialect.utils.PageOptimizeUtils;
import org.sagacity.sqltoy.exception.DataAccessException;
import org.sagacity.sqltoy.plugins.function.FunctionUtils;
import org.sagacity.sqltoy.plugins.id.macro.AbstractMacro;
import org.sagacity.sqltoy.plugins.id.macro.MacroUtils;
import org.sagacity.sqltoy.plugins.id.macro.impl.Include;
import org.sagacity.sqltoy.utils.DataSourceUtils;
import org.sagacity.sqltoy.utils.ReservedWordsUtil;
import org.sagacity.sqltoy.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlScriptLoader {
    private static final Logger logger = LoggerFactory.getLogger(SqlScriptLoader.class);
    private ConcurrentHashMap<String, SqlToyConfig> sqlCache = new ConcurrentHashMap(256);
    private ConcurrentHashMap<String, SqlToyConfig> codeSqlCache = new ConcurrentHashMap(128);
    private String sqlResourcesDir;
    private List sqlResources;
    private String dialect;
    private String encoding = "UTF-8";
    private List realSqlList;
    private boolean initialized = false;
    private SqlFileModifyWatcher watcher;
    private int maxWait = 86400;
    private ConcurrentHashMap<String, Long> filesLastModifyMap = new ConcurrentHashMap();
    private static Map<String, AbstractMacro> macros = new HashMap<String, AbstractMacro>();

    public void initialize(boolean debug, int delayCheckSeconds, Integer scriptCheckIntervalSeconds, boolean breakWhenSqlRepeat) throws Exception {
        if (StringUtil.isNotBlank(this.sqlResourcesDir) && (this.sqlResourcesDir.toLowerCase().contains(".sql.xml") || this.sqlResourcesDir.contains("*"))) {
            throw new IllegalArgumentException("\n\u60a8\u7684\u914d\u7f6e:spring.sqltoy.sqlResourcesDir=" + this.sqlResourcesDir + " \u4e0d\u6b63\u786e!\n/*----\u6b63\u786e\u683c\u5f0f\u53ea\u63a5\u53d7\u5355\u4e2a\u6216\u9017\u53f7\u5206\u9694\u7684\u591a\u4e2a\u8def\u5f84\u6a21\u5f0f\u4e14\u4e0d\u80fd\u6709*\u548c**\u4ee5\u53ca*.sql.xml\u7b49\u914d\u7b26(\u4f1a\u81ea\u52a8\u9012\u5f52\u5f80\u4e0b\u94bb\u53d6!)----*/\n/*- 1\u3001\u5355\u8def\u5f84\u6a21\u5f0f:spring.sqltoy.sqlResourcesDir=classpath:com/sagacity/crm\n/*- 2\u3001\u591a\u8def\u5f84\u6a21\u5f0f:spring.sqltoy.sqlResourcesDir=classpath:com/sagacity/crm,classpath:com/sagacity/hr\n/*- 3\u3001\u7edd\u5bf9\u8def\u5f84\u6a21\u5f0f:spring.sqltoy.sqlResourcesDir=/home/web/project/sql\n/*-----------\u9519\u8bef\u8303\u4f8b(\u8bf7\u770b\u4ed4\u7ec6:\u4e0d\u80fd\u6709*\u3001**\u548c*.sql.xml)----------------------*/\n/*-1\u3001classpath:*/com/yourproject/yourpackage/**/*.sql.xml\n/*-2\u3001classpath*:/com/yourproject/yourpackage/**/**.sql.xml\n/*-----------------------------------------------------------------------*/");
        }
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        boolean enabledDebug = logger.isDebugEnabled();
        try {
            this.realSqlList = ScanEntityAndSqlResource.getSqlResources(this.sqlResourcesDir, this.sqlResources);
            if (this.realSqlList != null && !this.realSqlList.isEmpty()) {
                if (enabledDebug) {
                    logger.debug("\u603b\u8ba1\u5c06\u52a0\u8f7d.sql.xml\u6587\u4ef6\u6570\u91cf\u4e3a:{}", (Object)this.realSqlList.size());
                    logger.debug("\u5982\u679c.sql.xml\u6587\u4ef6\u4e0d\u5728\u4e0b\u5217\u6e05\u5355\u4e2d,\u5f88\u53ef\u80fd\u662f\u6587\u4ef6\u6ca1\u6709\u5728\u7f16\u8bd1\u8def\u5f84\u4e0b(bin\u3001classes\u7b49),\u8bf7\u4ed4\u7ec6\u68c0\u67e5!");
                } else {
                    System.out.println("\u603b\u8ba1\u5c06\u52a0\u8f7d.sql.xml\u6587\u4ef6\u6570\u91cf\u4e3a:" + this.realSqlList.size());
                    System.out.println("\u5982\u679c.sql.xml\u6587\u4ef6\u4e0d\u5728\u4e0b\u5217\u6e05\u5355\u4e2d,\u5f88\u53ef\u80fd\u662f\u6587\u4ef6\u6ca1\u6709\u5728\u7f16\u8bd1\u8def\u5f84\u4e0b(bin\u3001classes\u7b49),\u8bf7\u4ed4\u7ec6\u68c0\u67e5!");
                }
                ArrayList<String> repeatSql = new ArrayList<String>();
                for (int i = 0; i < this.realSqlList.size(); ++i) {
                    repeatSql.addAll(SqlXMLConfigParse.parseSingleFile(this.realSqlList.get(i), this.filesLastModifyMap, this.sqlCache, this.encoding, this.dialect, false, i));
                }
                int repeatSqlSize = repeatSql.size();
                if (repeatSqlSize > 0) {
                    StringBuilder repeatSqlIds = new StringBuilder();
                    repeatSqlIds.append("\n/*----------- \u603b\u8ba1\u53d1\u73b0:" + repeatSqlSize + " \u4e2a\u91cd\u590d\u7684sqlId,\u8bf7\u68c0\u67e5\u5904\u7406---------------\n");
                    if (breakWhenSqlRepeat) {
                        repeatSqlIds.append("/*--\u63d0\u793a:\u8bbe\u7f6e spring.sqltoy.breakWhenSqlRepeat=false \u53ef\u5141\u8bb8sqlId\u91cd\u590d\u5e76\u8986\u76d6!-------\n");
                    }
                    for (String repeat : repeatSql) {
                        repeatSqlIds.append("/*--").append(repeat).append("\n");
                    }
                    if (breakWhenSqlRepeat) {
                        logger.error(repeatSqlIds.toString());
                    } else {
                        logger.warn(repeatSqlIds.toString());
                    }
                    if (breakWhenSqlRepeat) {
                        throw new Exception(repeatSqlIds.toString());
                    }
                }
            } else if (enabledDebug) {
                logger.debug("\u603b\u8ba1\u52a0\u8f7d*.sql.xml\u6587\u4ef6\u6570\u91cf\u4e3a:0 !");
                logger.debug("\u8bf7\u68c0\u67e5\u914d\u7f6e\u9879sqlResourcesDir={}\u662f\u5426\u6b63\u786e(\u5982:\u5b57\u6bcd\u62fc\u5199),\u6216\u6587\u4ef6\u6ca1\u6709\u5728\u7f16\u8bd1\u8def\u5f84\u4e0b(bin\u3001classes\u7b49)!", (Object)this.sqlResourcesDir);
            } else {
                System.out.println("\u603b\u8ba1\u52a0\u8f7d*.sql.xml\u6587\u4ef6\u6570\u91cf\u4e3a:0 !");
                System.out.println("\u8bf7\u68c0\u67e5\u914d\u7f6e\u9879sqlResourcesDir=[" + this.sqlResourcesDir + "]\u662f\u5426\u6b63\u786e(\u5982:\u5b57\u6bcd\u62fc\u5199),\u6216\u6587\u4ef6\u6ca1\u6709\u5728\u7f16\u8bd1\u8def\u5f84\u4e0b(bin\u3001classes\u7b49)!");
            }
        }
        catch (Exception e) {
            logger.error("\u52a0\u8f7d\u548c\u89e3\u6790\u4ee5sql.xml\u7ed3\u5c3e\u7684\u6587\u4ef6\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38!" + e.getMessage(), (Throwable)e);
            throw e;
        }
        if (this.realSqlList != null && !this.realSqlList.isEmpty()) {
            int sleepSeconds = 0;
            sleepSeconds = scriptCheckIntervalSeconds == null ? (debug ? 2 : 15) : scriptCheckIntervalSeconds;
            if (sleepSeconds > 0 && sleepSeconds <= this.maxWait) {
                if (enabledDebug) {
                    logger.debug("\u5df2\u7ecf\u5f00\u542fsql\u6587\u4ef6\u53d8\u66f4\u68c0\u6d4b\uff0c\u4f1a\u81ea\u52a8\u95f4\u9694:{}\u79d2\u68c0\u6d4b\u4e00\u6b21,\u53d1\u751f\u53d8\u66f4\u4f1a\u81ea\u52a8\u91cd\u65b0\u8f7d\u5165!", (Object)sleepSeconds);
                } else {
                    System.out.println("\u5df2\u7ecf\u5f00\u542fsql\u6587\u4ef6\u53d8\u66f4\u68c0\u6d4b\uff0c\u4f1a\u81ea\u52a8\u95f4\u9694:" + sleepSeconds + "\u79d2\u68c0\u6d4b\u4e00\u6b21,\u53d1\u751f\u53d8\u66f4\u4f1a\u81ea\u52a8\u91cd\u65b0\u8f7d\u5165!");
                }
                this.watcher = new SqlFileModifyWatcher(this.sqlCache, this.filesLastModifyMap, this.realSqlList, this.dialect, this.encoding, delayCheckSeconds, sleepSeconds);
                this.watcher.start();
            } else {
                logger.warn("sql\u6587\u4ef6\u66f4\u65b0\u68c0\u6d4b:sleepSeconds={} \u5c0f\u4e8e1\u79d2\u6216\u5927\u4e8e24\u5c0f\u65f6\uff0c\u8868\u793a\u5173\u95edsql\u6587\u4ef6\u53d8\u66f4\u68c0\u6d4b!", (Object)sleepSeconds);
            }
        }
    }

    public SqlToyConfig getSqlConfig(String sqlKey, SqlType sqlType, String dialect, Object paramValues, boolean blankToNull) {
        String realDialect;
        if (StringUtil.isBlank(sqlKey)) {
            throw new IllegalArgumentException("sql or sqlId is null!");
        }
        SqlToyConfig result = null;
        String string = realDialect = dialect == null ? "" : dialect.toLowerCase();
        if (SqlConfigParseUtils.isNamedQuery(sqlKey)) {
            if (!"".equals(realDialect)) {
                result = this.sqlCache.get(sqlKey.concat("_").concat(realDialect));
                if (result == null) {
                    result = this.sqlCache.get(realDialect.concat("_").concat(sqlKey));
                }
                if (result == null && realDialect.equals("sqlserver") && (result = this.sqlCache.get(sqlKey.concat("_mssql"))) == null) {
                    result = this.sqlCache.get("mssql_".concat(sqlKey));
                }
                if (result == null && realDialect.equals("postgresql") && (result = this.sqlCache.get(sqlKey.concat("_postgres"))) == null) {
                    result = this.sqlCache.get("postgres_".concat(sqlKey));
                }
            }
            if (result == null && (result = this.sqlCache.get(sqlKey)) == null) {
                throw new DataAccessException("\n\u53d1\u751f\u9519\u8bef:sqlId=[" + sqlKey + "]\u65e0\u5bf9\u5e94\u7684sql\u914d\u7f6e,\u8bf7\u68c0\u67e5\u5bf9\u5e94\u7684sql.xml\u6587\u4ef6\u662f\u5426\u88ab\u6b63\u786e\u52a0\u8f7d!\n/*----------------------\u9519\u8bef\u53ef\u80fd\u7684\u539f\u56e0\u5982\u4e0b---------------------*/\n/* 1\u3001\u68c0\u67e5: spring.sqltoy.sqlResourcesDir=[" + this.sqlResourcesDir + "]\u914d\u7f6e(\u5982:\u5b57\u6bcd\u62fc\u5199),\u4f1a\u5bfc\u81f4sql\u6587\u4ef6\u6ca1\u6709\u88ab\u52a0\u8f7d;\n/* 2\u3001sql.xml\u6587\u4ef6\u6ca1\u6709\u88ab\u7f16\u8bd1\u5230classes\u76ee\u5f55\u4e0b\u9762;\u8bf7\u68c0\u67e5maven\u7684\u7f16\u8bd1\u914d\u7f6e                        \n/* 3\u3001sqlId\u5bf9\u5e94\u7684\u6587\u4ef6\u5185\u90e8\u9519\u8bef!\u7248\u672c\u5408\u5e76\u6216\u4e66\u5199\u9519\u8bef\u4f1a\u5bfc\u81f4\u5355\u4e2a\u6587\u4ef6\u89e3\u6790\u9519\u8bef                          \n/* ------------------------------------------------------------*/");
            }
            if (result != null && result.isHasIncludeSql()) {
                boolean isParamInclude = StringUtil.matches(result.getSql(), SqlToyConstants.INCLUDE_PARAM_PATTERN);
                if (isParamInclude) {
                    result = result.clone();
                    result.clearDialectSql();
                }
                String sql = MacroUtils.replaceMacros(result.getSql(), this.sqlCache, paramValues, false, macros);
                SqlToyConfig tmpConfig = SqlConfigParseUtils.parseSqlToyConfig(sql, realDialect, sqlType);
                result.setHasUnion(tmpConfig.isHasUnion());
                result.setHasWith(tmpConfig.isHasWith());
                result.setHasFast(tmpConfig.isHasFast());
                result.setFastSql(tmpConfig.getFastSql(null));
                result.setFastPreSql(tmpConfig.getFastPreSql(null));
                result.setFastTailSql(tmpConfig.getFastTailSql(null));
                result.setFastWithSql(tmpConfig.getFastWithSql(null));
                result.setSql(tmpConfig.getSql());
                result.setParamsName(tmpConfig.getParamsName());
                String countSql = result.getCountSql(null);
                if (countSql != null && StringUtil.matches(countSql, SqlToyConstants.INCLUDE_PATTERN)) {
                    countSql = MacroUtils.replaceMacros(countSql, this.sqlCache, paramValues, false, macros);
                    countSql = FunctionUtils.getDialectSql(countSql, realDialect);
                    countSql = ReservedWordsUtil.convertSql(countSql, DataSourceUtils.getDBType(realDialect));
                    result.setCountSql(countSql);
                }
                if (!isParamInclude) {
                    result.setHasIncludeSql(false);
                }
            }
        } else {
            result = this.codeSqlCache.get(sqlKey);
            if (result == null) {
                boolean hasInclude = StringUtil.matches(sqlKey, SqlToyConstants.INCLUDE_PATTERN);
                boolean isParamInclude = false;
                if (hasInclude) {
                    isParamInclude = StringUtil.matches(sqlKey, SqlToyConstants.INCLUDE_PARAM_PATTERN);
                    String sql = MacroUtils.replaceMacros(sqlKey, this.sqlCache, paramValues, false, macros);
                    result = SqlConfigParseUtils.parseSqlToyConfig(sql, realDialect, sqlType);
                } else {
                    result = SqlConfigParseUtils.parseSqlToyConfig(sqlKey, realDialect, sqlType);
                }
                if (blankToNull) {
                    result.addFilter(new ParamFilterModel("blank", new String[]{"*"}));
                }
                if (!isParamInclude && this.codeSqlCache.size() < SqlToyConstants.getMaxCodeSqlCount()) {
                    this.codeSqlCache.put(sqlKey, result);
                }
            }
        }
        return result;
    }

    public SqlToyConfig parseSqlSagment(Object sqlSegment) throws Exception {
        return SqlXMLConfigParse.parseSagment(sqlSegment, this.encoding, this.dialect);
    }

    public void parseSqlFile(Object sqlFile) throws Exception {
        SqlXMLConfigParse.parseSingleFile(sqlFile, this.filesLastModifyMap, this.sqlCache, this.encoding, this.dialect, true, -1);
    }

    public void putSqlToyConfig(SqlToyConfig sqlToyConfig) throws Exception {
        if (sqlToyConfig == null || StringUtil.isBlank(sqlToyConfig.getId())) {
            logger.warn("sqlToyConfig is null \u6216\u8005 id \u4e3anull!");
            return;
        }
        if (this.sqlCache.containsKey(sqlToyConfig.getId())) {
            logger.warn("\u53d1\u73b0\u91cd\u590d\u7684SQL\u8bed\u53e5:id={} \u5c06\u88ab\u8986\u76d6!", (Object)sqlToyConfig.getId());
            PageOptimizeUtils.remove(sqlToyConfig.getId());
        }
        this.sqlCache.put(sqlToyConfig.getId(), sqlToyConfig);
    }

    public void setSqlResourcesDir(String sqlResourcesDir) {
        this.sqlResourcesDir = sqlResourcesDir;
    }

    public void setSqlResources(List sqlResources) {
        this.sqlResources = sqlResources;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    public String getDialect() {
        return this.dialect;
    }

    public void destroy() {
        try {
            if (this.watcher != null && !this.watcher.isInterrupted()) {
                this.watcher.interrupt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        macros.put("@include", new Include());
    }
}

