/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.plugins.calculator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.sagacity.sqltoy.config.model.LabelIndexModel;
import org.sagacity.sqltoy.config.model.UnpivotModel;
import org.sagacity.sqltoy.model.inner.DataSetResult;
import org.sagacity.sqltoy.utils.CollectionUtil;
import org.sagacity.sqltoy.utils.NumberUtil;

public class UnpivotList {
    public static List process(UnpivotModel unpivotModel, DataSetResult resultModel, LabelIndexModel labelIndexMap, List result) {
        if (result == null || result.isEmpty()) {
            return result;
        }
        try {
            if (unpivotModel.getGroupSize() > 1) {
                return UnpivotList.multGroupUnpivot(unpivotModel, resultModel, labelIndexMap, result);
            }
            int cols = unpivotModel.getColumnsToRows().length;
            ArrayList<List> newResult = new ArrayList<List>();
            Integer[] unpivotCols = new Integer[cols];
            Object[] sortUnpivotCols = new Integer[cols];
            String[] indexColValues = new String[cols];
            String[] colsAndIndexValue = null;
            for (int i = 0; i < cols; ++i) {
                colsAndIndexValue = unpivotModel.getColumnsToRows()[i].replaceFirst("\\\uff1a", ":").split("\\:");
                String colIndex = colsAndIndexValue[0].toLowerCase().trim();
                unpivotCols[i] = NumberUtil.isInteger(colIndex) ? Integer.valueOf(Integer.parseInt(colIndex)) : labelIndexMap.get(colIndex);
                indexColValues[i] = colsAndIndexValue.length > 1 ? colsAndIndexValue[1].trim() : colsAndIndexValue[0].trim();
                sortUnpivotCols[i] = unpivotCols[i];
            }
            CollectionUtil.sortArray(sortUnpivotCols, true);
            int addIndex = (Integer)sortUnpivotCols[sortUnpivotCols.length - 1];
            if (addIndex < 0) {
                addIndex = 0;
            }
            int resultSize = result.size() * cols;
            for (int i = 0; i < resultSize; ++i) {
                List row = (List)((ArrayList)result.get(i / cols)).clone();
                row.add(addIndex, indexColValues[i % cols]);
                row.add(addIndex + 1, row.get(unpivotCols[i % cols] + 1));
                for (int j = 0; j < cols; ++j) {
                    row.remove((Integer)sortUnpivotCols[j] + 2);
                }
                newResult.add(row);
            }
            String[] labelNames = resultModel.getLabelNames();
            String[] labelTypes = resultModel.getLabelTypes();
            ArrayList<String> labelList = new ArrayList<String>();
            ArrayList<String> labelTypeList = new ArrayList<String>();
            for (int i = 0; i < labelNames.length; ++i) {
                labelList.add(labelNames[i]);
                labelTypeList.add(labelTypes[i]);
            }
            String[] newColsLabels = unpivotModel.getNewColumnsLabels();
            if (newColsLabels == null || newColsLabels.length == 0) {
                newColsLabels = new String[]{"indexName", "indexValue"};
            }
            labelList.add(addIndex, newColsLabels[0]);
            labelTypeList.add(addIndex, "string");
            labelList.add(addIndex + 1, newColsLabels[1]);
            labelTypeList.add(addIndex + 1, "object");
            for (int j = 0; j < cols; ++j) {
                labelList.remove((Integer)sortUnpivotCols[j] + 2);
                labelTypeList.remove((Integer)sortUnpivotCols[j] + 2);
            }
            String[] newLabelNames = new String[labelList.size()];
            String[] newLabelTypes = new String[labelList.size()];
            labelList.toArray(newLabelNames);
            labelTypeList.toArray(newLabelTypes);
            resultModel.setLabelNames(newLabelNames);
            resultModel.setLabelTypes(newLabelTypes);
            return newResult;
        }
        catch (IndexOutOfBoundsException iot) {
            iot.printStackTrace();
            throw new RuntimeException("\u5217\u8f6c\u884c\u5904\u7406\u51fa\u73b0\u6570\u7ec4\u8d8a\u754c,\u8bf7\u68c0\u67e5columns-to-rows\u3001new-columns-labels(\u7c7b\u4f3c=indexName,indexValue\u662f\u4e24\u4e2a\u5c5e\u6027)\u914d\u7f6e\u662f\u5426\u5408\u6cd5\uff01" + iot.getMessage());
        }
    }

    private static List multGroupUnpivot(UnpivotModel unpivotModel, DataSetResult resultModel, LabelIndexModel labelIndexMap, List result) {
        int i;
        int pivotRows = unpivotModel.getColumnsToRows()[0].replace("{", "").replace("}", "").trim().split("\\,").length;
        int groupSize = unpivotModel.getGroupSize();
        int totalUnpivotCols = groupSize * pivotRows;
        Integer[][] unpivotCols = new Integer[groupSize][pivotRows];
        Object[] sortUnpivotCols = new Integer[totalUnpivotCols];
        String[] indexColValues = new String[pivotRows];
        String[] colsAndIndexValue = null;
        for (int i2 = 0; i2 < groupSize; ++i2) {
            String[] groupCols = unpivotModel.getColumnsToRows()[i2].replace("{", "").replace("}", "").trim().split("\\,");
            if (groupCols.length != pivotRows) {
                throw new IllegalArgumentException("unpivot\u591a\u7ec4\u5217\u8f6c\u884c\uff0c\u6bcf\u7ec4{col1,col2}\u7684\u957f\u5ea6\u5fc5\u987b\u4e00\u81f4,\u7b2c{" + (i2 + 1) + "}\u7ec4\u65cb\u8f6c\u5217\u6570\u4e3a:" + groupCols.length + "!=" + pivotRows + "\u8bf7\u68c0\u67e5:columns-to-rows \u5c5e\u6027\u914d\u7f6e\u6b63\u786e\u6027!");
            }
            for (int j = 0; j < pivotRows; ++j) {
                colsAndIndexValue = groupCols[j].replaceFirst("\\\uff1a", ":").split("\\:");
                String colIndex = colsAndIndexValue[0].toLowerCase().trim();
                unpivotCols[i2][j] = NumberUtil.isInteger(colIndex) ? Integer.valueOf(Integer.parseInt(colIndex)) : labelIndexMap.get(colIndex);
                if (i2 == 0) {
                    indexColValues[j] = colsAndIndexValue.length > 1 ? colsAndIndexValue[1].trim() : colsAndIndexValue[0].trim();
                }
                sortUnpivotCols[i2 * pivotRows + j] = unpivotCols[i2][j];
            }
        }
        CollectionUtil.sortArray(sortUnpivotCols, true);
        int addIndex = (Integer)sortUnpivotCols[sortUnpivotCols.length - 1];
        if (addIndex < 0) {
            addIndex = 0;
        }
        int resultSize = result.size() * pivotRows;
        ArrayList<List> newResult = new ArrayList<List>();
        for (int i3 = 0; i3 < resultSize; ++i3) {
            int j;
            List row = (List)((ArrayList)result.get(i3 / pivotRows)).clone();
            row.add(addIndex, indexColValues[i3 % pivotRows]);
            for (j = 0; j < groupSize; ++j) {
                row.add(addIndex + 1 + j, row.get(unpivotCols[j][i3 % pivotRows] + 1 + j));
            }
            for (j = 0; j < totalUnpivotCols; ++j) {
                row.remove((Integer)sortUnpivotCols[j] + 1 + groupSize);
            }
            newResult.add(row);
        }
        String[] labelNames = resultModel.getLabelNames();
        String[] labelTypes = resultModel.getLabelTypes();
        ArrayList<String> labelList = new ArrayList<String>();
        ArrayList<String> labelTypeList = new ArrayList<String>();
        for (int i4 = 0; i4 < labelNames.length; ++i4) {
            labelList.add(labelNames[i4]);
            labelTypeList.add(labelTypes[i4]);
        }
        String[] newColsLabels = unpivotModel.getNewColumnsLabels();
        if (newColsLabels == null || newColsLabels.length == 0) {
            newColsLabels = new String[1 + groupSize];
            newColsLabels[0] = "indexName";
            for (i = 0; i < groupSize; ++i) {
                newColsLabels[1 + i] = "indexValue" + (Serializable)(i == 0 ? "" : Integer.valueOf(i));
            }
        } else if (newColsLabels.length != groupSize + 1) {
            throw new IllegalArgumentException("unpivot\u591a\u7ec4\u5217\u8f6c\u884cnew-columns-labels\u8bbe\u7f6e\u9519\u8bef,1\u5217\u6307\u6807\u540d\u79f0+" + groupSize + "\u5217\u65cb\u8f6c\u6240\u5f97\u65b0\u5217,\u5e94\u8be5\u8bbe\u7f6e:" + (1 + groupSize) + " \u4e2a\u5217\u5c5e\u6027\u540d\u79f0!\u683c\u5f0f\u5982:\"\u5b63\u5ea6,\u6700\u5c0f\u8425\u4e1a\u989d,\u6700\u5927\u8425\u4e1a\u989d\"");
        }
        labelList.add(addIndex, newColsLabels[0]);
        labelTypeList.add(addIndex, "string");
        for (i = 0; i < groupSize; ++i) {
            labelList.add(addIndex + 1 + i, newColsLabels[1 + i]);
            labelTypeList.add(addIndex + 1 + i, "object");
        }
        for (i = 0; i < totalUnpivotCols; ++i) {
            labelList.remove((Integer)sortUnpivotCols[i] + 1 + groupSize);
            labelTypeList.remove((Integer)sortUnpivotCols[i] + 1 + groupSize);
        }
        String[] newLabelNames = new String[labelList.size()];
        String[] newLabelTypes = new String[labelList.size()];
        labelList.toArray(newLabelNames);
        labelTypeList.toArray(newLabelTypes);
        resultModel.setLabelNames(newLabelNames);
        resultModel.setLabelTypes(newLabelTypes);
        return newResult;
    }
}

