/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.link;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.List;
import javax.sql.DataSource;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.config.model.ElasticEndpoint;
import org.sagacity.sqltoy.config.model.NoSqlConfigModel;
import org.sagacity.sqltoy.config.model.SqlToyConfig;
import org.sagacity.sqltoy.config.model.SqlType;
import org.sagacity.sqltoy.exception.DataAccessException;
import org.sagacity.sqltoy.link.BaseLink;
import org.sagacity.sqltoy.model.Page;
import org.sagacity.sqltoy.model.QueryExecutor;
import org.sagacity.sqltoy.plugins.nosql.ElasticSearchPlugin;
import org.sagacity.sqltoy.plugins.nosql.ElasticSqlPlugin;
import org.sagacity.sqltoy.utils.StringUtil;

public class Elastic
extends BaseLink {
    private static final long serialVersionUID = -3963816230256439625L;
    private final String ERROR_MESSAGE = "ES\u67e5\u8be2\u8bf7\u4f7f\u7528<eql></eql>\u914d\u7f6e!";
    private String endPoint;
    private String sql;
    private String[] names;
    private Object[] values;
    private Serializable entity;
    private Type resultType;
    private Boolean humpMapLabel;

    public Elastic(SqlToyContext sqlToyContext, DataSource dataSource) {
        super(sqlToyContext, dataSource);
    }

    public Elastic sql(String sql) {
        this.sql = sql;
        return this;
    }

    public Elastic names(String ... names) {
        this.names = names;
        return this;
    }

    public Elastic values(Object ... values) {
        this.values = values;
        return this;
    }

    public Elastic entity(Serializable entityVO) {
        this.entity = entityVO;
        return this;
    }

    public Elastic endPoint(String endPoint) {
        this.endPoint = endPoint;
        return this;
    }

    public Elastic resultType(Type resultType) {
        this.resultType = resultType;
        return this;
    }

    public Elastic humpMapLabel(Boolean humpMapLabel) {
        this.humpMapLabel = humpMapLabel;
        return this;
    }

    public Object getOne() {
        List<?> result = this.find();
        if (result == null || result.isEmpty()) {
            return null;
        }
        if (result.size() == 1) {
            return result.get(0);
        }
        throw new IllegalArgumentException("getOne\u67e5\u8be2\u51fa:" + result.size() + " \u6761\u8bb0\u5f55,\u4e0d\u7b26\u5408getOne\u67e5\u8be2\u9884\u671f!");
    }

    public List<?> find() {
        QueryExecutor queryExecutor = this.build();
        SqlToyConfig sqlToyConfig = this.sqlToyContext.getSqlToyConfig(this.sql, SqlType.search, "", null);
        if (sqlToyConfig.getNoSqlConfigModel() == null) {
            throw new IllegalArgumentException("ES\u67e5\u8be2\u8bf7\u4f7f\u7528<eql></eql>\u914d\u7f6e!");
        }
        SqlToyConfig realSqlConfig = null;
        if (StringUtil.isNotBlank(this.endPoint)) {
            realSqlConfig = sqlToyConfig.clone();
            realSqlConfig.getNoSqlConfigModel().setEndpoint(this.endPoint);
        } else {
            realSqlConfig = sqlToyConfig;
        }
        try {
            if (realSqlConfig.getNoSqlConfigModel().isSqlMode()) {
                return ElasticSqlPlugin.findTop(this.sqlToyContext, realSqlConfig, queryExecutor, null);
            }
            return ElasticSearchPlugin.findTop(this.sqlToyContext, realSqlConfig, queryExecutor, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DataAccessException(e);
        }
    }

    public List<?> findTop(int topSize) {
        QueryExecutor queryExecutor = this.build();
        SqlToyConfig sqlToyConfig = this.sqlToyContext.getSqlToyConfig(this.sql, SqlType.search, "", null);
        if (sqlToyConfig.getNoSqlConfigModel() == null) {
            throw new IllegalArgumentException("ES\u67e5\u8be2\u8bf7\u4f7f\u7528<eql></eql>\u914d\u7f6e!");
        }
        SqlToyConfig realSqlConfig = null;
        if (StringUtil.isNotBlank(this.endPoint)) {
            realSqlConfig = sqlToyConfig.clone();
            realSqlConfig.getNoSqlConfigModel().setEndpoint(this.endPoint);
        } else {
            realSqlConfig = sqlToyConfig;
        }
        try {
            if (realSqlConfig.getNoSqlConfigModel().isSqlMode()) {
                return ElasticSqlPlugin.findTop(this.sqlToyContext, realSqlConfig, queryExecutor, topSize);
            }
            return ElasticSearchPlugin.findTop(this.sqlToyContext, realSqlConfig, queryExecutor, topSize);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DataAccessException(e);
        }
    }

    public Page findPage(Page pageModel) {
        QueryExecutor queryExecutor = this.build();
        SqlToyConfig sqlToyConfig = this.sqlToyContext.getSqlToyConfig(this.sql, SqlType.search, "", null);
        if (sqlToyConfig.getNoSqlConfigModel() == null) {
            throw new IllegalArgumentException("ES\u67e5\u8be2\u8bf7\u4f7f\u7528<eql></eql>\u914d\u7f6e!");
        }
        SqlToyConfig realSqlConfig = null;
        if (StringUtil.isNotBlank(this.endPoint)) {
            realSqlConfig = sqlToyConfig.clone();
            realSqlConfig.getNoSqlConfigModel().setEndpoint(this.endPoint);
        } else {
            realSqlConfig = sqlToyConfig;
        }
        NoSqlConfigModel noSqlConfig = realSqlConfig.getNoSqlConfigModel();
        Page pageResult = null;
        try {
            boolean isOverPageToFirst = false;
            if (this.sqlToyContext.getOverPageToFirst() != null) {
                isOverPageToFirst = this.sqlToyContext.getOverPageToFirst();
            }
            if (pageModel.getOverPageToFirst() != null) {
                isOverPageToFirst = pageModel.getOverPageToFirst();
            }
            if (noSqlConfig.isSqlMode()) {
                ElasticEndpoint esConfig = this.sqlToyContext.getElasticEndpoint(noSqlConfig.getEndpoint());
                if (esConfig.isNativeSql()) {
                    throw new UnsupportedOperationException("elastic native sql pagination is not support!");
                }
                pageResult = ElasticSqlPlugin.findPage(this.sqlToyContext, realSqlConfig, pageModel, queryExecutor);
            } else {
                pageResult = ElasticSearchPlugin.findPage(this.sqlToyContext, realSqlConfig, pageModel, queryExecutor);
            }
            if (pageResult.getRecordCount() == 0L && isOverPageToFirst) {
                pageResult.setPageNo(1L);
            }
            return pageResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DataAccessException(e);
        }
    }

    private QueryExecutor build() {
        QueryExecutor queryExecutor = null;
        queryExecutor = this.entity != null ? new QueryExecutor(this.sql, this.entity) : new QueryExecutor(this.sql).names(this.names).values(this.values);
        if (this.resultType != null) {
            queryExecutor.resultType(this.resultType);
        }
        queryExecutor.humpMapLabel(this.humpMapLabel);
        return queryExecutor;
    }
}

