/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.link;

import com.mongodb.client.AggregateIterable;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.sql.DataSource;
import org.bson.Document;
import org.sagacity.sqltoy.SqlToyConstants;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.config.model.NoSqlConfigModel;
import org.sagacity.sqltoy.config.model.NoSqlFieldsModel;
import org.sagacity.sqltoy.config.model.SqlToyConfig;
import org.sagacity.sqltoy.config.model.SqlType;
import org.sagacity.sqltoy.exception.DataAccessException;
import org.sagacity.sqltoy.integration.MongoQuery;
import org.sagacity.sqltoy.link.BaseLink;
import org.sagacity.sqltoy.model.Page;
import org.sagacity.sqltoy.model.QueryExecutor;
import org.sagacity.sqltoy.model.inner.DataSetResult;
import org.sagacity.sqltoy.model.inner.QueryExecutorExtend;
import org.sagacity.sqltoy.utils.MongoElasticUtils;
import org.sagacity.sqltoy.utils.QueryExecutorBuilder;
import org.sagacity.sqltoy.utils.ResultUtils;
import org.sagacity.sqltoy.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mongo
extends BaseLink {
    private static final long serialVersionUID = -4443964509492022973L;
    private final Logger logger = LoggerFactory.getLogger(Mongo.class);
    private final String ERROR_MESSAGE = "mongo\u67e5\u8be2\u8bf7\u4f7f\u7528<mql id=\"\" collection=\"\" fields=\"\"></mql>\u914d\u7f6e,\u8bf7\u786e\u5b9a\u76f8\u5173\u914d\u7f6e\u6b63\u786e\u6027!";
    private MongoQuery mongoQuery;
    private String sql;
    private String[] names;
    private Object[] values;
    private Serializable entity;
    private Type resultType;
    private Boolean humpMapLabel;

    public Mongo(SqlToyContext sqlToyContext, DataSource dataSource) {
        super(sqlToyContext, dataSource);
    }

    public Mongo sql(String sql) {
        this.sql = sql;
        return this;
    }

    public Mongo names(String ... names) {
        this.names = names;
        return this;
    }

    public Mongo values(Object ... values) {
        this.values = values;
        return this;
    }

    public Mongo entity(Serializable entityVO) {
        this.entity = entityVO;
        return this;
    }

    public Mongo resultType(Type resultType) {
        this.resultType = resultType;
        return this;
    }

    public Mongo humpMapLabel(Boolean humpMapLabel) {
        this.humpMapLabel = humpMapLabel;
        return this;
    }

    public Object getOne() {
        List<?> result = this.find();
        if (result == null || result.isEmpty()) {
            return null;
        }
        if (result.size() == 1) {
            return result.get(0);
        }
        throw new IllegalArgumentException("getOne\u67e5\u8be2\u51fa:" + result.size() + " \u6761\u8bb0\u5f55,\u4e0d\u7b26\u5408getOne \u5355\u6761\u9884\u671f!");
    }

    public List<?> find() {
        QueryExecutor queryExecutor = this.build();
        SqlToyConfig sqlToyConfig = this.sqlToyContext.getSqlToyConfig(this.sql, SqlType.search, "", null);
        NoSqlConfigModel noSqlModel = sqlToyConfig.getNoSqlConfigModel();
        if (noSqlModel == null || noSqlModel.getCollection() == null || noSqlModel.getFields() == null) {
            throw new IllegalArgumentException("mongo\u67e5\u8be2\u8bf7\u4f7f\u7528<mql id=\"\" collection=\"\" fields=\"\"></mql>\u914d\u7f6e,\u8bf7\u786e\u5b9a\u76f8\u5173\u914d\u7f6e\u6b63\u786e\u6027!");
        }
        try {
            QueryExecutorExtend extend = queryExecutor.getInnerModel();
            QueryExecutorBuilder.initQueryExecutor(this.sqlToyContext, extend, sqlToyConfig, false);
            String realMql = MongoElasticUtils.wrapMql(sqlToyConfig, extend.getParamsName(), extend.getParamsValue(this.sqlToyContext, sqlToyConfig));
            if (noSqlModel.isHasAggs()) {
                return this.aggregate(sqlToyConfig, realMql, (Class)extend.resultType, extend.humpMapLabel);
            }
            return this.findTop(sqlToyConfig, null, realMql, (Class)extend.resultType, extend.humpMapLabel);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DataAccessException(e);
        }
    }

    public List<?> findTop(Float topSize) {
        QueryExecutor queryExecutor = this.build();
        SqlToyConfig sqlToyConfig = this.sqlToyContext.getSqlToyConfig(this.sql, SqlType.search, "", null);
        NoSqlConfigModel noSqlModel = sqlToyConfig.getNoSqlConfigModel();
        if (noSqlModel == null || noSqlModel.getCollection() == null || noSqlModel.getFields() == null) {
            throw new IllegalArgumentException("mongo\u67e5\u8be2\u8bf7\u4f7f\u7528<mql id=\"\" collection=\"\" fields=\"\"></mql>\u914d\u7f6e,\u8bf7\u786e\u5b9a\u76f8\u5173\u914d\u7f6e\u6b63\u786e\u6027!");
        }
        try {
            QueryExecutorExtend extend = queryExecutor.getInnerModel();
            QueryExecutorBuilder.initQueryExecutor(this.sqlToyContext, extend, sqlToyConfig, false);
            String realMql = MongoElasticUtils.wrapMql(sqlToyConfig, extend.getParamsName(), extend.getParamsValue(this.sqlToyContext, sqlToyConfig));
            return this.findTop(sqlToyConfig, topSize, realMql, (Class)extend.resultType, extend.humpMapLabel);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DataAccessException(e);
        }
    }

    public Page findPage(Page page) {
        QueryExecutor queryExecutor = this.build();
        SqlToyConfig sqlToyConfig = this.sqlToyContext.getSqlToyConfig(this.sql, SqlType.search, "", null);
        NoSqlConfigModel noSqlModel = sqlToyConfig.getNoSqlConfigModel();
        if (noSqlModel == null || noSqlModel.getCollection() == null || noSqlModel.getFields() == null) {
            throw new IllegalArgumentException("mongo\u67e5\u8be2\u8bf7\u4f7f\u7528<mql id=\"\" collection=\"\" fields=\"\"></mql>\u914d\u7f6e,\u8bf7\u786e\u5b9a\u76f8\u5173\u914d\u7f6e\u6b63\u786e\u6027!");
        }
        try {
            QueryExecutorExtend extend = queryExecutor.getInnerModel();
            QueryExecutorBuilder.initQueryExecutor(this.sqlToyContext, extend, sqlToyConfig, false);
            String realMql = MongoElasticUtils.wrapMql(sqlToyConfig, extend.getParamsName(), extend.getParamsValue(this.sqlToyContext, sqlToyConfig));
            return this.findPage(sqlToyConfig, page, realMql, (Class)extend.resultType, extend.humpMapLabel);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DataAccessException(e);
        }
    }

    private QueryExecutor build() {
        QueryExecutor queryExecutor = null;
        queryExecutor = this.entity != null ? new QueryExecutor(this.sql, this.entity) : new QueryExecutor(this.sql).names(this.names).values(this.values);
        if (this.resultType != null) {
            queryExecutor.resultType(this.resultType);
        }
        queryExecutor.humpMapLabel(this.humpMapLabel);
        return queryExecutor;
    }

    private Page findPage(SqlToyConfig sqlToyConfig, Page pageModel, String mql, Class resultClass, Boolean humpMapLabel) throws Exception {
        Integer limit;
        Long skip;
        Page result = new Page();
        result.setPageNo(pageModel.getPageNo());
        result.setPageSize(pageModel.getPageSize());
        result.setRecordCount(this.getMongoQuery().count(mql, sqlToyConfig.getNoSqlConfigModel().getCollection()));
        boolean isOverPageToFirst = false;
        if (this.sqlToyContext.getOverPageToFirst() != null) {
            isOverPageToFirst = this.sqlToyContext.getOverPageToFirst();
        }
        if (pageModel.getOverPageToFirst() != null) {
            isOverPageToFirst = pageModel.getOverPageToFirst();
        }
        if (result.getRecordCount() == 0L) {
            if (isOverPageToFirst) {
                result.setPageNo(1L);
            }
            return result;
        }
        if (result.getPageNo() == -1L) {
            skip = 0L;
            limit = Long.valueOf(result.getRecordCount()).intValue();
        } else {
            boolean isOverPage;
            boolean bl = isOverPage = pageModel.getPageNo() * (long)pageModel.getPageSize() >= result.getRecordCount() + (long)pageModel.getPageSize();
            if (isOverPage && !isOverPageToFirst) {
                return result;
            }
            long realStartPage = isOverPage ? 1L : pageModel.getPageNo();
            result.setPageNo(realStartPage);
            skip = (realStartPage - 1L) * (long)pageModel.getPageSize();
            limit = pageModel.getPageSize();
        }
        List<Document> rs = this.getMongoQuery().find(mql, Document.class, sqlToyConfig.getNoSqlConfigModel().getCollection(), skip, limit);
        if (rs == null || rs.isEmpty()) {
            return result;
        }
        result.setRows(this.extractFieldValues(sqlToyConfig, rs.iterator(), resultClass, humpMapLabel));
        return result;
    }

    private List<?> findTop(SqlToyConfig sqlToyConfig, Float topSize, String mql, Class resultClass, Boolean humpMapLabel) throws Exception {
        List<Document> rs;
        Integer limit = null;
        if (topSize != null) {
            if (topSize.floatValue() > 1.0f) {
                limit = topSize.intValue();
            } else {
                long count = this.getMongoQuery().count(mql, sqlToyConfig.getNoSqlConfigModel().getCollection());
                limit = Double.valueOf((float)count * topSize.floatValue()).intValue();
            }
        }
        if ((rs = this.getMongoQuery().find(mql, Document.class, sqlToyConfig.getNoSqlConfigModel().getCollection(), null, limit)) == null || rs.isEmpty()) {
            return new ArrayList();
        }
        return this.extractFieldValues(sqlToyConfig, rs.iterator(), resultClass, humpMapLabel);
    }

    private List<?> aggregate(SqlToyConfig sqlToyConfig, String mql, Class resultClass, Boolean humpMapLabel) throws Exception {
        String realMql = mql.trim();
        if (realMql.startsWith("{") && realMql.endsWith("}")) {
            realMql = realMql.substring(1, realMql.length() - 1).trim();
        }
        if (realMql.startsWith("[") && realMql.endsWith("]")) {
            realMql = realMql.substring(1, realMql.length() - 1);
        }
        if (this.sqlToyContext.isDebug()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("aggregateByMongo script=" + realMql);
            } else {
                System.out.println("aggregateByMongo script=" + realMql);
            }
        }
        String[] aggregates = StringUtil.splitExcludeSymMark(realMql, ",", SqlToyConstants.filters);
        ArrayList<Document> dbObjects = new ArrayList<Document>();
        for (String json : aggregates) {
            if (!StringUtil.isNotBlank(json)) continue;
            dbObjects.add(Document.parse((String)json));
        }
        AggregateIterable out = this.getMongoQuery().getCollection(sqlToyConfig.getNoSqlConfigModel().getCollection()).aggregate(dbObjects);
        if (out == null) {
            return new ArrayList();
        }
        return this.extractFieldValues(sqlToyConfig, (Iterator<Document>)out.iterator(), resultClass, humpMapLabel);
    }

    private List extractFieldValues(SqlToyConfig sqlToyConfig, Iterator<Document> iter, Class resultClass, Boolean humpMapLabel) throws Exception {
        ArrayList resultSet = new ArrayList();
        HashMap<String, String[]> linkMap = new HashMap<String, String[]>();
        NoSqlFieldsModel fieldModel = MongoElasticUtils.processFields(sqlToyConfig.getNoSqlConfigModel().getFields(), linkMap);
        String[] realFields = fieldModel.getFields();
        String[] translateFields = fieldModel.getAliasLabels();
        while (iter.hasNext()) {
            Document row = iter.next();
            ArrayList<Object> rowData = new ArrayList<Object>();
            for (String name : realFields) {
                String[] keys = linkMap.get(name);
                if (null == keys) {
                    rowData.add(row.get((Object)name));
                    continue;
                }
                Document val = row;
                int size = keys.length;
                for (int i = 0; i < size; ++i) {
                    String key = keys[i];
                    if (i == size - 1) {
                        rowData.add(val.get((Object)key));
                        continue;
                    }
                    val = (Document)val.get((Object)key);
                }
            }
            resultSet.add(rowData);
        }
        MongoElasticUtils.processTranslate(this.sqlToyContext, sqlToyConfig, resultSet, translateFields);
        DataSetResult dataSetResult = new DataSetResult();
        dataSetResult.setRows(resultSet);
        dataSetResult.setLabelNames(translateFields);
        boolean changedCols = ResultUtils.calculate(this.sqlToyContext.getDesensitizeProvider(), sqlToyConfig, dataSetResult, null, null);
        return ResultUtils.wrapQueryResult(this.sqlToyContext, resultSet, StringUtil.humpFieldNames(translateFields), resultClass, changedCols, humpMapLabel, false, null, null);
    }

    private MongoQuery getMongoQuery() throws Exception {
        if (this.mongoQuery == null) {
            this.mongoQuery = (MongoQuery)Class.forName(this.sqlToyContext.getMongoQueryClass()).newInstance();
            this.mongoQuery.initialize(this.sqlToyContext);
        }
        return this.mongoQuery;
    }
}

