/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.dialect.utils;

import java.sql.Connection;
import org.sagacity.sqltoy.SqlToyConstants;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.callback.DecryptHandler;
import org.sagacity.sqltoy.config.model.FieldMeta;
import org.sagacity.sqltoy.config.model.OperateType;
import org.sagacity.sqltoy.config.model.PKStrategy;
import org.sagacity.sqltoy.config.model.SqlToyConfig;
import org.sagacity.sqltoy.config.model.SqlToyResult;
import org.sagacity.sqltoy.dialect.utils.DialectUtils;
import org.sagacity.sqltoy.model.QueryExecutor;
import org.sagacity.sqltoy.model.QueryResult;
import org.sagacity.sqltoy.model.inner.QueryExecutorExtend;
import org.sagacity.sqltoy.utils.SqlUtilsExt;
import org.sagacity.sqltoy.utils.StringUtil;

public class DB2DialectUtils {
    public static QueryResult getRandomResult(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, QueryExecutor queryExecutor, DecryptHandler decryptHandler, Long totalCount, Long randomCount, Connection conn, Integer dbType, String dialect, int fetchSize, int maxRows) throws Exception {
        StringBuilder sql = new StringBuilder();
        String innerSql = sqlToyConfig.isHasFast() ? sqlToyConfig.getFastSql(dialect) : sqlToyConfig.getSql(dialect);
        boolean hasOrderOrUnion = DialectUtils.hasOrderByOrUnion(innerSql);
        innerSql = SqlUtilsExt.markOriginalSql(innerSql);
        if (sqlToyConfig.isHasFast()) {
            sql.append(sqlToyConfig.getFastPreSql(dialect));
            if (!sqlToyConfig.isIgnoreBracket()) {
                sql.append(" (");
            }
        }
        if (hasOrderOrUnion) {
            sql.append("select " + SqlToyConstants.INTERMEDIATE_TABLE + ".* from (");
        }
        sql.append(innerSql);
        if (hasOrderOrUnion) {
            sql.append(") ");
            sql.append(SqlToyConstants.INTERMEDIATE_TABLE);
            sql.append(" ");
        }
        sql.append(" order by rand() fetch first ");
        sql.append(randomCount);
        sql.append(" rows only ");
        if (sqlToyConfig.isHasFast()) {
            if (!sqlToyConfig.isIgnoreBracket()) {
                sql.append(") ");
            }
            sql.append(sqlToyConfig.getFastTailSql(dialect));
        }
        SqlToyResult queryParam = DialectUtils.wrapPageSqlParams(sqlToyContext, sqlToyConfig, queryExecutor, sql.toString(), null, null, dialect);
        QueryExecutorExtend extend = queryExecutor.getInnerModel();
        queryParam = DialectUtils.doInterceptors(sqlToyContext, sqlToyConfig, extend.entityClass == null ? OperateType.random : OperateType.singleTable, queryParam, extend.entityClass, dbType);
        return DialectUtils.findBySql(sqlToyContext, sqlToyConfig, queryParam.getSql(), queryParam.getParamsValue(), extend, decryptHandler, conn, dbType, 0, fetchSize, maxRows);
    }

    public static void wrapSelectFields(StringBuilder sql, String columnName, FieldMeta fieldMeta) {
        int jdbcType = fieldMeta.getType();
        int length = fieldMeta.getLength();
        if (jdbcType == 12) {
            sql.append("?");
        } else if (jdbcType == 1) {
            sql.append("?");
        } else if (jdbcType == 91) {
            sql.append("cast(? as DATE)");
        } else if (jdbcType == 2) {
            sql.append("cast(? as DECIMAL)");
        } else if (jdbcType == 3) {
            sql.append("cast(? as DECIMAL)");
        } else if (jdbcType == -5) {
            sql.append("cast(? as BIGINT)");
        } else if (jdbcType == 4 || jdbcType == -6) {
            sql.append("cast(? as INTEGER)");
        } else if (jdbcType == 93) {
            sql.append("cast(? as TIMESTAMP)");
        } else if (jdbcType == 8) {
            sql.append("cast(? as DOUBLE)");
        } else if (jdbcType == 6) {
            sql.append("cast(? as DOUBLE)");
        } else if (jdbcType == 92) {
            sql.append("cast(? as TIME)");
        } else if (jdbcType == 2005) {
            sql.append("?");
        } else if (jdbcType == 16) {
            sql.append("cast(? as BOOLEAN)");
        } else if (jdbcType == -2) {
            sql.append("cast(? as BINARY LARGE OBJECT(" + length + "))");
        } else if (jdbcType == 2004) {
            sql.append("?");
        } else if (StringUtil.isNotBlank(fieldMeta.getNativeType())) {
            sql.append("cast(? as " + fieldMeta.getNativeType() + ")");
        } else {
            sql.append("?");
        }
        sql.append(" as ");
        sql.append(columnName);
    }

    public static boolean isAssignPKValue(PKStrategy pkStrategy) {
        if (pkStrategy == null) {
            return true;
        }
        if (pkStrategy.equals((Object)PKStrategy.SEQUENCE)) {
            return true;
        }
        return !pkStrategy.equals((Object)PKStrategy.IDENTITY);
    }
}

