/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.dialect.impl;

import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.sagacity.sqltoy.SqlExecuteStat;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.callback.DecryptHandler;
import org.sagacity.sqltoy.callback.GenerateSavePKStrategy;
import org.sagacity.sqltoy.callback.GenerateSqlHandler;
import org.sagacity.sqltoy.callback.ReflectPropsHandler;
import org.sagacity.sqltoy.callback.UpdateRowHandler;
import org.sagacity.sqltoy.config.model.EntityMeta;
import org.sagacity.sqltoy.config.model.PKStrategy;
import org.sagacity.sqltoy.config.model.SqlToyConfig;
import org.sagacity.sqltoy.config.model.SqlType;
import org.sagacity.sqltoy.dialect.Dialect;
import org.sagacity.sqltoy.dialect.model.SavePKStrategy;
import org.sagacity.sqltoy.dialect.utils.DefaultDialectUtils;
import org.sagacity.sqltoy.dialect.utils.DialectExtUtils;
import org.sagacity.sqltoy.dialect.utils.DialectUtils;
import org.sagacity.sqltoy.model.ColumnMeta;
import org.sagacity.sqltoy.model.LockMode;
import org.sagacity.sqltoy.model.QueryExecutor;
import org.sagacity.sqltoy.model.QueryResult;
import org.sagacity.sqltoy.model.StoreResult;
import org.sagacity.sqltoy.model.TableMeta;
import org.sagacity.sqltoy.model.inner.QueryExecutorExtend;
import org.sagacity.sqltoy.utils.SqlUtil;

public class DefaultDialect
implements Dialect {
    public static final String NVL_FUNCTION = "ifnull";

    @Override
    public boolean isUnique(SqlToyContext sqlToyContext, Serializable entity, String[] paramsNamed, Connection conn, Integer dbType, String tableName) {
        return DialectUtils.isUnique(sqlToyContext, entity, paramsNamed, conn, dbType, tableName, (entityMeta, realParamNamed, table, topSize) -> {
            String queryStr = DialectExtUtils.wrapUniqueSql(entityMeta, realParamNamed, dbType, table);
            return queryStr + " limit " + topSize;
        });
    }

    @Override
    public QueryResult getRandomResult(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, QueryExecutor queryExecutor, DecryptHandler decryptHandler, Long totalCount, Long randomCount, Connection conn, Integer dbType, String dialect, int fetchSize, int maxRows) throws Exception {
        return DefaultDialectUtils.getRandomResult(sqlToyContext, sqlToyConfig, queryExecutor, decryptHandler, totalCount, randomCount, conn, dbType, dialect, fetchSize, maxRows);
    }

    @Override
    public QueryResult findPageBySql(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, QueryExecutor queryExecutor, DecryptHandler decryptHandler, Long pageNo, Integer pageSize, Connection conn, Integer dbType, String dialect, int fetchSize, int maxRows) throws Exception {
        return DefaultDialectUtils.findPageBySql(sqlToyContext, sqlToyConfig, queryExecutor, decryptHandler, pageNo, pageSize, conn, dbType, dialect, fetchSize, maxRows);
    }

    @Override
    public QueryResult findTopBySql(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, QueryExecutor queryExecutor, DecryptHandler decryptHandler, Integer topSize, Connection conn, Integer dbType, String dialect, int fetchSize, int maxRows) throws Exception {
        return DefaultDialectUtils.findTopBySql(sqlToyContext, sqlToyConfig, queryExecutor, decryptHandler, topSize, conn, dbType, dialect, fetchSize, maxRows);
    }

    @Override
    public QueryResult findBySql(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, String sql, Object[] paramsValue, QueryExecutorExtend queryExecutorExtend, DecryptHandler decryptHandler, Connection conn, LockMode lockMode, Integer dbType, String dialect, int fetchSize, int maxRows) throws Exception {
        String realSql = sql.concat(this.getLockSql(sql, dbType, lockMode));
        return DialectUtils.findBySql(sqlToyContext, sqlToyConfig, realSql, paramsValue, queryExecutorExtend, decryptHandler, conn, dbType, 0, fetchSize, maxRows);
    }

    @Override
    public Long getCountBySql(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, String sql, Object[] paramsValue, boolean isLastSql, Connection conn, Integer dbType, String dialect) throws Exception {
        return DialectUtils.getCountBySql(sqlToyContext, sqlToyConfig, sql, paramsValue, isLastSql, conn, dbType);
    }

    @Override
    public Serializable load(SqlToyContext sqlToyContext, Serializable entity, List<Class> cascadeTypes, LockMode lockMode, Connection conn, Integer dbType, String dialect, String tableName) throws Exception {
        EntityMeta entityMeta = sqlToyContext.getEntityMeta(entity.getClass());
        SqlToyConfig sqlToyConfig = sqlToyContext.getSqlToyConfig(entityMeta.getLoadSql(tableName), SqlType.search, dialect, null);
        String loadSql = sqlToyConfig.getSql(dialect);
        loadSql = loadSql.concat(this.getLockSql(loadSql, dbType, lockMode));
        return DialectUtils.load(sqlToyContext, sqlToyConfig, loadSql, entityMeta, entity, cascadeTypes, conn, dbType);
    }

    @Override
    public List<?> loadAll(SqlToyContext sqlToyContext, List<?> entities, List<Class> cascadeTypes, LockMode lockMode, Connection conn, Integer dbType, String dialect, String tableName, int fetchSize, int maxRows) throws Exception {
        return DialectUtils.loadAll(sqlToyContext, entities, cascadeTypes, lockMode, conn, dbType, tableName, (sql, dbTypeValue, lockedMode) -> this.getLockSql(sql, dbTypeValue, lockedMode), fetchSize, maxRows);
    }

    @Override
    public Object save(final SqlToyContext sqlToyContext, Serializable entity, Connection conn, final Integer dbType, String dialect, String tableName) throws Exception {
        EntityMeta entityMeta = sqlToyContext.getEntityMeta(entity.getClass());
        boolean isAssignPK = DefaultDialect.isAssignPKValue(entityMeta.getIdStrategy());
        String insertSql = DialectExtUtils.generateInsertSql(sqlToyContext.getUnifyFieldsHandler(), dbType, entityMeta, entityMeta.getIdStrategy(), NVL_FUNCTION, "NEXTVAL FOR " + entityMeta.getSequence(), isAssignPK, tableName);
        return DialectUtils.save(sqlToyContext, entityMeta, entityMeta.getIdStrategy(), isAssignPK, insertSql, entity, new GenerateSqlHandler(){

            @Override
            public String generateSql(EntityMeta entityMeta, String[] forceUpdateField) {
                return DialectExtUtils.generateInsertSql(sqlToyContext.getUnifyFieldsHandler(), dbType, entityMeta, entityMeta.getIdStrategy(), DefaultDialect.NVL_FUNCTION, "NEXTVAL FOR " + entityMeta.getSequence(), DefaultDialect.isAssignPKValue(entityMeta.getIdStrategy()), null);
            }
        }, new GenerateSavePKStrategy(){

            @Override
            public SavePKStrategy generate(EntityMeta entityMeta) {
                return new SavePKStrategy(entityMeta.getIdStrategy(), DefaultDialect.isAssignPKValue(entityMeta.getIdStrategy()));
            }
        }, conn, dbType);
    }

    @Override
    public Long saveAll(SqlToyContext sqlToyContext, List<?> entities, int batchSize, ReflectPropsHandler reflectPropsHandler, Connection conn, Integer dbType, String dialect, Boolean autoCommit, String tableName) throws Exception {
        EntityMeta entityMeta = sqlToyContext.getEntityMeta(entities.get(0).getClass());
        boolean isAssignPK = DefaultDialect.isAssignPKValue(entityMeta.getIdStrategy());
        String insertSql = DialectExtUtils.generateInsertSql(sqlToyContext.getUnifyFieldsHandler(), dbType, entityMeta, entityMeta.getIdStrategy(), NVL_FUNCTION, "NEXTVAL FOR " + entityMeta.getSequence(), isAssignPK, tableName);
        return DialectUtils.saveAll(sqlToyContext, entityMeta, entityMeta.getIdStrategy(), isAssignPK, insertSql, entities, batchSize, reflectPropsHandler, conn, dbType, autoCommit);
    }

    @Override
    public Long update(SqlToyContext sqlToyContext, Serializable entity, String[] forceUpdateFields, boolean cascade, Class[] emptyCascadeClasses, HashMap<Class, String[]> subTableForceUpdateProps, Connection conn, Integer dbType, String dialect, String tableName) throws Exception {
        return DialectUtils.update(sqlToyContext, entity, NVL_FUNCTION, forceUpdateFields, false, null, emptyCascadeClasses, subTableForceUpdateProps, conn, dbType, tableName);
    }

    @Override
    public Long updateAll(SqlToyContext sqlToyContext, List<?> entities, int batchSize, String[] uniqueFields, String[] forceUpdateFields, ReflectPropsHandler reflectPropsHandler, Connection conn, Integer dbType, String dialect, Boolean autoCommit, String tableName) throws Exception {
        return DialectUtils.updateAll(sqlToyContext, entities, batchSize, forceUpdateFields, reflectPropsHandler, NVL_FUNCTION, conn, dbType, autoCommit, tableName, false);
    }

    @Override
    public Serializable updateSaveFetch(SqlToyContext sqlToyContext, Serializable entity, UpdateRowHandler updateRowHandler, String[] uniqueProps, Connection conn, Integer dbType, String dialect, String tableName) throws Exception {
        return DefaultDialectUtils.updateSaveFetch(sqlToyContext, entity, updateRowHandler, uniqueProps, conn, dbType, dialect, tableName);
    }

    @Override
    public Long saveOrUpdate(SqlToyContext sqlToyContext, Serializable entity, String[] forceUpdateFields, Connection conn, Integer dbType, String dialect, Boolean autoCommit, String tableName) throws Exception {
        ArrayList<Serializable> entities = new ArrayList<Serializable>();
        entities.add(entity);
        return this.saveOrUpdateAll(sqlToyContext, entities, sqlToyContext.getBatchSize(), null, forceUpdateFields, conn, dbType, dialect, autoCommit, tableName);
    }

    @Override
    public Long saveOrUpdateAll(SqlToyContext sqlToyContext, List<?> entities, int batchSize, ReflectPropsHandler reflectPropsHandler, String[] forceUpdateFields, Connection conn, Integer dbType, String dialect, Boolean autoCommit, String tableName) throws Exception {
        Long updateCnt = DialectUtils.updateAll(sqlToyContext, entities, batchSize, forceUpdateFields, reflectPropsHandler, NVL_FUNCTION, conn, dbType, autoCommit, tableName, true);
        if (updateCnt >= (long)entities.size()) {
            SqlExecuteStat.debug("\u4fee\u6539\u8bb0\u5f55", "\u4fee\u6539\u8bb0\u5f55\u91cf:" + updateCnt + " \u6761,\u7b49\u4e8eentities\u96c6\u5408\u957f\u5ea6,\u4e0d\u518d\u505ainsert\u64cd\u4f5c!", new Object[0]);
            return updateCnt;
        }
        Long saveCnt = this.saveAllIgnoreExist(sqlToyContext, entities, batchSize, reflectPropsHandler, conn, dbType, dialect, autoCommit, tableName);
        SqlExecuteStat.debug("\u65b0\u589e\u8bb0\u5f55", "\u65b0\u5efa\u8bb0\u5f55\u6570\u91cf:" + saveCnt + " \u6761!", new Object[0]);
        return updateCnt + saveCnt;
    }

    @Override
    public Long saveAllIgnoreExist(SqlToyContext sqlToyContext, List<?> entities, int batchSize, ReflectPropsHandler reflectPropsHandler, Connection conn, Integer dbType, String dialect, Boolean autoCommit, String tableName) throws Exception {
        EntityMeta entityMeta = sqlToyContext.getEntityMeta(entities.get(0).getClass());
        boolean isAssignPK = DefaultDialect.isAssignPKValue(entityMeta.getIdStrategy());
        String insertSql = DialectExtUtils.generateInsertSql(sqlToyContext.getUnifyFieldsHandler(), dbType, entityMeta, entityMeta.getIdStrategy(), NVL_FUNCTION, "NEXTVAL FOR " + entityMeta.getSequence(), isAssignPK, tableName).replaceFirst("(?i)insert ", "insert ignore ");
        return DialectUtils.saveAll(sqlToyContext, entityMeta, entityMeta.getIdStrategy(), isAssignPK, insertSql, entities, batchSize, reflectPropsHandler, conn, dbType, autoCommit);
    }

    @Override
    public Long delete(SqlToyContext sqlToyContext, Serializable entity, Connection conn, Integer dbType, String dialect, String tableName) throws Exception {
        return DialectUtils.delete(sqlToyContext, entity, conn, dbType, tableName);
    }

    @Override
    public Long deleteAll(SqlToyContext sqlToyContext, List<?> entities, int batchSize, Connection conn, Integer dbType, String dialect, Boolean autoCommit, String tableName) throws Exception {
        return DialectUtils.deleteAll(sqlToyContext, entities, batchSize, conn, dbType, autoCommit, tableName);
    }

    @Override
    public QueryResult updateFetch(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, String sql, Object[] paramValues, UpdateRowHandler updateRowHandler, Connection conn, Integer dbType, String dialect, LockMode lockMode, int fetchSize, int maxRows) throws Exception {
        String realSql = sql.concat(this.getLockSql(sql, dbType, lockMode == null ? LockMode.UPGRADE : lockMode));
        return DialectUtils.updateFetchBySql(sqlToyContext, sqlToyConfig, realSql, paramValues, updateRowHandler, conn, dbType, 0, fetchSize, maxRows);
    }

    @Override
    public StoreResult executeStore(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, String sql, Object[] inParamsValue, Integer[] outParamsType, boolean moreResult, Connection conn, Integer dbType, String dialect, int fetchSize) throws Exception {
        return DialectUtils.executeStore(sqlToyConfig, sqlToyContext, sql, inParamsValue, outParamsType, moreResult, conn, dbType, fetchSize);
    }

    private String getLockSql(String sql, Integer dbType, LockMode lockMode) {
        if (lockMode == null || SqlUtil.hasLock(sql, dbType)) {
            return "";
        }
        if (lockMode == LockMode.UPGRADE_NOWAIT) {
            return " for update nowait ";
        }
        if (lockMode == LockMode.UPGRADE_SKIPLOCK) {
            return " for update skip locked";
        }
        return " for update ";
    }

    private static boolean isAssignPKValue(PKStrategy pkStrategy) {
        if (pkStrategy == null) {
            return true;
        }
        if (pkStrategy.equals((Object)PKStrategy.SEQUENCE)) {
            return true;
        }
        return !pkStrategy.equals((Object)PKStrategy.IDENTITY);
    }

    @Override
    public List<ColumnMeta> getTableColumns(String catalog, String schema, String tableName, Connection conn, Integer dbType, String dialect) throws Exception {
        return DefaultDialectUtils.getTableColumns(catalog, schema, tableName, conn, dbType, dialect);
    }

    @Override
    public List<TableMeta> getTables(String catalog, String schema, String tableName, Connection conn, Integer dbType, String dialect) throws Exception {
        return DefaultDialectUtils.getTables(catalog, schema, tableName, conn, dbType, dialect);
    }
}

