/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.dialect.impl;

import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.sagacity.sqltoy.SqlToyConstants;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.callback.DecryptHandler;
import org.sagacity.sqltoy.callback.GenerateSavePKStrategy;
import org.sagacity.sqltoy.callback.GenerateSqlHandler;
import org.sagacity.sqltoy.callback.ReflectPropsHandler;
import org.sagacity.sqltoy.callback.UpdateRowHandler;
import org.sagacity.sqltoy.config.model.EntityMeta;
import org.sagacity.sqltoy.config.model.PKStrategy;
import org.sagacity.sqltoy.config.model.SqlToyConfig;
import org.sagacity.sqltoy.config.model.SqlType;
import org.sagacity.sqltoy.dialect.Dialect;
import org.sagacity.sqltoy.dialect.model.SavePKStrategy;
import org.sagacity.sqltoy.dialect.utils.DB2DialectUtils;
import org.sagacity.sqltoy.dialect.utils.DefaultDialectUtils;
import org.sagacity.sqltoy.dialect.utils.DialectExtUtils;
import org.sagacity.sqltoy.dialect.utils.DialectUtils;
import org.sagacity.sqltoy.model.ColumnMeta;
import org.sagacity.sqltoy.model.LockMode;
import org.sagacity.sqltoy.model.QueryExecutor;
import org.sagacity.sqltoy.model.QueryResult;
import org.sagacity.sqltoy.model.StoreResult;
import org.sagacity.sqltoy.model.TableMeta;
import org.sagacity.sqltoy.model.inner.QueryExecutorExtend;
import org.sagacity.sqltoy.utils.SqlUtil;
import org.sagacity.sqltoy.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DB2Dialect
implements Dialect {
    protected final Logger logger = LoggerFactory.getLogger(DB2Dialect.class);
    public static final Pattern DB2_QUERY_UR_PATTERN = Pattern.compile("(?i)\\s+with\\s+ur\\s*$");
    public static final String DB2_QUERY_APPEND = " with ur";
    public static final String NVL_FUNCTION = "nvl";
    public static final String VIRTUAL_TABLE = "SYSIBM.SYSDUMMY1";

    private String appendWithUR(String sql) {
        if (SqlToyConstants.db2WithUR()) {
            return StringUtil.matches(sql, DB2_QUERY_UR_PATTERN) ? sql : sql + DB2_QUERY_APPEND;
        }
        return sql;
    }

    @Override
    public boolean isUnique(SqlToyContext sqlToyContext, Serializable entity, String[] paramsNamed, Connection conn, Integer dbType, String tableName) {
        return DialectUtils.isUnique(sqlToyContext, entity, paramsNamed, conn, dbType, tableName, (entityMeta, realParamNamed, table, topSize) -> {
            String queryStr = DialectExtUtils.wrapUniqueSql(entityMeta, realParamNamed, dbType, table);
            return queryStr + " limit " + topSize;
        });
    }

    @Override
    public Serializable load(SqlToyContext sqlToyContext, Serializable entity, List<Class> cascadeTypes, LockMode lockMode, Connection conn, Integer dbType, String dialect, String tableName) throws Exception {
        EntityMeta entityMeta = sqlToyContext.getEntityMeta(entity.getClass());
        SqlToyConfig sqlToyConfig = sqlToyContext.getSqlToyConfig(entityMeta.getLoadSql(tableName), SqlType.search, dialect, null);
        String loadSql = sqlToyConfig.getSql(dialect);
        loadSql = loadSql.concat(this.getLockSql(loadSql, dbType, lockMode));
        return DialectUtils.load(sqlToyContext, sqlToyConfig, loadSql, entityMeta, entity, cascadeTypes, conn, dbType);
    }

    @Override
    public List<?> loadAll(SqlToyContext sqlToyContext, List<?> entities, List<Class> cascadeTypes, LockMode lockMode, Connection conn, Integer dbType, String dialect, String tableName, int fetchSize, int maxRows) throws Exception {
        return DialectUtils.loadAll(sqlToyContext, entities, cascadeTypes, lockMode, conn, dbType, tableName, (sql, dbTypeValue, lockedMode) -> this.getLockSql(sql, dbTypeValue, lockedMode), fetchSize, maxRows);
    }

    @Override
    public Object save(final SqlToyContext sqlToyContext, Serializable entity, Connection conn, final Integer dbType, String dialect, String tableName) throws Exception {
        EntityMeta entityMeta = sqlToyContext.getEntityMeta(entity.getClass());
        boolean isAssignPK = DB2DialectUtils.isAssignPKValue(entityMeta.getIdStrategy());
        String insertSql = DialectExtUtils.generateInsertSql(sqlToyContext.getUnifyFieldsHandler(), dbType, entityMeta, entityMeta.getIdStrategy(), NVL_FUNCTION, "NEXTVAL FOR " + entityMeta.getSequence(), isAssignPK, tableName);
        return DialectUtils.save(sqlToyContext, entityMeta, entityMeta.getIdStrategy(), DB2DialectUtils.isAssignPKValue(entityMeta.getIdStrategy()), insertSql, entity, new GenerateSqlHandler(){

            @Override
            public String generateSql(EntityMeta entityMeta, String[] forceUpdateField) {
                return DialectExtUtils.generateInsertSql(sqlToyContext.getUnifyFieldsHandler(), dbType, entityMeta, entityMeta.getIdStrategy(), DB2Dialect.NVL_FUNCTION, "NEXTVAL FOR " + entityMeta.getSequence(), DB2DialectUtils.isAssignPKValue(entityMeta.getIdStrategy()), null);
            }
        }, new GenerateSavePKStrategy(){

            @Override
            public SavePKStrategy generate(EntityMeta entityMeta) {
                return new SavePKStrategy(entityMeta.getIdStrategy(), DB2DialectUtils.isAssignPKValue(entityMeta.getIdStrategy()));
            }
        }, conn, dbType);
    }

    @Override
    public Long saveAll(SqlToyContext sqlToyContext, List<?> entities, int batchSize, ReflectPropsHandler reflectPropsHandler, Connection conn, Integer dbType, String dialect, Boolean autoCommit, String tableName) throws Exception {
        EntityMeta entityMeta = sqlToyContext.getEntityMeta(entities.get(0).getClass());
        boolean isAssignPK = DB2DialectUtils.isAssignPKValue(entityMeta.getIdStrategy());
        String insertSql = DialectExtUtils.generateInsertSql(sqlToyContext.getUnifyFieldsHandler(), dbType, entityMeta, entityMeta.getIdStrategy(), NVL_FUNCTION, "NEXTVAL FOR " + entityMeta.getSequence(), isAssignPK, tableName);
        return DialectUtils.saveAll(sqlToyContext, entityMeta, entityMeta.getIdStrategy(), isAssignPK, insertSql, entities, batchSize, reflectPropsHandler, conn, dbType, autoCommit);
    }

    @Override
    public Long update(final SqlToyContext sqlToyContext, Serializable entity, String[] forceUpdateFields, boolean cascade, Class[] emptyCascadeClasses, HashMap<Class, String[]> subTableForceUpdateProps, Connection conn, final Integer dbType, String dialect, String tableName) throws Exception {
        return DialectUtils.update(sqlToyContext, entity, NVL_FUNCTION, forceUpdateFields, cascade, !cascade ? null : new GenerateSqlHandler(){

            @Override
            public String generateSql(EntityMeta entityMeta, String[] forceUpdateFields) {
                return DialectUtils.getSaveOrUpdateSql(sqlToyContext.getUnifyFieldsHandler(), dbType, entityMeta, entityMeta.getIdStrategy(), forceUpdateFields, DB2Dialect.VIRTUAL_TABLE, DB2Dialect.NVL_FUNCTION, "NEXTVAL FOR " + entityMeta.getSequence(), DB2DialectUtils.isAssignPKValue(entityMeta.getIdStrategy()), null);
            }
        }, emptyCascadeClasses, subTableForceUpdateProps, conn, dbType, tableName);
    }

    @Override
    public Long updateAll(SqlToyContext sqlToyContext, List<?> entities, int batchSize, String[] uniqueFields, String[] forceUpdateFields, ReflectPropsHandler reflectPropsHandler, Connection conn, Integer dbType, String dialect, Boolean autoCommit, String tableName) throws Exception {
        return DialectUtils.updateAll(sqlToyContext, entities, batchSize, forceUpdateFields, reflectPropsHandler, NVL_FUNCTION, conn, dbType, autoCommit, tableName, false);
    }

    @Override
    public Serializable updateSaveFetch(SqlToyContext sqlToyContext, Serializable entity, UpdateRowHandler updateRowHandler, String[] uniqueProps, Connection conn, Integer dbType, String dialect, String tableName) throws Exception {
        return DefaultDialectUtils.updateSaveFetch(sqlToyContext, entity, updateRowHandler, uniqueProps, conn, dbType, dialect, tableName);
    }

    @Override
    public QueryResult getRandomResult(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, QueryExecutor queryExecutor, DecryptHandler decryptHandler, Long totalCount, Long randomCount, Connection conn, Integer dbType, String dialect, int fetchSize, int maxRows) throws Exception {
        return DB2DialectUtils.getRandomResult(sqlToyContext, sqlToyConfig, queryExecutor, decryptHandler, totalCount, randomCount, conn, dbType, dialect, fetchSize, maxRows);
    }

    @Override
    public QueryResult findPageBySql(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, QueryExecutor queryExecutor, DecryptHandler decryptHandler, Long pageNo, Integer pageSize, Connection conn, Integer dbType, String dialect, int fetchSize, int maxRows) throws Exception {
        return DefaultDialectUtils.findPageBySql(sqlToyContext, sqlToyConfig, queryExecutor, decryptHandler, pageNo, pageSize, conn, dbType, dialect, fetchSize, maxRows);
    }

    @Override
    public QueryResult findTopBySql(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, QueryExecutor queryExecutor, DecryptHandler decryptHandler, Integer topSize, Connection conn, Integer dbType, String dialect, int fetchSize, int maxRows) throws Exception {
        return DefaultDialectUtils.findTopBySql(sqlToyContext, sqlToyConfig, queryExecutor, decryptHandler, topSize, conn, dbType, dialect, fetchSize, maxRows);
    }

    @Override
    public QueryResult findBySql(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, String sql, Object[] paramsValue, QueryExecutorExtend queryExecutorExtend, DecryptHandler decryptHandler, Connection conn, LockMode lockMode, Integer dbType, String dialect, int fetchSize, int maxRows) throws Exception {
        String realSql = lockMode != null ? sql.concat(this.getLockSql(sql, dbType, lockMode)) : this.appendWithUR(sql);
        return DialectUtils.findBySql(sqlToyContext, sqlToyConfig, realSql, paramsValue, queryExecutorExtend, decryptHandler, conn, dbType, 0, fetchSize, maxRows);
    }

    @Override
    public Long getCountBySql(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, String sql, Object[] paramsValue, boolean isLastSql, Connection conn, Integer dbType, String dialect) throws Exception {
        return DialectUtils.getCountBySql(sqlToyContext, sqlToyConfig, this.appendWithUR(sql), paramsValue, isLastSql, conn, dbType);
    }

    @Override
    public Long saveOrUpdate(SqlToyContext sqlToyContext, Serializable entity, String[] forceUpdateFields, Connection conn, Integer dbType, String dialect, Boolean autoCommit, String tableName) throws Exception {
        ArrayList<Serializable> entities = new ArrayList<Serializable>();
        entities.add(entity);
        return this.saveOrUpdateAll(sqlToyContext, entities, sqlToyContext.getBatchSize(), null, forceUpdateFields, conn, dbType, dialect, autoCommit, tableName);
    }

    @Override
    public Long saveOrUpdateAll(final SqlToyContext sqlToyContext, List<?> entities, int batchSize, ReflectPropsHandler reflectPropsHandler, String[] forceUpdateFields, Connection conn, final Integer dbType, String dialect, Boolean autoCommit, final String tableName) throws Exception {
        EntityMeta entityMeta = sqlToyContext.getEntityMeta(entities.get(0).getClass());
        return DialectUtils.saveOrUpdateAll(sqlToyContext, entities, batchSize, entityMeta, forceUpdateFields, new GenerateSqlHandler(){

            @Override
            public String generateSql(EntityMeta entityMeta, String[] forceUpdateFields) {
                return DialectUtils.getSaveOrUpdateSql(sqlToyContext.getUnifyFieldsHandler(), dbType, entityMeta, entityMeta.getIdStrategy(), forceUpdateFields, DB2Dialect.VIRTUAL_TABLE, DB2Dialect.NVL_FUNCTION, "NEXTVAL FOR " + entityMeta.getSequence(), DB2DialectUtils.isAssignPKValue(entityMeta.getIdStrategy()), tableName);
            }
        }, reflectPropsHandler, conn, dbType, autoCommit);
    }

    @Override
    public Long saveAllIgnoreExist(final SqlToyContext sqlToyContext, List<?> entities, int batchSize, ReflectPropsHandler reflectPropsHandler, Connection conn, final Integer dbType, String dialect, Boolean autoCommit, final String tableName) throws Exception {
        EntityMeta entityMeta = sqlToyContext.getEntityMeta(entities.get(0).getClass());
        return DialectUtils.saveAllIgnoreExist(sqlToyContext, entities, batchSize, entityMeta, new GenerateSqlHandler(){

            @Override
            public String generateSql(EntityMeta entityMeta, String[] forceUpdateFields) {
                PKStrategy pkStrategy = entityMeta.getIdStrategy();
                return DialectExtUtils.mergeIgnore(sqlToyContext.getUnifyFieldsHandler(), dbType, entityMeta, pkStrategy, DB2Dialect.VIRTUAL_TABLE, DB2Dialect.NVL_FUNCTION, "NEXTVAL FOR " + entityMeta.getSequence(), DB2DialectUtils.isAssignPKValue(pkStrategy), tableName);
            }
        }, reflectPropsHandler, conn, dbType, autoCommit);
    }

    @Override
    public Long delete(SqlToyContext sqlToyContext, Serializable entity, Connection conn, Integer dbType, String dialect, String tableName) throws Exception {
        return DialectUtils.delete(sqlToyContext, entity, conn, dbType, tableName);
    }

    @Override
    public Long deleteAll(SqlToyContext sqlToyContext, List<?> entities, int batchSize, Connection conn, Integer dbType, String dialect, Boolean autoCommit, String tableName) throws Exception {
        return DialectUtils.deleteAll(sqlToyContext, entities, batchSize, conn, dbType, autoCommit, tableName);
    }

    @Override
    public QueryResult updateFetch(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, String sql, Object[] paramsValue, UpdateRowHandler updateRowHandler, Connection conn, Integer dbType, String dialect, LockMode lockMode, int fetchSize, int maxRows) throws Exception {
        String realSql = sql.concat(this.getLockSql(sql, dbType, lockMode == null ? LockMode.UPGRADE : lockMode));
        return DialectUtils.updateFetchBySql(sqlToyContext, sqlToyConfig, realSql, paramsValue, updateRowHandler, conn, dbType, 0, fetchSize, maxRows);
    }

    @Override
    public StoreResult executeStore(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, String sql, Object[] inParamsValue, Integer[] outParamsType, boolean moreResult, Connection conn, Integer dbType, String dialect, int fetchSize) throws Exception {
        return DialectUtils.executeStore(sqlToyConfig, sqlToyContext, sql, inParamsValue, outParamsType, moreResult, conn, dbType, fetchSize);
    }

    private String getLockSql(String sql, Integer dbType, LockMode lockMode) {
        if (lockMode == null || SqlUtil.hasLock(sql, dbType)) {
            return "";
        }
        return " for update with rs ";
    }

    @Override
    public List<ColumnMeta> getTableColumns(String catalog, String schema, String tableName, Connection conn, Integer dbType, String dialect) throws Exception {
        return DefaultDialectUtils.getTableColumns(catalog, schema, tableName, conn, dbType, dialect);
    }

    @Override
    public List<TableMeta> getTables(String catalog, String schema, String tableName, Connection conn, Integer dbType, String dialect) throws Exception {
        return DefaultDialectUtils.getTables(catalog, schema, tableName, conn, dbType, dialect);
    }
}

