/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.utils;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sagacity.sqltoy.config.annotation.SqlToyFieldAlias;
import org.sagacity.sqltoy.config.model.DTOEntityMapModel;
import org.sagacity.sqltoy.config.model.DataType;
import org.sagacity.sqltoy.model.Page;
import org.sagacity.sqltoy.model.PropsMapperConfig;
import org.sagacity.sqltoy.utils.BeanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapperUtils {
    protected static final Logger logger = LoggerFactory.getLogger(MapperUtils.class);
    private static Map<String, DTOEntityMapModel> dtoEntityMapperCache = new HashMap<String, DTOEntityMapModel>();
    private static int MAX_RECURSION = 3;

    private MapperUtils() {
    }

    @Deprecated
    public static <T extends Serializable> T map(Serializable source, Class<T> resultType, String ... ignoreProperties) throws RuntimeException {
        return MapperUtils.map(source, resultType, new PropsMapperConfig(ignoreProperties).isIgnore(true));
    }

    public static <T extends Serializable> T map(Serializable source, Class<T> resultType, PropsMapperConfig propsMapperConfig) throws RuntimeException {
        if (source == null) {
            return null;
        }
        if (resultType == null || BeanUtil.isBaseDataType(resultType)) {
            throw new IllegalArgumentException("resultType \u4e0d\u80fd\u4e3anull,\u4e14resultType\u4e0d\u80fd\u4e3a\u57fa\u672c\u7c7b\u578b!");
        }
        return MapperUtils.map(source, resultType, 0, propsMapperConfig);
    }

    @Deprecated
    public static <T extends Serializable> List<T> mapList(List sourceList, Class<T> resultType, String ... ignoreProperties) throws RuntimeException {
        return MapperUtils.mapList(sourceList, resultType, new PropsMapperConfig(ignoreProperties).isIgnore(true));
    }

    public static <T extends Serializable> List<T> mapList(List sourceList, Class<T> resultType, PropsMapperConfig propsMapperConfig) throws RuntimeException {
        if (sourceList == null) {
            return null;
        }
        if (resultType == null || BeanUtil.isBaseDataType(resultType)) {
            throw new IllegalArgumentException("resultType \u4e0d\u80fd\u4e3anull,\u4e14resultType\u4e0d\u80fd\u4e3a\u57fa\u672c\u7c7b\u578b!");
        }
        if (Modifier.isAbstract(resultType.getModifiers()) || Modifier.isInterface(resultType.getModifiers())) {
            throw new IllegalArgumentException("resultType:" + resultType.getName() + " \u662f\u62bd\u8c61\u7c7b\u6216\u63a5\u53e3,\u975e\u6cd5\u53c2\u6570!");
        }
        if (sourceList.isEmpty()) {
            return new ArrayList();
        }
        return MapperUtils.mapList(sourceList, resultType, 0, propsMapperConfig);
    }

    @Deprecated
    public static <T extends Serializable> Page<T> map(Page sourcePage, Class<T> resultType, String ... ignoreProperties) {
        return MapperUtils.map(sourcePage, resultType, new PropsMapperConfig(ignoreProperties).isIgnore(true));
    }

    public static <T extends Serializable> Page<T> map(Page sourcePage, Class<T> resultType, PropsMapperConfig propsMapperConfig) {
        if (sourcePage == null) {
            return null;
        }
        if (resultType == null || BeanUtil.isBaseDataType(resultType)) {
            throw new IllegalArgumentException("resultType \u4e0d\u80fd\u4e3anull,\u4e14resultType\u4e0d\u80fd\u4e3a\u57fa\u672c\u7c7b\u578b!");
        }
        Page<T> result = new Page<T>();
        result.setPageNo(sourcePage.getPageNo());
        result.setPageSize(sourcePage.getPageSize());
        result.setRecordCount(sourcePage.getRecordCount());
        result.setSkipQueryCount(sourcePage.getSkipQueryCount());
        if (sourcePage.getRows() == null || sourcePage.getRows().isEmpty()) {
            return result;
        }
        result.setRows(MapperUtils.mapList(sourcePage.getRows(), resultType, propsMapperConfig));
        return result;
    }

    @Deprecated
    public static void copyProperties(Serializable source, Serializable target, String ... ignoreProperties) throws RuntimeException {
        MapperUtils.copyProperties(source, target, new PropsMapperConfig(ignoreProperties).isIgnore(true));
    }

    public static void copyProperties(Serializable source, Serializable target, PropsMapperConfig propsMapperConfig) throws RuntimeException {
        if (source == null || target == null) {
            return;
        }
        if (BeanUtil.isBaseDataType(source.getClass()) || BeanUtil.isBaseDataType(target.getClass())) {
            throw new IllegalArgumentException("copyProperties<DTO>\u4e0d\u652f\u6301\u57fa\u672c\u7c7b\u578b\u5bf9\u8c61\u7684\u5c5e\u6027\u503c\u6620\u5c04!");
        }
        ArrayList<Serializable> sourceList = new ArrayList<Serializable>();
        sourceList.add(source);
        ArrayList<Serializable> targetList = new ArrayList<Serializable>();
        targetList.add(target);
        MapperUtils.copyProperties(sourceList, targetList, propsMapperConfig);
    }

    public static void copyProperties(List sourceList, List targetList, PropsMapperConfig propsMapperConfig) throws RuntimeException {
        Method[] setMethods;
        Method[] getMethods;
        PropsMapperConfig propConfig;
        if (sourceList == null || sourceList.isEmpty()) {
            throw new RuntimeException("copyProperties<List>\u64cd\u4f5csourceList\u4e3a\u7a7a\u5bf9\u8c61");
        }
        if (targetList == null || targetList.isEmpty()) {
            throw new RuntimeException("copyProperties<List>\u64cd\u4f5ctargetList\u4e3a\u7a7a\u5bf9\u8c61");
        }
        if (sourceList.size() != targetList.size()) {
            throw new RuntimeException("copyProperties<List>\u64cd\u4f5csourceList\u548ctargetList\u96c6\u5408\u6570\u636e\u8bb0\u5f55:" + sourceList.size() + "!=" + targetList.size() + "\u4e0d\u76f8\u540c!");
        }
        Class<?> sourceClass = sourceList.get(0).getClass();
        Class<?> targetClass = targetList.get(0).getClass();
        if (BeanUtil.isBaseDataType(sourceClass) || BeanUtil.isBaseDataType(targetClass)) {
            throw new IllegalArgumentException("copyProperties<List>\u4e0d\u652f\u6301\u57fa\u672c\u7c7b\u578b\u5bf9\u8c61\u7684\u5c5e\u6027\u503c\u6620\u5c04!");
        }
        PropsMapperConfig propsMapperConfig2 = propConfig = propsMapperConfig == null ? new PropsMapperConfig(new String[0]) : propsMapperConfig;
        if (propConfig.isIgnore() || propConfig.getProperties() == null) {
            Object[] getSetMethods = MapperUtils.matchGetSetMethods(sourceClass, targetClass, propConfig.getProperties());
            if (getSetMethods == null) {
                return;
            }
            getMethods = (Method[])getSetMethods[0];
            setMethods = (Method[])getSetMethods[1];
        } else {
            getMethods = BeanUtil.matchGetMethods(sourceClass, propConfig.getProperties());
            setMethods = BeanUtil.matchSetMethods(targetClass, propConfig.getProperties());
        }
        if (getMethods.length < 1 || setMethods.length < 1) {
            return;
        }
        try {
            List dataSets = MapperUtils.invokeGetValues(sourceList, getMethods);
            MapperUtils.listToList(dataSets, targetList, setMethods, propsMapperConfig.getSkipNull());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("copyProperties<List>\u7c7b\u578b:[" + sourceClass.getName() + "-->" + targetClass.getName() + "]\u6620\u5c04\u64cd\u4f5c\u5931\u8d25:" + e.getMessage());
        }
    }

    @Deprecated
    public static void copyProperties(List sourceList, List targetList, String ... ignoreProperties) throws RuntimeException {
        MapperUtils.copyProperties(sourceList, targetList, new PropsMapperConfig(ignoreProperties).isIgnore(true));
    }

    private static <T extends Serializable> T map(Serializable source, Class<T> resultType, int recursionLevel, PropsMapperConfig propsMapperConfig) throws RuntimeException {
        ArrayList<Serializable> sourceList = new ArrayList<Serializable>();
        sourceList.add(source);
        List<T> result = MapperUtils.mapList(sourceList, resultType, recursionLevel, propsMapperConfig);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return (T)((Serializable)result.get(0));
    }

    private static <T extends Serializable> List<T> mapList(List sourceList, Class<T> targetClass, int recursionLevel, PropsMapperConfig propsMapperConfig) throws RuntimeException {
        Method[] setMethods;
        Method[] getMethods;
        PropsMapperConfig propConfig;
        Class<?> sourceClass = sourceList.iterator().next().getClass();
        PropsMapperConfig propsMapperConfig2 = propConfig = propsMapperConfig == null ? new PropsMapperConfig(new String[0]) : propsMapperConfig;
        if (propConfig.isIgnore() || propConfig.getProperties() == null) {
            Object[] getSetMethods = MapperUtils.matchGetSetMethods(sourceClass, targetClass, propConfig.getProperties());
            if (getSetMethods == null) {
                return null;
            }
            getMethods = (Method[])getSetMethods[0];
            setMethods = (Method[])getSetMethods[1];
        } else {
            getMethods = BeanUtil.matchGetMethods(sourceClass, propConfig.getProperties());
            setMethods = BeanUtil.matchSetMethods(targetClass, propConfig.getProperties());
        }
        if (getMethods.length < 1 || setMethods.length < 1) {
            return null;
        }
        try {
            List dataSets = MapperUtils.invokeGetValues(sourceList, getMethods);
            return MapperUtils.reflectListToBean(dataSets, targetClass, setMethods, recursionLevel);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("map/mapList,\u7c7b\u578b:[" + sourceClass.getName() + "-->" + targetClass.getName() + "]\u6620\u5c04\u64cd\u4f5c\u5931\u8d25:" + e.getMessage());
        }
    }

    private static List invokeGetValues(List sourceList, Method[] getMethods) throws Exception {
        ArrayList result = new ArrayList();
        int n = sourceList.size();
        for (int i = 0; i < n; ++i) {
            Object row = sourceList.get(i);
            if (row == null) continue;
            ArrayList<Object> rowData = new ArrayList<Object>();
            for (Method method : getMethods) {
                if (method == null) {
                    rowData.add(null);
                    continue;
                }
                rowData.add(method.invoke(row, new Object[0]));
            }
            result.add(rowData);
        }
        return result;
    }

    private static DTOEntityMapModel getDTOEntityMap(Class sourceClass, Class resultType) {
        String sourceKey = sourceClass.getName();
        String resultKey = resultType.getName();
        String key = "fromClass=".concat(sourceKey).concat(";toClass=").concat(resultKey);
        if (dtoEntityMapperCache.containsKey(key)) {
            return dtoEntityMapperCache.get(key);
        }
        DTOEntityMapModel result = MapperUtils.sourceMapTarget(sourceClass, resultType);
        dtoEntityMapperCache.put(key, result);
        return result;
    }

    private static DTOEntityMapModel sourceMapTarget(Class fromClass, Class targetClass) {
        String fieldName;
        if (BeanUtil.isBaseDataType(fromClass) || BeanUtil.isBaseDataType(targetClass)) {
            return null;
        }
        DTOEntityMapModel result = new DTOEntityMapModel();
        HashMap<String, String> targetPropsMap = new HashMap<String, String>();
        Class parentClass = targetClass;
        while (!parentClass.equals(Object.class)) {
            for (Field field : parentClass.getDeclaredFields()) {
                fieldName = field.getName();
                targetPropsMap.put(fieldName.toLowerCase(), fieldName);
            }
            parentClass = parentClass.getSuperclass();
        }
        boolean checkAlias = !fromClass.equals(targetClass);
        ArrayList<String> fromClassProps = new ArrayList<String>();
        ArrayList targetProps = new ArrayList();
        parentClass = fromClass;
        while (!parentClass.equals(Object.class)) {
            for (Field field : parentClass.getDeclaredFields()) {
                SqlToyFieldAlias alias;
                String aliasName = fieldName = field.getName();
                if (checkAlias && (alias = field.getAnnotation(SqlToyFieldAlias.class)) != null) {
                    aliasName = alias.value();
                }
                if (fromClassProps.contains(fieldName)) continue;
                if (targetPropsMap.containsKey(fieldName.toLowerCase())) {
                    fromClassProps.add(fieldName);
                    targetProps.add(targetPropsMap.get(fieldName.toLowerCase()));
                    continue;
                }
                if (!targetPropsMap.containsKey(aliasName.toLowerCase())) continue;
                fromClassProps.add(fieldName);
                targetProps.add(targetPropsMap.get(aliasName.toLowerCase()));
            }
            parentClass = parentClass.getSuperclass();
        }
        result.fromClassName = fromClass.getName();
        result.fromProps = fromClassProps.toArray(new String[fromClassProps.size()]);
        result.targetClassName = targetClass.getName();
        result.targetProps = targetProps.toArray(new String[targetProps.size()]);
        if (fromClassProps.isEmpty()) {
            return result;
        }
        result.fromGetMethods = BeanUtil.matchGetMethods(fromClass, result.fromProps);
        result.targetSetMethods = BeanUtil.matchSetMethods(targetClass, result.targetProps);
        return result;
    }

    private static List reflectListToBean(List dataSet, Class voClass, Method[] realMethods, int recursionLevel) throws Exception {
        ArrayList result = new ArrayList();
        int indexSize = realMethods.length;
        String[] methodTypes = new String[indexSize];
        int[] methodTypeValues = new int[indexSize];
        Class[] methodGenTypes = new Class[indexSize];
        Boolean[] isList = new Boolean[indexSize];
        Boolean[] notListBaseType = new Boolean[indexSize];
        for (int i = 0; i < indexSize; ++i) {
            isList[i] = Boolean.FALSE;
            notListBaseType[i] = Boolean.TRUE;
            if (null == realMethods[i]) continue;
            Class methodType = realMethods[i].getParameterTypes()[0];
            methodTypes[i] = methodType.getTypeName();
            methodTypeValues[i] = DataType.getType(methodType);
            if (!(methodTypeValues[i] != 0 && methodTypeValues[i] != 101 && methodTypeValues[i] != 102 || methodType.isEnum() || Map.class.isAssignableFrom(methodType))) {
                methodGenTypes[i] = realMethods[i].getParameterTypes()[0];
            }
            if (!(realMethods[i].getGenericParameterTypes()[0] instanceof ParameterizedType)) continue;
            methodGenTypes[i] = methodType = (Class)((ParameterizedType)realMethods[i].getGenericParameterTypes()[0]).getActualTypeArguments()[0];
            if (!(BeanUtil.isBaseDataType(methodType) || List.class.equals((Object)methodType) || ArrayList.class.equals((Object)methodType) || methodType.isEnum() || Map.class.isAssignableFrom(methodType) || methodType.isArray())) {
                notListBaseType[i] = Boolean.FALSE;
            }
            if (!realMethods[i].getParameterTypes()[0].equals(List.class) && !realMethods[i].getParameterTypes()[0].equals(ArrayList.class)) continue;
            isList[i] = Boolean.TRUE;
        }
        Object cellData = null;
        Object convertData = null;
        PropsMapperConfig emptyConfig = new PropsMapperConfig(new String[0]);
        int end = dataSet.size();
        for (int i = 0; i < end; ++i) {
            List row = (List)dataSet.get(i);
            if (row == null) continue;
            Object bean = voClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            int size = row.size();
            for (int j = 0; j < size; ++j) {
                cellData = row.get(j);
                if (cellData == null || realMethods[j] == null) continue;
                if (methodTypeValues[j] != 0 && methodTypeValues[j] != 101 && methodTypeValues[j] != 102) {
                    realMethods[j].invoke(bean, BeanUtil.convertType(cellData, methodTypeValues[j], methodTypes[j]));
                    continue;
                }
                if (methodGenTypes[j] != null && cellData instanceof List && isList[j].booleanValue()) {
                    List cellList = (List)cellData;
                    if (cellList.isEmpty()) continue;
                    if (!notListBaseType[j].booleanValue() && recursionLevel < MAX_RECURSION) {
                        List subItems = MapperUtils.mapList((List)cellData, methodGenTypes[j], recursionLevel + 1, emptyConfig);
                        if (subItems == null || subItems.isEmpty()) continue;
                        realMethods[j].invoke(bean, subItems);
                        continue;
                    }
                    if (cellList.get(0) == null || !cellList.get(0).getClass().equals(methodGenTypes[j])) continue;
                    realMethods[j].invoke(bean, cellList);
                    continue;
                }
                if (recursionLevel < MAX_RECURSION && methodGenTypes[j] != null && cellData instanceof Serializable) {
                    convertData = MapperUtils.map((Serializable)cellData, methodGenTypes[j], recursionLevel + 1, emptyConfig);
                    if (convertData == null) continue;
                    realMethods[j].invoke(bean, convertData);
                    continue;
                }
                if (!cellData.getClass().getTypeName().equals(methodTypes[j])) continue;
                realMethods[j].invoke(bean, cellData);
            }
            result.add(bean);
        }
        return result;
    }

    private static void listToList(List dataSet, List targetList, Method[] realMethods, boolean skipNull) throws Exception {
        int indexSize = realMethods.length;
        String[] methodTypes = new String[indexSize];
        int[] methodTypeValues = new int[indexSize];
        for (int i = 0; i < indexSize; ++i) {
            if (null == realMethods[i]) continue;
            Class<?> methodType = realMethods[i].getParameterTypes()[0];
            methodTypes[i] = methodType.getTypeName();
            methodTypeValues[i] = DataType.getType(methodType);
        }
        Object cellData = null;
        int end = dataSet.size();
        for (int i = 0; i < end; ++i) {
            List row = (List)dataSet.get(i);
            if (row == null) continue;
            Object bean = targetList.get(i);
            int size = row.size();
            for (int j = 0; j < size; ++j) {
                cellData = row.get(j);
                if (realMethods[j] == null) continue;
                if (cellData != null) {
                    if (methodTypeValues[j] != 0 && methodTypeValues[j] != 101 && methodTypeValues[j] != 102) {
                        realMethods[j].invoke(bean, BeanUtil.convertType(cellData, methodTypeValues[j], methodTypes[j]));
                        continue;
                    }
                    if (!cellData.getClass().getTypeName().equals(methodTypes[j])) continue;
                    realMethods[j].invoke(bean, cellData);
                    continue;
                }
                if (skipNull) continue;
                realMethods[j].invoke(bean, BeanUtil.convertType(cellData, methodTypeValues[j], methodTypes[j]));
            }
        }
    }

    private static Object[] matchGetSetMethods(Class sourceClass, Class targetClass, String ... ignoreProperties) {
        DTOEntityMapModel mapModel = MapperUtils.getDTOEntityMap(sourceClass, targetClass);
        if (mapModel == null || mapModel.fromGetMethods == null || mapModel.targetSetMethods == null) {
            return null;
        }
        Method[] getMethods = mapModel.fromGetMethods;
        Method[] setMethods = mapModel.targetSetMethods;
        boolean getAllNull = true;
        boolean setAllNull = true;
        for (int i = 0; i < getMethods.length; ++i) {
            if (getMethods[i] != null) {
                getAllNull = false;
            }
            if (setMethods[i] == null) continue;
            setAllNull = false;
        }
        if (getAllNull || setAllNull) {
            return null;
        }
        if (ignoreProperties != null && ignoreProperties.length > 0) {
            ArrayList<Method> getRealMethods = new ArrayList<Method>();
            ArrayList<Method> setRealMethods = new ArrayList<Method>();
            ArrayList<String> ignoreProps = new ArrayList<String>();
            for (String ignoreProp : ignoreProperties) {
                ignoreProps.add(ignoreProp.toLowerCase());
            }
            for (int i = 0; i < setMethods.length; ++i) {
                if (setMethods[i] == null) continue;
                String methodName = setMethods[i].getName().toLowerCase();
                Class<?> paramType = setMethods[i].getParameterTypes()[0];
                boolean skip = false;
                for (int j = 0; j < ignoreProps.size(); ++j) {
                    String ignorePropLow = (String)ignoreProps.get(j);
                    if (!methodName.equals("set".concat(ignorePropLow)) && (!ignorePropLow.startsWith("is") || !paramType.equals(Boolean.TYPE) || !methodName.equals("set".concat(ignorePropLow.substring(2))))) continue;
                    skip = true;
                    ignoreProps.remove(j);
                    --j;
                    break;
                }
                if (skip) continue;
                getRealMethods.add(getMethods[i]);
                setRealMethods.add(setMethods[i]);
            }
            if (setRealMethods.size() == 0) {
                logger.warn("\u6700\u7ec8\u6620\u5c04\u5bf9\u5e94\u7684\u5c5e\u6027\u6570\u91cf\u4e3a\u96f6,\u8bf7\u68c0\u67e5ignoreProperties\u662f\u5426\u6b63\u786e,\u8fc7\u6ee4\u4e86\u5168\u90e8\u5339\u914d\u5c5e\u6027!");
                return null;
            }
            getMethods = new Method[setRealMethods.size()];
            setMethods = new Method[setRealMethods.size()];
            getRealMethods.toArray(getMethods);
            setRealMethods.toArray(setMethods);
        }
        Object[] result = new Object[]{getMethods, setMethods};
        return result;
    }
}

