/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.translate.cache.impl;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import org.sagacity.sqltoy.translate.cache.TranslateCacheManager;
import org.sagacity.sqltoy.translate.model.TranslateConfigModel;
import org.sagacity.sqltoy.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.caffeine.CaffeineCacheManager;

public class TranslateCaffeineManager
extends TranslateCacheManager {
    protected static final Logger logger = LoggerFactory.getLogger(TranslateCaffeineManager.class);
    protected static CaffeineCacheManager cacheManager;
    private HashSet<String> cacheNameSet = new HashSet();

    @Override
    public HashMap<String, Object[]> getCache(String cacheName, String cacheType) {
        if (cacheManager == null) {
            return null;
        }
        Cache cache = cacheManager.getCache(cacheName);
        if (cache == null) {
            return null;
        }
        Cache.ValueWrapper wrapper = cache.get((Object)(StringUtil.isNotBlank(cacheType) ? cacheType : cacheName));
        if (wrapper != null) {
            return (HashMap)wrapper.get();
        }
        return null;
    }

    @Override
    public boolean hasCache(String cacheName) {
        Cache cache = cacheManager.getCache(cacheName);
        return null != cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(TranslateConfigModel cacheConfig, String cacheName, String cacheType, HashMap<String, Object[]> cacheValue) {
        if (cacheManager == null) {
            return;
        }
        String string = cacheName.intern();
        synchronized (string) {
            if (!this.cacheNameSet.contains(cacheName)) {
                Caffeine caffeine = Caffeine.newBuilder();
                if (cacheConfig.getHeap() > 0) {
                    caffeine.maximumSize(cacheConfig.getHeap() < 100 ? 1000L : (long)cacheConfig.getHeap());
                }
                if (cacheConfig.getKeepAlive() > 0) {
                    caffeine.expireAfterWrite(Duration.ofSeconds(cacheConfig.getKeepAlive()));
                }
                cacheManager.registerCustomCache(cacheName, caffeine.build());
                this.cacheNameSet.add(cacheName);
            }
            Cache cache = cacheManager.getCache(cacheName);
            if (cacheValue == null) {
                if (StringUtil.isBlank(cacheType)) {
                    cache.clear();
                } else {
                    cache.evict((Object)cacheType);
                }
            } else {
                cache.put((Object)(StringUtil.isBlank(cacheType) ? cacheName : cacheType), cacheValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear(String cacheName, String cacheType) {
        if (cacheManager == null) {
            return;
        }
        String string = cacheName.intern();
        synchronized (string) {
            Cache cache = cacheManager.getCache(cacheName);
            if (cache != null) {
                if (StringUtil.isBlank(cacheType)) {
                    cache.clear();
                } else {
                    cache.evict((Object)cacheType);
                }
            }
        }
    }

    @Override
    public boolean init() {
        if (cacheManager != null) {
            return true;
        }
        cacheManager = new CaffeineCacheManager();
        logger.debug("\u5df2\u7ecf\u542f\u52a8caffeine \u7f13\u5b58\u7ba1\u7406\u5668--------------------------------------");
        return true;
    }

    @Override
    public void destroy() {
        if (cacheManager != null) {
            cacheManager = null;
        }
    }
}

