/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.service.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sagacity.sqltoy.dao.SqlToyLazyDao;
import org.sagacity.sqltoy.model.CacheMatchFilter;
import org.sagacity.sqltoy.model.Page;
import org.sagacity.sqltoy.model.ParallQuery;
import org.sagacity.sqltoy.model.ParallelConfig;
import org.sagacity.sqltoy.model.QueryResult;
import org.sagacity.sqltoy.model.TreeTableModel;
import org.sagacity.sqltoy.service.SqlToyCRUDService;
import org.sagacity.sqltoy.translate.TranslateHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="sqlToyCRUDService")
public class SqlToyCRUDServiceImpl
implements SqlToyCRUDService {
    protected final Logger logger = LoggerFactory.getLogger(SqlToyCRUDServiceImpl.class);
    protected SqlToyLazyDao sqlToyLazyDao;

    @Autowired(required=false)
    @Qualifier(value="sqlToyLazyDao")
    public void setSqlToyLazyDao(SqlToyLazyDao sqlToyLazyDao) {
        this.sqlToyLazyDao = sqlToyLazyDao;
    }

    @Override
    @Transactional
    public Object save(Serializable entity) {
        return this.sqlToyLazyDao.save(entity);
    }

    @Override
    @Transactional
    public <T extends Serializable> Long saveAll(List<T> entities) {
        return this.sqlToyLazyDao.saveAll(entities);
    }

    @Override
    @Transactional
    public <T extends Serializable> Long saveAllIgnoreExist(List<T> entities) {
        return this.sqlToyLazyDao.saveAllIgnoreExist(entities);
    }

    @Override
    @Transactional
    public Long update(Serializable entity, String ... forceUpdateProps) {
        if (null == entity) {
            throw new IllegalArgumentException("update \u6570\u636e\u5bf9\u8c61\u4e3anull!");
        }
        return this.sqlToyLazyDao.update(entity, forceUpdateProps);
    }

    @Override
    @Transactional
    public Long updateCascade(Serializable entity, String ... forceUpdateProps) {
        if (null == entity) {
            throw new IllegalArgumentException("update \u6570\u636e\u5bf9\u8c61\u4e3anull!");
        }
        return this.sqlToyLazyDao.updateCascade(entity, forceUpdateProps, null, null);
    }

    @Override
    @Transactional
    public Long updateDeeply(Serializable entity) {
        if (null == entity) {
            throw new IllegalArgumentException("updateDeeply \u6570\u636e\u5bf9\u8c61\u4e3anull!");
        }
        return this.sqlToyLazyDao.updateDeeply(entity);
    }

    @Override
    @Transactional
    public <T extends Serializable> Long updateAll(List<T> entities, String ... forceUpdateProps) {
        return this.sqlToyLazyDao.updateAll(entities, forceUpdateProps);
    }

    @Override
    @Transactional
    public <T extends Serializable> Long updateAllDeeply(List<T> entities) {
        return this.sqlToyLazyDao.updateAllDeeply(entities);
    }

    @Override
    @Transactional
    public Long saveOrUpdate(Serializable entity, String ... forceUpdateProps) {
        if (null == entity) {
            throw new IllegalArgumentException("saveOrUpdate  \u6570\u636e\u5bf9\u8c61\u4e3anull!");
        }
        return this.sqlToyLazyDao.saveOrUpdate(entity, forceUpdateProps);
    }

    @Override
    @Transactional
    public <T extends Serializable> Long saveOrUpdateAll(List<T> entities, String ... forceUpdateProps) {
        return this.sqlToyLazyDao.saveOrUpdateAll(entities, forceUpdateProps);
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public <T extends Serializable> T load(T entity) {
        return this.sqlToyLazyDao.load(entity);
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public <T extends Serializable> T loadCascade(T entity) {
        return this.sqlToyLazyDao.loadCascade(entity, null, new Class[0]);
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public <T extends Serializable> List<T> loadAll(List<T> entities) {
        return this.sqlToyLazyDao.loadAll(entities);
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public <T extends Serializable> List<T> loadAllCascade(List<T> entities, Class ... cascadeTypes) {
        return this.sqlToyLazyDao.loadAllCascade(entities, cascadeTypes);
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public <T extends Serializable> List<T> loadByIds(Class<T> voClass, Object ... ids) {
        return this.sqlToyLazyDao.loadByIds(voClass, ids);
    }

    @Override
    @Transactional
    public Long delete(Serializable entity) {
        return this.sqlToyLazyDao.delete(entity);
    }

    @Override
    @Transactional
    public <T extends Serializable> Long deleteAll(List<T> entities) {
        return this.sqlToyLazyDao.deleteAll(entities);
    }

    @Override
    public Long deleteByIds(Class entityClass, Object ... ids) {
        return this.sqlToyLazyDao.deleteByIds(entityClass, ids);
    }

    @Override
    @Transactional
    public void truncate(Class entityClass) {
        this.sqlToyLazyDao.truncate(entityClass);
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public boolean isUnique(Serializable entity, String ... paramsNamed) {
        return this.sqlToyLazyDao.isUnique(entity, paramsNamed);
    }

    @Override
    @Transactional
    public boolean wrapTreeTableRoute(Serializable entity, String pidField) {
        return this.sqlToyLazyDao.wrapTreeTableRoute(new TreeTableModel(entity).pidField(pidField));
    }

    @Override
    @Transactional
    public boolean wrapTreeTableRoute(Serializable entity, String pidField, int appendIdSize) {
        return this.sqlToyLazyDao.wrapTreeTableRoute(new TreeTableModel(entity).pidField(pidField).idLength(appendIdSize));
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public <T> List<QueryResult<T>> parallQuery(List<ParallQuery> parallQueryList, String[] paramNames, Object[] paramValues) {
        return this.sqlToyLazyDao.parallQuery(parallQueryList, paramNames, paramValues, null);
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public <T> List<QueryResult<T>> parallQuery(List<ParallQuery> parallQueryList, String[] paramNames, Object[] paramValues, ParallelConfig parallelConfig) {
        return this.sqlToyLazyDao.parallQuery(parallQueryList, paramNames, paramValues, parallelConfig);
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public <T> List<QueryResult<T>> parallQuery(List<ParallQuery> parallQueryList, Map<String, Object> paramsMap, ParallelConfig parallelConfig) {
        return this.sqlToyLazyDao.parallQuery(parallQueryList, paramsMap, parallelConfig);
    }

    @Override
    public long generateBizId(String signature, int increment) {
        return this.sqlToyLazyDao.generateBizId(signature, increment);
    }

    @Override
    public String generateBizId(Serializable entity) {
        return this.sqlToyLazyDao.generateBizId(entity);
    }

    @Override
    public void translate(Collection dataSet, String cacheName, TranslateHandler handler) {
        this.sqlToyLazyDao.translate(dataSet, cacheName, null, 1, handler);
    }

    @Override
    public void translate(Collection dataSet, String cacheName, String dictType, Integer index, TranslateHandler handler) {
        this.sqlToyLazyDao.translate(dataSet, cacheName, dictType, index, handler);
    }

    @Override
    public boolean existCache(String cacheName) {
        return this.sqlToyLazyDao.existCache(cacheName);
    }

    @Override
    public Set<String> getCacheNames() {
        return this.sqlToyLazyDao.getCacheNames();
    }

    @Override
    public String[] cacheMatchKeys(String matchRegex, CacheMatchFilter cacheMatchFilter) {
        return this.sqlToyLazyDao.cacheMatchKeys(cacheMatchFilter, matchRegex);
    }

    @Override
    public String[] cacheMatchKeys(CacheMatchFilter cacheMatchFilter, String ... matchRegexes) {
        return this.sqlToyLazyDao.cacheMatchKeys(cacheMatchFilter, matchRegexes);
    }

    @Override
    public <T extends Serializable> List<T> convertType(List sourceList, Class<T> resultType) {
        return this.sqlToyLazyDao.convertType(sourceList, resultType, new String[0]);
    }

    @Override
    public <T extends Serializable> T convertType(Serializable source, Class<T> resultType) {
        return this.sqlToyLazyDao.convertType(source, resultType, new String[0]);
    }

    @Override
    public <T extends Serializable> Page<T> convertType(Page sourcePage, Class<T> resultType) {
        return this.sqlToyLazyDao.convertType(sourcePage, resultType, new String[0]);
    }
}

