/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.link;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.sql.DataSource;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.link.BaseLink;

public class Update
extends BaseLink {
    private static final long serialVersionUID = 5391575924738181611L;
    private String[] forceUpdateProps;
    private boolean deeply = false;
    private Boolean autoCommit = null;
    private int batchSize = 0;
    private String[] uniqueFields;
    private Class[] forceCascadeClasses;
    private HashMap<Class, String[]> subTableForceUpdateProps;

    public Update(SqlToyContext sqlToyContext, DataSource dataSource) {
        super(sqlToyContext, dataSource);
    }

    public Update dataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        this.defaultDataSource = false;
        return this;
    }

    public Update autoCommit(Boolean autoCommit) {
        this.autoCommit = autoCommit;
        return this;
    }

    public Update deeply(boolean deeply) {
        this.deeply = deeply;
        return this;
    }

    public Update batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public Update cascadeClasses(Class ... forceCascadeClasses) {
        this.forceCascadeClasses = forceCascadeClasses;
        return this;
    }

    public Update cascadeForceUpdate(HashMap<Class, String[]> subTableForceUpdateProps) {
        this.subTableForceUpdateProps = subTableForceUpdateProps;
        return this;
    }

    public Update forceUpdateProps(String ... forceUpdateProps) {
        this.forceUpdateProps = forceUpdateProps;
        return this;
    }

    public Long one(Serializable entity) {
        if (entity == null) {
            throw new IllegalArgumentException("update operate entity is null!");
        }
        boolean cascade = false;
        if (this.forceCascadeClasses != null && this.forceCascadeClasses.length > 0 || this.subTableForceUpdateProps != null && !this.subTableForceUpdateProps.isEmpty()) {
            cascade = true;
        }
        String[] forceUpdate = this.forceUpdateProps;
        if (this.deeply) {
            forceUpdate = this.sqlToyContext.getEntityMeta(entity.getClass()).getRejectIdFieldArray();
        }
        if (this.uniqueFields != null && this.uniqueFields.length > 0) {
            ArrayList<Serializable> entities = new ArrayList<Serializable>();
            entities.add(entity);
            return this.dialectFactory.updateAll(this.sqlToyContext, entities, 1, this.uniqueFields, forceUpdate, null, this.getDataSource(null), null);
        }
        return this.dialectFactory.update(this.sqlToyContext, entity, forceUpdate, cascade, this.forceCascadeClasses, this.subTableForceUpdateProps, this.getDataSource(null));
    }

    public Long many(List<?> entities) {
        if (entities == null || entities.isEmpty()) {
            throw new IllegalArgumentException("updateAll operate entities is null or empty!");
        }
        String[] forceUpdate = this.forceUpdateProps;
        if (this.deeply) {
            Object entity = null;
            for (Object o : entities) {
                if (o == null) continue;
                entity = o;
                break;
            }
            forceUpdate = this.sqlToyContext.getEntityMeta(entity.getClass()).getRejectIdFieldArray();
        }
        int realBatchSize = this.batchSize > 0 ? this.batchSize : this.sqlToyContext.getBatchSize();
        return this.dialectFactory.updateAll(this.sqlToyContext, entities, realBatchSize, this.uniqueFields, forceUpdate, null, this.getDataSource(null), this.autoCommit);
    }
}

