/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.integration.impl;

import java.util.Date;
import org.sagacity.sqltoy.integration.AppContext;
import org.sagacity.sqltoy.integration.DistributeIdGenerator;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.support.atomic.RedisAtomicLong;

public class SpringRedisIdGenerator
implements DistributeIdGenerator {
    private static final String GLOBAL_ID_PREFIX = "SQLTOY_GL_ID:";
    private RedisTemplate<?, ?> redisTemplate;

    @Override
    public long generateId(String key, int increment, Date expireTime) {
        RedisAtomicLong counter = new RedisAtomicLong(GLOBAL_ID_PREFIX.concat(key), this.redisTemplate.getConnectionFactory());
        if (expireTime != null) {
            counter.expireAt(expireTime);
        }
        if (increment > 1) {
            return counter.addAndGet((long)increment);
        }
        return counter.incrementAndGet();
    }

    @Override
    public void initialize(AppContext appContext) {
        if (this.redisTemplate == null) {
            this.redisTemplate = (RedisTemplate)appContext.getBean("redisTemplate");
        }
    }
}

