/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.config;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.sagacity.sqltoy.config.SqlXMLConfigParse;
import org.sagacity.sqltoy.config.model.SqlToyConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlFileModifyWatcher
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(SqlFileModifyWatcher.class);
    private ConcurrentHashMap<String, SqlToyConfig> sqlCache;
    private ConcurrentHashMap<String, Long> filesLastModifyMap;
    private List realSqlList;
    private String dialect;
    private String encoding;
    private int sleepSeconds = 1;
    private int delayCheckSeconds;

    public SqlFileModifyWatcher(ConcurrentHashMap<String, SqlToyConfig> sqlCache, ConcurrentHashMap<String, Long> filesLastModifyMap, List realSqlList, String dialect, String encoding, int delayCheckSeconds, int sleepSeconds) {
        this.sqlCache = sqlCache;
        this.realSqlList = realSqlList;
        this.dialect = dialect;
        this.encoding = encoding;
        this.filesLastModifyMap = filesLastModifyMap;
        this.delayCheckSeconds = delayCheckSeconds;
        this.sleepSeconds = sleepSeconds >= 1 ? sleepSeconds : 1;
    }

    @Override
    public void run() {
        try {
            if (this.delayCheckSeconds >= 1) {
                Thread.sleep(1000 * this.delayCheckSeconds);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        boolean isRun = true;
        while (isRun) {
            try {
                SqlXMLConfigParse.parseXML(this.realSqlList, this.filesLastModifyMap, this.sqlCache, this.encoding, this.dialect);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("\u91cd\u65b0\u89e3\u6790SQL\u5bf9\u5e94\u7684xml\u6587\u4ef6\u9519\u8bef!{}", (Object)e.getMessage(), (Object)e);
            }
            try {
                Thread.sleep(1000 * this.sleepSeconds);
            }
            catch (InterruptedException e) {
                logger.warn("sql\u6587\u4ef6\u53d8\u66f4\u76d1\u6d4b\u7a0b\u5e8f\u8fdb\u7a0b\u5f02\u5e38,\u76d1\u6d4b\u5c06\u7ec8\u6b62!{}", (Object)e.getMessage(), (Object)e);
                isRun = false;
            }
        }
    }
}

