/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.translate.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.sagacity.sqltoy.translate.model.TimeSection;
import org.sagacity.sqltoy.utils.NumberUtil;
import org.sagacity.sqltoy.utils.StringUtil;

public class CheckerConfigModel
implements Serializable {
    private static final long serialVersionUID = -8328516221738636079L;
    private String id;
    private String type = "sql";
    private String sql;
    private String cache;
    private boolean hasInsideGroup;
    private boolean increment = true;
    private String dataSource;
    private String checkFrequency;
    private String service;
    private String method;
    private String[] properties;
    private String url;
    private String username;
    private String password;
    private List<TimeSection> timeSections;

    public String getId() {
        if (this.id != null) {
            return this.id;
        }
        if (this.cache != null) {
            return this.cache;
        }
        if (this.type.equals("sql")) {
            return this.sql;
        }
        if (this.type.equals("service")) {
            return this.service + "." + this.method;
        }
        if (this.type.equals("rest")) {
            return this.url;
        }
        return null;
    }

    public String getType() {
        return this.type;
    }

    public CheckerConfigModel setType(String type) {
        if (type != null) {
            this.type = type.toLowerCase();
        }
        return this;
    }

    public String getSql() {
        return this.sql;
    }

    public CheckerConfigModel setSql(String sql) {
        this.sql = sql;
        this.type = "sql";
        return this;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public CheckerConfigModel setDataSource(String dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public String getCheckFrequency() {
        return this.checkFrequency;
    }

    public CheckerConfigModel setCheckFrequency(String frequency) {
        if (StringUtil.isNotBlank(frequency)) {
            ArrayList<TimeSection> timeParts = new ArrayList<TimeSection>();
            this.checkFrequency = frequency = StringUtil.toDBC(frequency).replaceAll("\\;", ",").trim();
            if (NumberUtil.isInteger(frequency)) {
                TimeSection section = new TimeSection();
                section.setStart(0);
                section.setEnd(2400);
                section.setIntervalSeconds(Integer.parseInt(frequency));
                timeParts.add(section);
            } else {
                String[] sectionsStr = frequency.split("\\,");
                for (int j = 0; j < sectionsStr.length; ++j) {
                    TimeSection section = new TimeSection();
                    String[] sectionPhase = sectionsStr[j].split("\\?");
                    String[] startEnd = sectionPhase[0].split("\\.{2}");
                    section.setIntervalSeconds(Integer.parseInt(sectionPhase[1].trim()));
                    section.setStart(this.getHourMinute(startEnd[0].trim()));
                    section.setEnd(this.getHourMinute(startEnd[1].trim()));
                    timeParts.add(section);
                }
            }
            this.timeSections = timeParts;
        }
        return this;
    }

    private int getHourMinute(String hourMinuteStr) {
        if (NumberUtil.isInteger(hourMinuteStr) && hourMinuteStr.length() > 2) {
            return Integer.parseInt(hourMinuteStr);
        }
        String tmp = hourMinuteStr.replaceAll("\\.", ":");
        String[] hourMin = tmp.split("\\:");
        return Integer.parseInt(hourMin[0]) * 100 + (hourMin.length > 1 ? Integer.parseInt(hourMin[1]) : 0);
    }

    public String getService() {
        return this.service;
    }

    public CheckerConfigModel setService(String service) {
        this.service = service;
        this.type = "service";
        return this;
    }

    public String getMethod() {
        return this.method;
    }

    public CheckerConfigModel setMethod(String method) {
        this.method = method;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public CheckerConfigModel setUrl(String url) {
        this.url = url;
        this.type = "rest";
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public CheckerConfigModel setUsername(String username) {
        this.username = username;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public CheckerConfigModel setPassword(String password) {
        this.password = password;
        return this;
    }

    public List<TimeSection> getTimeSections() {
        return this.timeSections;
    }

    public String[] getProperties() {
        return this.properties;
    }

    public CheckerConfigModel setProperties(String[] properties) {
        this.properties = properties;
        return this;
    }

    public String getCache() {
        return this.cache;
    }

    public CheckerConfigModel setCache(String cache) {
        this.cache = cache;
        return this;
    }

    public boolean isIncrement() {
        return this.increment;
    }

    public CheckerConfigModel setIncrement(boolean increment) {
        this.increment = increment;
        return this;
    }

    public boolean isHasInsideGroup() {
        return this.hasInsideGroup;
    }

    public CheckerConfigModel setHasInsideGroup(boolean hasInsideGroup) {
        this.hasInsideGroup = hasInsideGroup;
        return this;
    }

    public CheckerConfigModel setId(String id) {
        this.id = id;
        return this;
    }
}

