/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.support;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.sagacity.sqltoy.SqlToyConstants;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.callback.DataSourceCallbackHandler;
import org.sagacity.sqltoy.callback.StreamResultHandler;
import org.sagacity.sqltoy.callback.UpdateRowHandler;
import org.sagacity.sqltoy.config.SqlConfigParseUtils;
import org.sagacity.sqltoy.config.model.DataType;
import org.sagacity.sqltoy.config.model.DataVersionConfig;
import org.sagacity.sqltoy.config.model.EntityMeta;
import org.sagacity.sqltoy.config.model.FieldMeta;
import org.sagacity.sqltoy.config.model.ShardingStrategyConfig;
import org.sagacity.sqltoy.config.model.SqlToyConfig;
import org.sagacity.sqltoy.config.model.SqlType;
import org.sagacity.sqltoy.config.model.Translate;
import org.sagacity.sqltoy.dialect.DialectFactory;
import org.sagacity.sqltoy.dialect.executor.ParallQueryExecutor;
import org.sagacity.sqltoy.dialect.utils.DialectUtils;
import org.sagacity.sqltoy.exception.DataAccessException;
import org.sagacity.sqltoy.integration.DistributeIdGenerator;
import org.sagacity.sqltoy.link.Batch;
import org.sagacity.sqltoy.link.Delete;
import org.sagacity.sqltoy.link.Elastic;
import org.sagacity.sqltoy.link.Execute;
import org.sagacity.sqltoy.link.Load;
import org.sagacity.sqltoy.link.Mongo;
import org.sagacity.sqltoy.link.Query;
import org.sagacity.sqltoy.link.Save;
import org.sagacity.sqltoy.link.Store;
import org.sagacity.sqltoy.link.TreeTable;
import org.sagacity.sqltoy.link.Unique;
import org.sagacity.sqltoy.link.Update;
import org.sagacity.sqltoy.model.CacheMatchFilter;
import org.sagacity.sqltoy.model.ColumnMeta;
import org.sagacity.sqltoy.model.EntityQuery;
import org.sagacity.sqltoy.model.EntityUpdate;
import org.sagacity.sqltoy.model.IgnoreCaseLinkedMap;
import org.sagacity.sqltoy.model.IgnoreKeyCaseMap;
import org.sagacity.sqltoy.model.LockMode;
import org.sagacity.sqltoy.model.MapKit;
import org.sagacity.sqltoy.model.Page;
import org.sagacity.sqltoy.model.ParallQuery;
import org.sagacity.sqltoy.model.ParallQueryResult;
import org.sagacity.sqltoy.model.ParallelConfig;
import org.sagacity.sqltoy.model.QueryExecutor;
import org.sagacity.sqltoy.model.QueryResult;
import org.sagacity.sqltoy.model.SaveMode;
import org.sagacity.sqltoy.model.StoreResult;
import org.sagacity.sqltoy.model.TableMeta;
import org.sagacity.sqltoy.model.TreeTableModel;
import org.sagacity.sqltoy.model.UniqueExecutor;
import org.sagacity.sqltoy.model.inner.CacheMatchExtend;
import org.sagacity.sqltoy.model.inner.EntityQueryExtend;
import org.sagacity.sqltoy.model.inner.EntityUpdateExtend;
import org.sagacity.sqltoy.model.inner.QueryExecutorExtend;
import org.sagacity.sqltoy.model.inner.TranslateExtend;
import org.sagacity.sqltoy.plugins.CrossDbAdapter;
import org.sagacity.sqltoy.plugins.IUnifyFieldsHandler;
import org.sagacity.sqltoy.plugins.UnifyUpdateFieldsController;
import org.sagacity.sqltoy.plugins.datasource.DataSourceSelector;
import org.sagacity.sqltoy.plugins.id.IdGenerator;
import org.sagacity.sqltoy.translate.TranslateHandler;
import org.sagacity.sqltoy.translate.model.TranslateConfigModel;
import org.sagacity.sqltoy.utils.BeanUtil;
import org.sagacity.sqltoy.utils.BeanWrapper;
import org.sagacity.sqltoy.utils.DataSourceUtils;
import org.sagacity.sqltoy.utils.DateUtil;
import org.sagacity.sqltoy.utils.MapperUtils;
import org.sagacity.sqltoy.utils.ReservedWordsUtil;
import org.sagacity.sqltoy.utils.SqlUtil;
import org.sagacity.sqltoy.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlToyDaoSupport {
    protected final Logger logger = LoggerFactory.getLogger(SqlToyDaoSupport.class);
    protected DataSource dataSource;
    protected SaveMode UPDATE = SaveMode.UPDATE;
    protected SaveMode IGNORE = SaveMode.IGNORE;
    protected SqlToyContext sqlToyContext;
    private DistributeIdGenerator distributeIdGenerator = null;
    private DialectFactory dialectFactory = DialectFactory.getInstance();

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    protected DataSource getDataSource(DataSource pointDataSource) {
        return this.getDataSource(pointDataSource, null);
    }

    private DataSource getDataSource(DataSource pointDataSource, SqlToyConfig sqltoyConfig) {
        String sqlDataSource = null == sqltoyConfig ? null : sqltoyConfig.getDataSource();
        DataSourceSelector dataSourceSelector = this.sqlToyContext.getDataSourceSelector();
        return dataSourceSelector.getDataSource(this.sqlToyContext.getAppContext(), pointDataSource, sqlDataSource, this.dataSource, this.sqlToyContext.getDefaultDataSource());
    }

    protected Load load() {
        return new Load(this.sqlToyContext, this.getDataSource(this.dataSource));
    }

    protected Delete delete() {
        return new Delete(this.sqlToyContext, this.getDataSource(this.dataSource));
    }

    protected Update update() {
        return new Update(this.sqlToyContext, this.getDataSource(this.dataSource));
    }

    protected Save save() {
        return new Save(this.sqlToyContext, this.getDataSource(this.dataSource));
    }

    protected Query query() {
        return new Query(this.sqlToyContext, this.getDataSource(this.dataSource));
    }

    protected Store store() {
        return new Store(this.sqlToyContext, this.getDataSource(this.dataSource));
    }

    protected Unique unique() {
        return new Unique(this.sqlToyContext, this.getDataSource(this.dataSource));
    }

    protected TreeTable treeTable() {
        return new TreeTable(this.sqlToyContext, this.getDataSource(this.dataSource));
    }

    protected Execute execute() {
        return new Execute(this.sqlToyContext, this.getDataSource(this.dataSource));
    }

    protected Batch batch() {
        return new Batch(this.sqlToyContext, this.getDataSource(this.dataSource));
    }

    protected Elastic elastic() {
        return new Elastic(this.sqlToyContext, this.getDataSource(this.dataSource));
    }

    protected Mongo mongo() {
        return new Mongo(this.sqlToyContext, this.getDataSource(this.dataSource));
    }

    public void setSqlToyContext(SqlToyContext sqlToyContext) {
        this.sqlToyContext = sqlToyContext;
    }

    protected SqlToyContext getSqlToyContext() {
        return this.sqlToyContext;
    }

    protected SqlToyConfig getSqlToyConfig(String sqlKey, SqlType sqlType) {
        return this.sqlToyContext.getSqlToyConfig(sqlKey, sqlType == null ? SqlType.search : sqlType, this.getDialect(null));
    }

    protected boolean isUnique(Serializable entity, String ... paramsNamed) {
        return this.isUnique(new UniqueExecutor(entity, paramsNamed));
    }

    protected boolean isUnique(UniqueExecutor uniqueExecutor) {
        return this.dialectFactory.isUnique(this.sqlToyContext, uniqueExecutor, this.getDataSource(uniqueExecutor.getDataSource()));
    }

    protected Long getCountBySql(String sqlOrNamedSql, Map<String, Object> paramsMap) {
        return this.getCountByQuery(new QueryExecutor(sqlOrNamedSql, paramsMap == null ? MapKit.map() : paramsMap));
    }

    protected Long getCountBySql(String sqlOrNamedSql, String[] paramsNamed, Object[] paramsValue) {
        return this.getCountByQuery(new QueryExecutor(sqlOrNamedSql, paramsNamed, paramsValue));
    }

    protected Long getCountByEntityQuery(Class entityClass, EntityQuery entityQuery) {
        if (null == entityClass) {
            throw new IllegalArgumentException("getCountByEntityQuery entityClass\u503c\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        return (Long)this.findEntityBase(entityClass, null, entityQuery == null ? EntityQuery.create() : entityQuery, entityClass, true);
    }

    protected Long getCountByQuery(QueryExecutor queryExecutor) {
        QueryExecutorExtend extend = queryExecutor.getInnerModel();
        SqlToyConfig sqlToyConfig = this.sqlToyContext.getSqlToyConfig(extend.sql, SqlType.search, this.getDialect(extend.dataSource));
        Long result = this.dialectFactory.getCountBySql(this.sqlToyContext, queryExecutor, sqlToyConfig, this.getDataSource(extend.dataSource, sqlToyConfig));
        CrossDbAdapter.redoCountQuery(this.sqlToyContext, this.dialectFactory, queryExecutor);
        return result;
    }

    protected StoreResult executeStore(String storeSqlOrKey, Object[] inParamValues, Integer[] outParamsType, Class resultType) {
        return this.executeStore(storeSqlOrKey, inParamValues, outParamsType, resultType, null);
    }

    protected StoreResult executeStore(String storeSqlOrKey, Object[] inParamValues) {
        return this.executeStore(storeSqlOrKey, inParamValues, null, null, null);
    }

    protected StoreResult executeStore(String storeSqlOrKey, Object[] inParamsValue, Integer[] outParamsType, Class resultType, DataSource dataSource) {
        SqlToyConfig sqlToyConfig = this.getSqlToyConfig(storeSqlOrKey, SqlType.search);
        return this.dialectFactory.executeStore(this.sqlToyContext, sqlToyConfig, inParamsValue, outParamsType, resultType, this.getDataSource(dataSource, sqlToyConfig));
    }

    @Deprecated
    protected Object getSingleValue(String sqlOrNamedSql, String[] paramsNamed, Object[] paramsValue) {
        return this.getSingleValue(sqlOrNamedSql, paramsNamed, paramsValue, null);
    }

    protected Object getSingleValue(String sqlOrNamedSql, Map<String, Object> paramsMap) {
        Object queryResult = this.loadByQuery(new QueryExecutor(sqlOrNamedSql, paramsMap == null ? MapKit.map() : paramsMap));
        if (null != queryResult) {
            return ((List)queryResult).get(0);
        }
        return null;
    }

    protected <T> T getSingleValue(String sqlOrNamedSql, Map<String, Object> paramsMap, Class<T> resultType) {
        if (resultType == null) {
            throw new IllegalArgumentException("getSingleValue resultType \u4e0d\u80fd\u4e3anull!");
        }
        Object value = this.getSingleValue(sqlOrNamedSql, paramsMap);
        if (value == null) {
            return null;
        }
        try {
            return (T)BeanUtil.convertType(value, DataType.getType(resultType.getTypeName()), resultType.getTypeName());
        }
        catch (Exception e) {
            throw new DataAccessException("getSingleValue\u65b9\u6cd5\u83b7\u53d6\u5355\u4e2a\u503c\u5931\u8d25:" + e.getMessage(), e);
        }
    }

    protected Object getSingleValue(String sqlOrNamedSql, String[] paramsNamed, Object[] paramsValue, DataSource dataSource) {
        Object queryResult = this.loadByQuery(new QueryExecutor(sqlOrNamedSql, paramsNamed, paramsValue).dataSource(dataSource));
        if (null != queryResult) {
            return ((List)queryResult).get(0);
        }
        return null;
    }

    protected <T extends Serializable> T load(T entity) {
        if (entity == null) {
            return null;
        }
        EntityMeta entityMeta = this.getEntityMeta(entity.getClass());
        if (SqlConfigParseUtils.isNamedQuery(entityMeta.getLoadSql(null))) {
            return this.loadBySql(entityMeta.getLoadSql(null), entity);
        }
        return this.load(entity, null, null);
    }

    protected <T extends Serializable> T load(T entity, LockMode lockMode) {
        return this.load(entity, lockMode, null);
    }

    protected <T extends Serializable> T load(T entity, LockMode lockMode, DataSource dataSource) {
        return this.dialectFactory.load(this.sqlToyContext, entity, null, lockMode, this.getDataSource(dataSource));
    }

    protected <T extends Serializable> T loadCascade(T entity, LockMode lockMode, Class ... cascadeTypes) {
        if (entity == null) {
            return null;
        }
        Class[] cascades = cascadeTypes;
        if (cascades == null || cascades.length == 0) {
            cascades = this.getEntityMeta(entity.getClass()).getCascadeTypes();
        }
        return this.dialectFactory.load(this.sqlToyContext, entity, cascades, lockMode, this.getDataSource(null));
    }

    protected <T extends Serializable> List<T> loadAll(List<T> entities, LockMode lockMode) {
        return this.dialectFactory.loadAll(this.sqlToyContext, entities, null, lockMode, this.getDataSource(null));
    }

    protected <T extends Serializable> List<T> loadByIds(Class<T> voClass, Object ... ids) {
        return this.loadByIds(voClass, null, ids);
    }

    protected <T extends Serializable> List<T> loadByIds(Class<T> voClass, LockMode lockMode, Object ... ids) {
        if (voClass == null || ids == null || ids.length == 0 || ids.length == 1 && ids[0] == null) {
            throw new IllegalArgumentException("voClass\u3001ids must not null!");
        }
        EntityMeta entityMeta = this.getEntityMeta(voClass);
        if (entityMeta == null || entityMeta.getIdArray() == null || entityMeta.getIdArray().length != 1) {
            throw new IllegalArgumentException("voClass must is entity with @SqlToyEntity and must has primary key!");
        }
        Object[] realIds = ids.length == 1 && ids[0] instanceof Collection ? ((Collection)ids[0]).toArray() : ids;
        List<T> entities = BeanUtil.wrapEntities(this.sqlToyContext.getTypeHandler(), entityMeta, voClass, realIds);
        return this.dialectFactory.loadAll(this.sqlToyContext, entities, null, lockMode, this.getDataSource(null));
    }

    protected <T extends Serializable> List<T> loadAllCascade(List<T> entities, LockMode lockMode, Class ... cascadeTypes) {
        if (entities == null || entities.isEmpty()) {
            return entities;
        }
        Class[] cascades = cascadeTypes;
        if (cascades == null || cascades.length == 0) {
            cascades = this.getEntityMeta(((Serializable)entities.get(0)).getClass()).getCascadeTypes();
        }
        return this.dialectFactory.loadAll(this.sqlToyContext, entities, cascades, lockMode, this.getDataSource(null));
    }

    protected <T> T loadBySql(String sqlOrNamedSql, Map<String, Object> paramsMap, Class<T> resultType) {
        return (T)this.loadByQuery(new QueryExecutor(sqlOrNamedSql, paramsMap == null ? MapKit.map() : paramsMap).resultType(resultType));
    }

    protected <T> T loadBySql(String sqlOrNamedSql, String[] paramNames, Object[] paramValues, Class<T> resultType) {
        return (T)this.loadByQuery(new QueryExecutor(sqlOrNamedSql, paramNames, paramValues).resultType(resultType));
    }

    protected <T extends Serializable> T loadBySql(String sqlOrNamedSql, T entity) {
        return (T)((Serializable)this.loadByQuery(new QueryExecutor(sqlOrNamedSql, entity)));
    }

    protected <T extends Serializable> T loadEntity(Class<T> entityClass, EntityQuery entityQuery) {
        List<T> result = this.findEntity(entityClass, entityQuery);
        if (result == null || result.isEmpty()) {
            return null;
        }
        if (result.size() == 1) {
            return (T)((Serializable)result.get(0));
        }
        throw new IllegalArgumentException("loadEntity\u67e5\u8be2\u51fa:" + result.size() + " \u6761\u8bb0\u5f55,\u4e0d\u7b26\u5408load\u67e5\u8be2\u9884\u671f!");
    }

    protected Object loadByQuery(QueryExecutor queryExecutor) {
        QueryExecutorExtend extend = queryExecutor.getInnerModel();
        SqlToyConfig sqlToyConfig = this.sqlToyContext.getSqlToyConfig(queryExecutor, SqlType.search, this.getDialect(extend.dataSource));
        QueryResult result = this.dialectFactory.findByQuery(this.sqlToyContext, queryExecutor, sqlToyConfig, null, this.getDataSource(extend.dataSource, sqlToyConfig));
        CrossDbAdapter.redoQuery(this.sqlToyContext, this.dialectFactory, queryExecutor);
        List rows = result.getRows();
        if (rows == null || rows.isEmpty()) {
            return null;
        }
        if (rows.size() == 1) {
            return rows.get(0);
        }
        throw new IllegalArgumentException("loadByQuery\u67e5\u8be2\u51fa:" + rows.size() + " \u6761\u8bb0\u5f55,\u4e0d\u7b26\u5408load\u67e5\u8be2\u9884\u671f!");
    }

    protected Long executeSql(String sqlOrNamedSql) {
        return this.executeSql(sqlOrNamedSql, null, null, null, null);
    }

    protected Long executeSql(String sqlOrNamedSql, Serializable entity) {
        SqlToyConfig sqlToyConfig = this.getSqlToyConfig(sqlOrNamedSql, SqlType.update);
        return this.dialectFactory.executeSql(this.sqlToyContext, sqlToyConfig, new QueryExecutor(sqlOrNamedSql, entity), null, null, this.getDataSource(null, sqlToyConfig));
    }

    protected Long executeSql(String sqlOrNamedSql, Map<String, Object> paramsMap) {
        return this.executeSql(sqlOrNamedSql, new IgnoreKeyCaseMap<String, Object>(paramsMap));
    }

    protected Long executeSql(String sqlOrNamedSql, String[] paramsNamed, Object[] paramsValue) {
        return this.executeSql(sqlOrNamedSql, paramsNamed, paramsValue, null, null);
    }

    protected Long executeSql(String sqlOrNamedSql, String[] paramsNamed, Object[] paramsValue, Boolean autoCommit, DataSource dataSource) {
        SqlToyConfig sqlToyConfig = this.sqlToyContext.getSqlToyConfig(sqlOrNamedSql, SqlType.update, this.getDialect(dataSource));
        return this.dialectFactory.executeSql(this.sqlToyContext, sqlToyConfig, new QueryExecutor(sqlOrNamedSql).names(paramsNamed).values(paramsValue), null, autoCommit, this.getDataSource(dataSource, sqlToyConfig));
    }

    protected Long batchUpdate(String sqlOrNamedSql, List dataSet, Boolean autoCommit) {
        return this.batchUpdate(sqlOrNamedSql, dataSet, this.sqlToyContext.getBatchSize(), autoCommit, null);
    }

    protected Long batchUpdate(String sqlOrNamedSql, List dataSet, int batchSize, Boolean autoCommit) {
        return this.batchUpdate(sqlOrNamedSql, dataSet, batchSize, autoCommit, null);
    }

    protected Long batchUpdate(String sqlOrNamedSql, List dataSet, int batchSize, Boolean autoCommit, DataSource dataSource) {
        SqlToyConfig sqlToyConfig = this.sqlToyContext.getSqlToyConfig(sqlOrNamedSql, SqlType.update, this.getDialect(dataSource));
        return this.dialectFactory.batchUpdate(this.sqlToyContext, sqlToyConfig, dataSet, batchSize, null, null, autoCommit, this.getDataSource(dataSource, sqlToyConfig));
    }

    protected boolean wrapTreeTableRoute(TreeTableModel treeModel) {
        return this.wrapTreeTableRoute(treeModel, null);
    }

    protected boolean wrapTreeTableRoute(TreeTableModel treeModel, DataSource dataSource) {
        return this.dialectFactory.wrapTreeTableRoute(this.sqlToyContext, treeModel, this.getDataSource(dataSource));
    }

    protected <T extends Serializable> List<T> findBySql(String sqlOrNamedSql, T entity) {
        return this.findByQuery(new QueryExecutor(sqlOrNamedSql, entity)).getRows();
    }

    protected <T> List<T> findBySql(String sqlOrNamedSql, Map<String, Object> paramsMap, Class<T> voClass) {
        return this.findByQuery(new QueryExecutor(sqlOrNamedSql, paramsMap == null ? MapKit.map() : paramsMap).resultType(voClass)).getRows();
    }

    protected <T> List<T> findBySql(String sqlOrNamedSql, String[] paramsNamed, Object[] paramsValue, Class<T> voClass) {
        QueryExecutor query = new QueryExecutor(sqlOrNamedSql, paramsNamed, paramsValue);
        if (voClass != null) {
            query.resultType(voClass);
        }
        return this.findByQuery(query).getRows();
    }

    protected QueryResult findByQuery(QueryExecutor queryExecutor) {
        SqlToyConfig sqlToyConfig = this.sqlToyContext.getSqlToyConfig(queryExecutor, SqlType.search, this.getDialect(queryExecutor.getInnerModel().dataSource));
        QueryResult result = this.dialectFactory.findByQuery(this.sqlToyContext, queryExecutor, sqlToyConfig, queryExecutor.getInnerModel().lockMode, this.getDataSource(queryExecutor.getInnerModel().dataSource, sqlToyConfig));
        CrossDbAdapter.redoQuery(this.sqlToyContext, this.dialectFactory, queryExecutor);
        return result;
    }

    protected void fetchStream(QueryExecutor queryExecutor, StreamResultHandler streamResultHandler) {
        SqlToyConfig sqlToyConfig = this.sqlToyContext.getSqlToyConfig(queryExecutor, SqlType.search, this.getDialect(queryExecutor.getInnerModel().dataSource));
        this.dialectFactory.fetchStream(this.sqlToyContext, queryExecutor, sqlToyConfig, streamResultHandler, this.getDataSource(queryExecutor.getInnerModel().dataSource, sqlToyConfig));
    }

    protected QueryResult findPageByQuery(Page page, QueryExecutor queryExecutor) {
        String dialect = this.getDialect(queryExecutor.getInnerModel().dataSource);
        SqlToyConfig sqlToyConfig = this.sqlToyContext.getSqlToyConfig(queryExecutor, SqlType.search, dialect);
        String countSql = queryExecutor.getInnerModel().countSql;
        if (StringUtil.isNotBlank(countSql)) {
            sqlToyConfig.setCountSql(countSql);
        }
        QueryResult result = page.getSkipQueryCount() != null && page.getSkipQueryCount() != false ? this.dialectFactory.findSkipTotalCountPage(this.sqlToyContext, queryExecutor, sqlToyConfig, page.getPageNo(), page.getPageSize(), this.getDataSource(queryExecutor.getInnerModel().dataSource, sqlToyConfig)) : this.dialectFactory.findPage(this.sqlToyContext, queryExecutor, sqlToyConfig, page.getPageNo(), page.getPageSize(), page.getOverPageToFirst(), this.getDataSource(queryExecutor.getInnerModel().dataSource, sqlToyConfig));
        CrossDbAdapter.redoPageQuery(this.sqlToyContext, this.dialectFactory, queryExecutor, page);
        return result;
    }

    protected <T> Page<T> findPageBySql(Page page, String sqlOrNamedSql, String[] paramsNamed, Object[] paramsValue, Class<T> voClass) {
        QueryExecutor query = new QueryExecutor(sqlOrNamedSql, paramsNamed, paramsValue);
        if (voClass != null) {
            query.resultType(voClass);
        }
        return this.findPageByQuery(page, query).getPageResult();
    }

    protected <T extends Serializable> Page<T> findPageBySql(Page page, String sqlOrNamedSql, T entity) {
        return this.findPageByQuery(page, new QueryExecutor(sqlOrNamedSql, entity)).getPageResult();
    }

    protected <T> Page<T> findPageBySql(Page page, String sqlOrNamedSql, Map<String, Object> paramsMap, Class<T> voClass) {
        return this.findPageByQuery(page, new QueryExecutor(sqlOrNamedSql, paramsMap).resultType(voClass)).getPageResult();
    }

    protected <T> List<T> findTopBySql(String sqlOrNamedSql, Map<String, Object> paramsMap, Class<T> voClass, double topSize) {
        return this.findTopByQuery(new QueryExecutor(sqlOrNamedSql, paramsMap == null ? MapKit.map() : paramsMap).resultType(voClass), topSize).getRows();
    }

    protected <T> List<T> findTopBySql(String sqlOrNamedSql, String[] paramsNamed, Object[] paramsValue, Class<T> voClass, double topSize) {
        return this.findTopByQuery(new QueryExecutor(sqlOrNamedSql, paramsNamed, paramsValue).resultType(voClass), topSize).getRows();
    }

    protected <T extends Serializable> List<T> findTopBySql(String sqlOrNamedSql, T entity, double topSize) {
        return this.findTopByQuery(new QueryExecutor(sqlOrNamedSql, entity), topSize).getRows();
    }

    protected QueryResult findTopByQuery(QueryExecutor queryExecutor, double topSize) {
        SqlToyConfig sqlToyConfig = this.sqlToyContext.getSqlToyConfig(queryExecutor, SqlType.search, this.getDialect(queryExecutor.getInnerModel().dataSource));
        QueryResult result = this.dialectFactory.findTop(this.sqlToyContext, queryExecutor, sqlToyConfig, topSize, this.getDataSource(queryExecutor.getInnerModel().dataSource, sqlToyConfig));
        CrossDbAdapter.redoTopQuery(this.sqlToyContext, this.dialectFactory, queryExecutor, topSize);
        return result;
    }

    protected QueryResult getRandomResult(QueryExecutor queryExecutor, double randomCount) {
        SqlToyConfig sqlToyConfig = this.sqlToyContext.getSqlToyConfig(queryExecutor, SqlType.search, this.getDialect(queryExecutor.getInnerModel().dataSource));
        QueryResult result = this.dialectFactory.getRandomResult(this.sqlToyContext, queryExecutor, sqlToyConfig, randomCount, this.getDataSource(queryExecutor.getInnerModel().dataSource, sqlToyConfig));
        CrossDbAdapter.redoRandomQuery(this.sqlToyContext, this.dialectFactory, queryExecutor, randomCount);
        return result;
    }

    protected <T> List<T> getRandomResult(String sqlOrNamedSql, Map<String, Object> paramsMap, Class<T> voClass, double randomCount) {
        return this.getRandomResult(new QueryExecutor(sqlOrNamedSql, paramsMap == null ? MapKit.map() : paramsMap).resultType(voClass), randomCount).getRows();
    }

    protected <T> List<T> getRandomResult(String sqlOrNamedSql, String[] paramsNamed, Object[] paramsValue, Class<T> voClass, double randomCount) {
        return this.getRandomResult(new QueryExecutor(sqlOrNamedSql, paramsNamed, paramsValue).resultType(voClass), randomCount).getRows();
    }

    protected void truncate(Class entityClass, Boolean autoCommit) {
        if (null == entityClass) {
            throw new IllegalArgumentException("entityClass is null!Please enter the correct!");
        }
        this.truncate(this.sqlToyContext.getEntityMeta(entityClass).getTableName(), autoCommit, null);
    }

    protected void truncate(String tableName, Boolean autoCommit, DataSource dataSource) {
        this.executeSql("truncate table ".concat(tableName), null, null, autoCommit, this.getDataSource(dataSource));
    }

    protected Object save(Serializable entity) {
        return this.save(entity, null);
    }

    protected Object save(Serializable entity, DataSource dataSource) {
        return this.dialectFactory.save(this.sqlToyContext, entity, this.getDataSource(dataSource));
    }

    protected <T extends Serializable> Long saveAll(List<T> entities) {
        return this.saveAll(entities, null);
    }

    protected <T extends Serializable> Long saveAll(List<T> entities, DataSource dataSource) {
        return this.dialectFactory.saveAll(this.sqlToyContext, entities, this.sqlToyContext.getBatchSize(), null, this.getDataSource(dataSource), null);
    }

    protected <T extends Serializable> Long saveAllIgnoreExist(List<T> entities) {
        return this.saveAllIgnoreExist(entities, null);
    }

    protected <T extends Serializable> Long saveAllIgnoreExist(List<T> entities, DataSource dataSource) {
        return this.dialectFactory.saveAllIgnoreExist(this.sqlToyContext, entities, this.sqlToyContext.getBatchSize(), null, this.getDataSource(dataSource), null);
    }

    protected Long update(Serializable entity, String ... forceUpdateProps) {
        return this.update(entity, forceUpdateProps, (DataSource)null);
    }

    protected Long update(Serializable entity, String[] forceUpdateProps, DataSource dataSource) {
        if (entity == null) {
            this.logger.warn("update entity is null,please check!");
            return 0L;
        }
        EntityMeta entityMeta = this.getEntityMeta(entity.getClass());
        DataVersionConfig dataVersion = entityMeta.getDataVersion();
        if (dataVersion != null) {
            String nowDate;
            Object version = BeanUtil.getProperty(entity, dataVersion.getField());
            if (version == null) {
                throw new IllegalArgumentException("\u8868:" + entityMeta.getTableName() + " \u5b58\u5728\u7248\u672c@DataVersion\u914d\u7f6e\uff0c\u5c5e\u6027:" + dataVersion.getField() + " \u503c\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            String where = "";
            for (String field : entityMeta.getIdArray()) {
                where = where.concat(field).concat("=:").concat(field).concat(" and ");
            }
            where = where.concat(dataVersion.getField()).concat("=:").concat(dataVersion.getField());
            Object versionEntity = this.loadEntity(entity.getClass(), EntityQuery.create().select(entityMeta.getIdArray()).where(where).values(entity).lock(LockMode.UPGRADE_NOWAIT));
            Object verStr = version.toString();
            if (versionEntity == null) {
                throw new DataAccessException("\u8868:" + entityMeta.getTableName() + " \u6570\u636e\u7248\u672c:" + (String)verStr + " \u6b63\u5728\u88ab\u5176\u4ed6\u7528\u6237\u4fee\u6539\u6216\u5df2\u7ecf\u88ab\u66f4\u65b0!");
            }
            verStr = dataVersion.isStartDate() ? (((String)verStr).startsWith(nowDate = DateUtil.formatDate(DateUtil.getNowTime(), "yyyyMMdd")) ? nowDate + (Integer.parseInt(((String)verStr).substring(8)) + 1) : nowDate + "1") : "" + (Integer.parseInt((String)verStr) + 1);
            BeanUtil.setProperty(entity, dataVersion.getField(), verStr);
        }
        return this.dialectFactory.update(this.sqlToyContext, entity, forceUpdateProps, false, null, null, this.getDataSource(dataSource));
    }

    protected Long updateCascade(Serializable entity, String[] forceUpdateProps, Class[] forceCascadeClasses, HashMap<Class, String[]> subTableForceUpdateProps) {
        return this.dialectFactory.update(this.sqlToyContext, entity, forceUpdateProps, true, forceCascadeClasses, subTableForceUpdateProps, this.getDataSource(null));
    }

    public <T extends Serializable> T updateSaveFetch(T entity, UpdateRowHandler updateRowHandler, String[] uniqueProps, DataSource dataSource) {
        return (T)this.dialectFactory.updateSaveFetch(this.sqlToyContext, entity, updateRowHandler, uniqueProps, this.getDataSource(dataSource));
    }

    protected Long updateDeeply(Serializable entity) {
        return this.updateDeeply(entity, null);
    }

    protected Long updateDeeply(Serializable entity, DataSource dataSource) {
        return this.update(entity, this.sqlToyContext.getEntityMeta(entity.getClass()).getRejectIdFieldArray(), this.getDataSource(dataSource));
    }

    protected <T extends Serializable> Long updateAll(List<T> entities, String ... forceUpdateProps) {
        return this.updateAll(entities, forceUpdateProps, (DataSource)null);
    }

    protected <T extends Serializable> Long updateAll(List<T> entities, String[] forceUpdateProps, DataSource dataSource) {
        return this.dialectFactory.updateAll(this.sqlToyContext, entities, this.sqlToyContext.getBatchSize(), null, forceUpdateProps, null, this.getDataSource(dataSource), null);
    }

    protected <T extends Serializable> Long updateAllDeeply(List<T> entities) {
        return this.updateAllDeeply(entities, null);
    }

    protected <T extends Serializable> Long updateAllDeeply(List<T> entities, DataSource dataSource) {
        if (entities == null || entities.isEmpty()) {
            return 0L;
        }
        return this.updateAll(entities, this.getEntityMeta(((Serializable)entities.get(0)).getClass()).getRejectIdFieldArray(), (DataSource)null);
    }

    protected Long saveOrUpdate(Serializable entity, String ... forceUpdateProps) {
        return this.saveOrUpdate(entity, forceUpdateProps, (DataSource)null);
    }

    protected Long saveOrUpdate(Serializable entity, String[] forceUpdateProps, DataSource dataSource) {
        if (entity == null) {
            this.logger.warn("saveOrUpdate: entity is null,please check!");
            return 0L;
        }
        EntityMeta entityMeta = this.getEntityMeta(entity.getClass());
        if (entityMeta.getDataVersion() != null) {
            String[] props = new String[entityMeta.getIdArray().length + 1];
            System.arraycopy(entityMeta.getIdArray(), 0, props, 0, entityMeta.getIdArray().length);
            props[props.length - 1] = entityMeta.getDataVersion().getField();
            Object[] values = BeanUtil.reflectBeanToAry(entity, props);
            boolean isUpdate = true;
            for (int i = 0; i < props.length; ++i) {
                if (values[i] != null) continue;
                isUpdate = false;
                break;
            }
            if (isUpdate && !values[props.length - 1].toString().equals("0")) {
                return this.update(entity, forceUpdateProps, dataSource);
            }
        }
        return this.dialectFactory.saveOrUpdate(this.sqlToyContext, entity, forceUpdateProps, this.getDataSource(dataSource));
    }

    protected <T extends Serializable> Long saveOrUpdateAll(List<T> entities, String ... forceUpdateProps) {
        return this.saveOrUpdateAll(entities, forceUpdateProps, (DataSource)null);
    }

    protected <T extends Serializable> Long saveOrUpdateAll(List<T> entities, String[] forceUpdateProps, DataSource dataSource) {
        return this.dialectFactory.saveOrUpdateAll(this.sqlToyContext, entities, this.sqlToyContext.getBatchSize(), forceUpdateProps, null, this.getDataSource(dataSource), null);
    }

    protected Long delete(Serializable entity) {
        return this.dialectFactory.delete(this.sqlToyContext, entity, this.getDataSource(null));
    }

    protected Long delete(Serializable entity, DataSource dataSource) {
        return this.dialectFactory.delete(this.sqlToyContext, entity, this.getDataSource(dataSource));
    }

    protected Long deleteByQuery(Class entityClass, EntityQuery entityQuery) {
        EntityQueryExtend innerModel = entityQuery.getInnerModel();
        if (null == entityClass || null == entityQuery || StringUtil.isBlank(innerModel.where) || StringUtil.isBlank(innerModel.values)) {
            throw new IllegalArgumentException("deleteByQuery entityClass\u3001where\u3001value \u503c\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (!innerModel.paramFilters.isEmpty()) {
            this.logger.warn("\u5220\u9664\u64cd\u4f5c\u8bbe\u7f6e\u52a8\u6001\u6761\u4ef6\u8fc7\u6ee4\u662f\u65e0\u6548\u7684,\u6570\u636e\u5220\u9664\u67e5\u8be2\u6761\u4ef6\u5fc5\u987b\u662f\u7cbe\u51c6\u7684!");
        }
        EntityMeta entityMeta = this.getEntityMeta(entityClass);
        String where = SqlUtil.convertFieldsToColumns(entityMeta, innerModel.where);
        String sql = "delete from ".concat(entityMeta.getSchemaTable(null, null)).concat(" where ").concat(where);
        QueryExecutor queryExecutor = null;
        queryExecutor = SqlConfigParseUtils.hasNamedParam(where) && StringUtil.isBlank(innerModel.names) ? new QueryExecutor(sql, (Serializable)innerModel.values[0]) : new QueryExecutor(sql).names(innerModel.names).values(innerModel.values);
        queryExecutor.getInnerModel().blankToNull = innerModel.blankToNull;
        if (innerModel.paramFilters != null && innerModel.paramFilters.size() > 0) {
            queryExecutor.getInnerModel().paramFilters.addAll(innerModel.paramFilters);
        }
        this.setEntitySharding(queryExecutor, entityMeta);
        queryExecutor.getInnerModel().entityClass = entityClass;
        SqlToyConfig sqlToyConfig = this.sqlToyContext.getSqlToyConfig(queryExecutor, SqlType.delete, this.getDialect(innerModel.dataSource));
        return this.dialectFactory.executeSql(this.sqlToyContext, sqlToyConfig, queryExecutor, null, null, this.getDataSource(innerModel.dataSource));
    }

    protected <T extends Serializable> Long deleteAll(List<T> entities) {
        return this.deleteAll(entities, null);
    }

    protected <T extends Serializable> Long deleteAll(List<T> entities, DataSource dataSource) {
        return this.dialectFactory.deleteAll(this.sqlToyContext, entities, this.sqlToyContext.getBatchSize(), this.getDataSource(dataSource), null);
    }

    protected Long deleteByIds(Class entityClass, Object ... ids) {
        if (!this.sqlToyContext.isEntity(entityClass) || ids == null || ids.length == 0 || ids.length == 1 && ids[0] == null) {
            throw new IllegalArgumentException("deleteByIds entityClass\u5fc5\u987b\u662f\u5b9e\u4f53bean\u3001\u4e3b\u952e\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        EntityMeta entityMeta = this.sqlToyContext.getEntityMeta(entityClass);
        if (entityMeta.getIdArray() == null || entityMeta.getIdArray().length != 1) {
            throw new IllegalArgumentException("deleteByIds\u5b9e\u4f53bean\u5bf9\u5e94\u8868\u6709\u4e14\u53ea\u80fd\u6709\u4e00\u4e2a\u4e3b\u952e!");
        }
        Object[] realIds = ids.length == 1 && ids[0] instanceof Collection ? ((Collection)ids[0]).toArray() : ids;
        List entities = BeanUtil.wrapEntities(this.sqlToyContext.getTypeHandler(), entityMeta, entityClass, realIds);
        return this.deleteAll(entities, null);
    }

    protected List updateFetch(QueryExecutor queryExecutor, UpdateRowHandler updateRowHandler) {
        SqlToyConfig sqlToyConfig = this.sqlToyContext.getSqlToyConfig(queryExecutor.getInnerModel().sql, SqlType.search, this.getDialect(queryExecutor.getInnerModel().dataSource));
        return this.dialectFactory.updateFetch(this.sqlToyContext, queryExecutor, sqlToyConfig, updateRowHandler, this.getDataSource(queryExecutor.getInnerModel().dataSource, sqlToyConfig)).getRows();
    }

    protected EntityMeta getEntityMeta(Class entityClass) {
        return this.sqlToyContext.getEntityMeta(entityClass);
    }

    protected int getBatchSize() {
        return this.sqlToyContext.getBatchSize();
    }

    protected BeanWrapper wrapBeanProps(String ... names) {
        return BeanWrapper.create().names(names);
    }

    protected void flush() {
        this.flush(null);
    }

    protected void flush(DataSource dataSource) {
        DataSourceUtils.processDataSource(this.sqlToyContext, this.getDataSource(dataSource), new DataSourceCallbackHandler(){

            @Override
            public void doConnection(Connection conn, Integer dbType, String dialect) throws Exception {
                if (!conn.isClosed()) {
                    conn.commit();
                }
            }
        });
    }

    protected long generateBizId(String signature, int increment) {
        if (StringUtil.isBlank(signature)) {
            throw new IllegalArgumentException("signature \u5fc5\u987b\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u6b63\u786e\u6307\u5b9a\u4e1a\u52a1\u6807\u5fd7\u7b26\u53f7!");
        }
        if (this.distributeIdGenerator == null) {
            try {
                this.distributeIdGenerator = (DistributeIdGenerator)Class.forName(this.sqlToyContext.getDistributeIdGeneratorClass()).newInstance();
                this.distributeIdGenerator.initialize(this.sqlToyContext.getAppContext());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new DataAccessException("\u5b9e\u4f8b\u5316\u5206\u5e03\u5f0fid\u4ea7\u751f\u5668\u5931\u8d25:" + e.getMessage());
            }
        }
        return this.distributeIdGenerator.generateId(signature, increment, null);
    }

    protected String generateBizId(Serializable entity) {
        EntityMeta entityMeta = this.getEntityMeta(entity.getClass());
        if (entityMeta == null || !entityMeta.isHasBizIdConfig()) {
            throw new IllegalArgumentException(StringUtil.fillArgs("\u5bf9\u8c61:{},\u6ca1\u6709\u914d\u7f6e\u4e1a\u52a1\u4e3b\u952e\u751f\u6210\u7b56\u7565,\u8bf7\u68c0\u67e5POJO \u7684\u4e1a\u52a1\u4e3b\u952e\u914d\u7f6e!", entity.getClass().getName()));
        }
        String businessIdType = entityMeta.getColumnJavaType(entityMeta.getBusinessIdField());
        Integer[] relatedColumn = entityMeta.getBizIdRelatedColIndex();
        Object[] fullParamValues = BeanUtil.reflectBeanToAry(entity, entityMeta.getFieldsArray());
        Object[] relatedColValue = null;
        if (relatedColumn != null) {
            relatedColValue = new Object[relatedColumn.length];
            for (int meter = 0; meter < relatedColumn.length; ++meter) {
                relatedColValue[meter] = fullParamValues[relatedColumn[meter]];
                if (relatedColValue[meter] != null) continue;
                throw new IllegalArgumentException("\u5bf9\u8c61:" + entity.getClass().getName() + " \u751f\u6210\u4e1a\u52a1\u4e3b\u952e\u4f9d\u8d56\u7684\u5173\u8054\u5b57\u6bb5:" + relatedColumn[meter] + " \u503c\u4e3anull!");
            }
        }
        IdGenerator idGenerator = entityMeta.getBusinessIdGenerator() == null ? entityMeta.getIdGenerator() : entityMeta.getBusinessIdGenerator();
        return idGenerator.getId(entityMeta.getTableName(), entityMeta.getBizIdSignature(), entityMeta.getBizIdRelatedColumns(), relatedColValue, new Date(), businessIdType, entityMeta.getBizIdLength(), entityMeta.getBizIdSequenceSize()).toString();
    }

    protected Set<String> getCacheNames() {
        return this.sqlToyContext.getTranslateManager().getCacheNames();
    }

    protected boolean existCache(String cacheName) {
        return this.sqlToyContext.getTranslateManager().existCache(cacheName);
    }

    protected <T> List<T> getTranslateCache(String cacheName, String cacheType, Class<T> reusltType) {
        TranslateConfigModel translateConfig = this.sqlToyContext.getTranslateManager().getCacheConfig(cacheName);
        if (null == translateConfig) {
            throw new DataAccessException("\u7f13\u5b58\u7ffb\u8bd1\u4e2d\u5bf9\u5e94\u7684\u7f13\u5b58:" + cacheName + " \u6ca1\u6709\u5b9a\u4e49,\u8bf7\u6b63\u786e\u68c0\u67e5\u914d\u7f6e!");
        }
        HashMap<String, Object[]> cacheData = this.sqlToyContext.getTranslateManager().getCacheData(cacheName, cacheType);
        if (cacheData.isEmpty()) {
            return new ArrayList();
        }
        if (null == reusltType || reusltType == Array.class) {
            return new ArrayList<Object[]>(cacheData.values());
        }
        String[] props = translateConfig.getProperties();
        if (props == null || props.length == 0) {
            throw new DataAccessException("\u7f13\u5b58\u7ffb\u8bd1\u4e2d\u7684\u7f13\u5b58:[" + cacheName + "]\u6ca1\u6709\u6b63\u786e\u5b9a\u4e49properties\u5c5e\u6027,\u65e0\u6cd5\u6620\u5c04\u5230VO/POJO/Map\u5bf9\u8c61!");
        }
        if (reusltType == Map.class || reusltType == HashMap.class || reusltType == LinkedHashMap.class || reusltType == IgnoreKeyCaseMap.class || reusltType == IgnoreCaseLinkedMap.class) {
            ArrayList<AbstractMap> result = new ArrayList<AbstractMap>();
            Iterator<Object[]> iter = cacheData.values().iterator();
            int mapType = 1;
            if (reusltType == LinkedHashMap.class) {
                mapType = 2;
            } else if (reusltType == IgnoreKeyCaseMap.class) {
                mapType = 3;
            } else if (reusltType == IgnoreCaseLinkedMap.class) {
                mapType = 4;
            }
            while (iter.hasNext()) {
                AbstractMap map = mapType == 2 ? new LinkedHashMap() : (mapType == 3 ? new IgnoreKeyCaseMap() : (mapType == 4 ? new IgnoreCaseLinkedMap() : new HashMap()));
                Object[] row = iter.next();
                for (int i = 0; i < props.length; ++i) {
                    map.put(props[i], row[i]);
                }
                result.add(map);
            }
            return result;
        }
        return BeanUtil.reflectListToBean(this.sqlToyContext.getTypeHandler(), cacheData.values(), props, reusltType);
    }

    protected HashMap<String, Object[]> getTranslateCache(String cacheName, String cacheType) {
        return this.sqlToyContext.getTranslateManager().getCacheData(cacheName, cacheType);
    }

    @Deprecated
    protected String[] cacheMatchKeys(String matchRegex, CacheMatchFilter cacheMatchFilter) {
        return this.cacheMatchKeys(cacheMatchFilter, matchRegex);
    }

    protected String[] cacheMatchKeys(CacheMatchFilter cacheMatchFilter, String ... matchRegexes) {
        if (cacheMatchFilter == null || StringUtil.isBlank(cacheMatchFilter.getCacheFilterArgs().cacheName) || matchRegexes == null || matchRegexes.length == 0) {
            throw new IllegalArgumentException("\u7f13\u5b58\u53cd\u5411\u540d\u79f0\u5339\u914dkey\u5fc5\u987b\u8981\u63d0\u4f9bcacheName\u548cmatchRegex\u503c!");
        }
        CacheMatchExtend extendArgs = cacheMatchFilter.getCacheFilterArgs();
        int[] nameIndexes = extendArgs.matchIndexs;
        HashMap<String, Object[]> cacheDatas = this.sqlToyContext.getTranslateManager().getCacheData(extendArgs.cacheName, extendArgs.cacheType);
        if (cacheDatas == null || cacheDatas.isEmpty()) {
            this.logger.error("\u7f13\u5b58cacheName={},cacheType={} \u6ca1\u6709\u6570\u636e,cacheMatchKeys\u5f02\u5e38,\u8bf7\u68c0\u67e5!", (Object)extendArgs.cacheName, (Object)extendArgs.cacheType);
            return new String[0];
        }
        ArrayList<String> matchLowAry = new ArrayList<String>();
        for (String str : matchRegexes) {
            matchLowAry.add(str.toLowerCase().trim());
        }
        int cacheKeyIndex = extendArgs.cacheKeyIndex;
        ArrayList<String> matchedKeys = new ArrayList<String>();
        int matchCnt = 0;
        boolean priorMatchEqual = extendArgs.priorMatchEqual;
        boolean hasFilter = extendArgs.cacheFilter != null;
        boolean include = true;
        for (Object[] row : cacheDatas.values()) {
            String keyCode = row[cacheKeyIndex].toString();
            include = true;
            if (hasFilter) {
                include = extendArgs.cacheFilter.doFilter(row);
            }
            if (!include) continue;
            block2: for (int i = 0; i < matchLowAry.size(); ++i) {
                Object compareValue;
                String matchStr = (String)matchLowAry.get(i);
                if (priorMatchEqual) {
                    if (matchStr.equals(keyCode.toLowerCase())) {
                        matchedKeys.add(keyCode);
                        matchLowAry.remove(i);
                        ++matchCnt;
                        break;
                    }
                    for (int index : nameIndexes) {
                        compareValue = row[index];
                        if (compareValue == null || !compareValue.toString().toLowerCase().equals(matchStr)) continue;
                        matchedKeys.add(keyCode);
                        matchLowAry.remove(i);
                        ++matchCnt;
                        break block2;
                    }
                }
                String[] matchWords = matchStr.split("\\s+");
                for (int index : nameIndexes) {
                    compareValue = row[index];
                    if (compareValue == null || !StringUtil.like(compareValue.toString().toLowerCase(), matchWords)) continue;
                    matchedKeys.add(keyCode);
                    ++matchCnt;
                    break block2;
                }
            }
            if (!matchLowAry.isEmpty() && matchCnt < extendArgs.matchSize) continue;
            break;
        }
        if (matchedKeys.isEmpty() && extendArgs.unMatchedReturnSelf) {
            return matchRegexes;
        }
        String[] result = new String[matchedKeys.size()];
        matchedKeys.toArray(result);
        return result;
    }

    protected void translate(Collection dataSet, String cacheName, String cacheType, Integer cacheNameIndex, TranslateHandler translateHandler) {
        int cacheIndex;
        if (dataSet == null || dataSet.isEmpty()) {
            return;
        }
        if (cacheName == null) {
            throw new IllegalArgumentException("\u7f13\u5b58\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (translateHandler == null) {
            throw new IllegalArgumentException("\u7f13\u5b58\u7ffb\u8bd1\u884c\u53d6key\u548c\u8bbe\u7f6ename\u7684\u53cd\u8c03\u51fd\u6570\u4e0d\u80fd\u4e3anull!");
        }
        HashMap<String, Object[]> cache = this.getTranslateCache(cacheName, cacheType);
        if (cache == null || cache.isEmpty()) {
            return;
        }
        Iterator iter = dataSet.iterator();
        int n = cacheIndex = cacheNameIndex == null ? 1 : cacheNameIndex;
        while (iter.hasNext()) {
            Object key;
            Object row = iter.next();
            if (row == null || (key = translateHandler.getKey(row)) == null) continue;
            Object[] keyRow = cache.get(key.toString());
            Object name = keyRow == null ? null : keyRow[cacheIndex];
            translateHandler.setName(row, name == null ? "" : name.toString());
        }
    }

    protected <T> List<T> findEntity(Class<T> entityClass, EntityQuery entityQuery) {
        return this.findEntity(entityClass, entityQuery, entityClass);
    }

    protected <T> List<T> findEntity(Class entityClass, EntityQuery entityQuery, Class<T> resultType) {
        if (null == entityClass) {
            throw new IllegalArgumentException("findEntityList entityClass\u503c\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        return (List)this.findEntityBase(entityClass, null, entityQuery == null ? EntityQuery.create() : entityQuery, resultType, false);
    }

    protected <T> Page<T> findPageEntity(Page page, Class<T> entityClass, EntityQuery entityQuery) {
        return this.findPageEntity(page, entityClass, entityQuery, entityClass);
    }

    protected <T> Page<T> findPageEntity(Page page, Class entityClass, EntityQuery entityQuery, Class<T> resultType) {
        if (null == entityClass || null == page) {
            throw new IllegalArgumentException("findPageEntity entityClass\u3001page\u503c\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        return (Page)this.findEntityBase(entityClass, page, entityQuery == null ? EntityQuery.create() : entityQuery, resultType, false);
    }

    private Object findEntityBase(Class entityClass, Page page, EntityQuery entityQuery, Class resultClass, boolean isCount) {
        Class resultType;
        EntityMeta entityMeta = this.getEntityMeta(entityClass);
        EntityQueryExtend innerModel = entityQuery.getInnerModel();
        String translateFields = "";
        if (!innerModel.translates.isEmpty()) {
            Iterator<Translate> iter = innerModel.translates.values().iterator();
            while (iter.hasNext()) {
                TranslateExtend extend = iter.next().getExtend();
                String keyColumn = entityMeta.getColumnName(extend.keyColumn);
                if (keyColumn == null) {
                    keyColumn = extend.keyColumn;
                }
                keyColumn = ReservedWordsUtil.convertWord(keyColumn, null);
                translateFields = translateFields.concat(",").concat(keyColumn).concat(" as ").concat(extend.column);
            }
        }
        String[] selectFieldAry = null;
        Set<String> notSelect = innerModel.notSelectFields;
        if (notSelect != null) {
            ArrayList<String> selectFields = new ArrayList<String>();
            for (String field : entityMeta.getFieldsArray()) {
                if (notSelect.contains(field.toLowerCase())) continue;
                selectFields.add(field);
            }
            if (selectFields.size() > 0) {
                selectFieldAry = new String[selectFields.size()];
                selectFields.toArray(selectFieldAry);
            }
        } else {
            selectFieldAry = innerModel.fields;
        }
        String fields = "";
        if (selectFieldAry != null && selectFieldAry.length > 0) {
            int index = 0;
            HashSet<String> cols = new HashSet<String>();
            boolean notAllPureField = false;
            for (String field : selectFieldAry) {
                if (cols.contains(field)) continue;
                String colName = entityMeta.getColumnName(field);
                if (colName == null) {
                    colName = field;
                    if (!entityMeta.getColumnFieldMap().containsKey(colName.toLowerCase())) {
                        notAllPureField = true;
                    } else {
                        colName = ReservedWordsUtil.convertWord(colName, null);
                    }
                } else {
                    colName = ReservedWordsUtil.convertWord(colName, null);
                }
                if (index > 0) {
                    fields = fields.concat(",");
                }
                fields = fields.concat(colName);
                ++index;
                cols.add(field);
            }
            if (notAllPureField) {
                fields = SqlUtil.convertFieldsToColumns(entityMeta, fields);
            }
        } else {
            fields = entityMeta.getAllColumnNames();
        }
        String sql = "select ".concat(innerModel.distinct ? " distinct " : "").concat(fields).concat(translateFields).concat(" from ").concat(entityMeta.getSchemaTable(null, null));
        String where = "";
        if (StringUtil.isBlank(innerModel.where)) {
            if (innerModel.values != null && innerModel.values.length > 0) {
                where = SqlUtil.wrapWhere(entityMeta);
            }
        } else {
            where = SqlUtil.convertFieldsToColumns(entityMeta, innerModel.where);
        }
        if (StringUtil.isNotBlank(where)) {
            sql = sql.concat(" where ").concat(where);
        }
        if (StringUtil.isNotBlank(innerModel.groupBy)) {
            sql = sql.concat(" group by ").concat(SqlUtil.convertFieldsToColumns(entityMeta, innerModel.groupBy));
            if (StringUtil.isNotBlank(innerModel.having)) {
                sql = sql.concat(" having ").concat(SqlUtil.convertFieldsToColumns(entityMeta, innerModel.having));
            }
        }
        if (!innerModel.orderBy.isEmpty()) {
            sql = sql.concat(" order by ");
            Iterator<Map.Entry<String, String>> iter = innerModel.orderBy.entrySet().iterator();
            int index = 0;
            while (iter.hasNext()) {
                Map.Entry<String, String> entry = iter.next();
                String columnName = entityMeta.getColumnName(entry.getKey());
                if (columnName == null) {
                    columnName = entry.getKey();
                }
                columnName = ReservedWordsUtil.convertWord(columnName, null);
                if (index > 0) {
                    sql = sql.concat(",");
                }
                sql = sql.concat(columnName).concat(entry.getValue());
                ++index;
            }
        }
        Class clazz = resultType = resultClass == null ? entityClass : resultClass;
        QueryExecutor queryExecutor = SqlConfigParseUtils.hasNamedParam(where) && StringUtil.isBlank(innerModel.names) ? new QueryExecutor(sql, innerModel.values == null || innerModel.values.length == 0 ? null : (Serializable)innerModel.values[0]).resultType(resultType).dataSource(this.getDataSource(innerModel.dataSource)).fetchSize(innerModel.fetchSize).maxRows(innerModel.maxRows) : new QueryExecutor(sql).names(innerModel.names).values(innerModel.values).resultType(resultType).dataSource(this.getDataSource(innerModel.dataSource)).fetchSize(innerModel.fetchSize).maxRows(innerModel.maxRows);
        queryExecutor.getInnerModel().blankToNull = innerModel.blankToNull;
        queryExecutor.getInnerModel().entityClass = entityClass;
        if (!innerModel.translates.isEmpty()) {
            queryExecutor.getInnerModel().translates.putAll(innerModel.translates);
        }
        if (!innerModel.paramFilters.isEmpty()) {
            queryExecutor.getInnerModel().paramFilters.addAll(innerModel.paramFilters);
        }
        if (!innerModel.secureMask.isEmpty()) {
            queryExecutor.getInnerModel().secureMask.putAll(innerModel.secureMask);
        }
        if (innerModel.showSql != null) {
            queryExecutor.showSql(innerModel.showSql);
        }
        queryExecutor.getInnerModel().pageOptimize = innerModel.pageOptimize;
        SqlToyConfig sqlToyConfig = this.sqlToyContext.getSqlToyConfig(queryExecutor, SqlType.search, this.getDialect(queryExecutor.getInnerModel().dataSource));
        if (entityMeta.getSecureColumns() != null) {
            sqlToyConfig.setDecryptColumns(entityMeta.getSecureColumns());
        }
        this.setEntitySharding(queryExecutor, entityMeta);
        if (innerModel.dbSharding != null) {
            queryExecutor.getInnerModel().dbSharding = innerModel.dbSharding;
        }
        if (innerModel.tableSharding != null) {
            ShardingStrategyConfig shardingConfig = innerModel.tableSharding;
            shardingConfig.setTables(new String[]{entityMeta.getTableName()});
            ArrayList<ShardingStrategyConfig> tableShardings = new ArrayList<ShardingStrategyConfig>();
            tableShardings.add(shardingConfig);
            queryExecutor.getInnerModel().tableShardings = tableShardings;
        }
        DataSource realDataSource = this.getDataSource(queryExecutor.getInnerModel().dataSource, sqlToyConfig);
        if (isCount) {
            Long result = this.dialectFactory.getCountBySql(this.sqlToyContext, queryExecutor, sqlToyConfig, realDataSource);
            CrossDbAdapter.redoCountQuery(this.sqlToyContext, this.dialectFactory, queryExecutor);
            return result;
        }
        if (page == null) {
            List result;
            if (innerModel.pickType == 0) {
                result = this.dialectFactory.findTop(this.sqlToyContext, queryExecutor, sqlToyConfig, innerModel.pickSize, realDataSource).getRows();
                CrossDbAdapter.redoTopQuery(this.sqlToyContext, this.dialectFactory, queryExecutor, innerModel.pickSize);
            } else if (innerModel.pickType == 1) {
                result = this.dialectFactory.getRandomResult(this.sqlToyContext, queryExecutor, sqlToyConfig, innerModel.pickSize, realDataSource).getRows();
                CrossDbAdapter.redoRandomQuery(this.sqlToyContext, this.dialectFactory, queryExecutor, innerModel.pickSize);
            } else {
                result = this.dialectFactory.findByQuery(this.sqlToyContext, queryExecutor, sqlToyConfig, innerModel.lockMode, realDataSource).getRows();
                CrossDbAdapter.redoQuery(this.sqlToyContext, this.dialectFactory, queryExecutor);
            }
            return result;
        }
        Page result = page.getSkipQueryCount() != false ? this.dialectFactory.findSkipTotalCountPage(this.sqlToyContext, queryExecutor, sqlToyConfig, page.getPageNo(), page.getPageSize(), realDataSource).getPageResult() : this.dialectFactory.findPage(this.sqlToyContext, queryExecutor, sqlToyConfig, page.getPageNo(), page.getPageSize(), page.getOverPageToFirst(), realDataSource).getPageResult();
        CrossDbAdapter.redoPageQuery(this.sqlToyContext, this.dialectFactory, queryExecutor, page);
        return result;
    }

    protected Long updateByQuery(Class entityClass, EntityUpdate entityUpdate) {
        int valueSize;
        if (null == entityClass || null == entityUpdate || StringUtil.isBlank(entityUpdate.getInnerModel().where) || StringUtil.isBlank(entityUpdate.getInnerModel().values) || entityUpdate.getInnerModel().updateValues.isEmpty()) {
            throw new IllegalArgumentException("updateByQuery: entityClass\u3001where\u6761\u4ef6\u3001\u6761\u4ef6\u503cvalue\u3001\u53d8\u66f4\u503csetValues\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        EntityUpdateExtend innerModel = entityUpdate.getInnerModel();
        boolean isName = SqlConfigParseUtils.hasNamedParam(innerModel.where);
        Object[] values = innerModel.values;
        String[] paramNames = null;
        String where = innerModel.where;
        int n = valueSize = values == null ? 0 : values.length;
        if (isName) {
            if (values.length > 1) {
                throw new IllegalArgumentException("updateByQuery: where\u6761\u4ef6\u91c7\u7528:paramName\u5f62\u5f0f\u4f20\u53c2,values\u53ea\u80fd\u4f20\u9012\u5355\u4e2aVO\u6216Map\u5bf9\u8c61!");
            }
            paramNames = SqlConfigParseUtils.getSqlParamsName(where, false);
            values = BeanUtil.reflectBeanToAry(values[0], paramNames);
            valueSize = values.length;
        } else {
            int paramCnt = DialectUtils.getParamsCount(where);
            if (paramCnt == 1 && StringUtil.matches(where, SqlConfigParseUtils.IN_PATTERN) && valueSize > 1) {
                values = new Object[]{values};
                valueSize = 1;
            }
            if (paramCnt != valueSize) {
                throw new IllegalArgumentException("updateByQuery: where\u8bed\u53e5\u4e2d\u7684?\u6570\u91cf\u8ddf\u5bf9\u5e94values \u6570\u7ec4\u957f\u5ea6\u4e0d\u4e00\u81f4,\u8bf7\u68c0\u67e5!");
            }
        }
        EntityMeta entityMeta = this.getEntityMeta(entityClass);
        where = SqlUtil.convertFieldsToColumns(entityMeta, where);
        StringBuilder sql = new StringBuilder();
        sql.append("update ").append(entityMeta.getSchemaTable(null, null)).append(" set ");
        IUnifyFieldsHandler unifyHandler = this.getSqlToyContext().getUnifyFieldsHandler();
        if (unifyHandler != null) {
            Map<String, Object> updateFields;
            Map<String, Object> map = updateFields = UnifyUpdateFieldsController.useUnifyFields() ? unifyHandler.updateUnifyFields() : null;
            if (updateFields != null && !updateFields.isEmpty()) {
                for (Map.Entry<String, Object> entry : updateFields.entrySet()) {
                    if (entityMeta.getColumnName(entry.getKey()) == null) continue;
                    if (innerModel.updateValues.containsKey(entry.getKey())) {
                        if (unifyHandler.forceUpdateFields() == null || !unifyHandler.forceUpdateFields().contains(entry.getKey())) continue;
                        innerModel.updateValues.put(entry.getKey(), entry.getValue());
                        continue;
                    }
                    innerModel.updateValues.put(entry.getKey(), entry.getValue());
                }
            }
        }
        Object[] realValues = new Object[innerModel.updateValues.size() + valueSize];
        if (valueSize > 0) {
            System.arraycopy(values, 0, realValues, innerModel.updateValues.size(), valueSize);
        }
        String[] realNames = null;
        if (isName) {
            realNames = new String[realValues.length];
            System.arraycopy(paramNames, 0, realNames, innerModel.updateValues.size(), valueSize);
        }
        int index = 0;
        Iterator iter = innerModel.updateValues.entrySet().iterator();
        String extSign = "ExtParam";
        while (iter.hasNext()) {
            Map.Entry<String, Object> entry;
            entry = iter.next();
            String[] fields = entry.getKey().split("=");
            FieldMeta fieldMeta = entityMeta.getFieldMeta(fields[0].trim());
            if (fieldMeta == null) {
                String fieldName = entityMeta.getColumnFieldMap().get(fields[0].trim().toLowerCase());
                if (fieldName == null) {
                    throw new IllegalArgumentException("updateByQuery: \u5b57\u6bb5: " + fields[0] + " \u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5\u4ee3\u7801!");
                }
                fieldMeta = entityMeta.getFieldMeta(fieldName);
            }
            String columnName = fieldMeta.getColumnName();
            columnName = ReservedWordsUtil.convertWord(columnName, null);
            if (isName) {
                realNames[index] = fields.length > 1 ? (fields[1].contains("?") ? fieldMeta.getFieldName().concat("ExtParam") : SqlConfigParseUtils.getSqlParamsName(fields[1], true)[0]) : fieldMeta.getFieldName();
            }
            realValues[index] = entry.getValue();
            if (index > 0) {
                sql.append(",");
            }
            if (fields.length == 1) {
                sql.append(columnName).append("=").append((String)(isName ? ":" + fieldMeta.getFieldName() : "?"));
            } else {
                String fieldSetValue = fields[1];
                sql.append(columnName).append("=");
                if (isName && fieldSetValue.contains("?")) {
                    fieldSetValue = fieldSetValue.replace("?", ":" + fieldMeta.getFieldName().concat("ExtParam"));
                }
                fieldSetValue = SqlUtil.convertFieldsToColumns(entityMeta, fieldSetValue);
                sql.append(fieldSetValue);
            }
            ++index;
        }
        sql.append(" where ").append(where);
        String sqlStr = sql.toString();
        QueryExecutor queryExecutor = new QueryExecutor(sqlStr).names(realNames).values(realValues);
        queryExecutor.getInnerModel().blankToNull = innerModel.blankToNull == null ? SqlToyConstants.executeSqlBlankToNull : innerModel.blankToNull;
        queryExecutor.getInnerModel().entityClass = entityClass;
        this.setEntitySharding(queryExecutor, entityMeta);
        SqlToyConfig sqlToyConfig = this.sqlToyContext.getSqlToyConfig(queryExecutor, SqlType.update, this.getDialect(innerModel.dataSource));
        return this.dialectFactory.executeSql(this.sqlToyContext, sqlToyConfig, queryExecutor, null, null, this.getDataSource(innerModel.dataSource, sqlToyConfig));
    }

    protected <T extends Serializable> T convertType(Serializable source, Class<T> resultType, String ... ignoreProperties) {
        if (source == null || resultType == null) {
            throw new IllegalArgumentException("\u8c03\u7528convertType\u5bf9\u5355\u4e2a\u5bf9\u8c61\u8fdb\u884cPOJO<-->DTO \u8f6c\u6362\u8fc7\u7a0b\u4e2d\u53d1\u73b0\u53c2\u6570\u5f02\u5e38: source \u548c resultType \u4e0d\u80fd\u4e3anull!");
        }
        try {
            return MapperUtils.map(this.sqlToyContext, source, resultType, ignoreProperties);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u5c06\u5bf9\u8c61:" + source.getClass().getName() + "\u5c5e\u6027\u6570\u636e\u590d\u5236\u5230:" + resultType.getName() + "\u53d1\u751f\u5f02\u5e38!" + e.getMessage(), e);
        }
    }

    protected <T extends Serializable> List<T> convertType(List sourceList, Class<T> resultType, String ... ignoreProperties) {
        if (sourceList == null || resultType == null) {
            throw new IllegalArgumentException("\u8c03\u7528convertType\u5bf9\u96c6\u5408\u8fdb\u884cPOJO<-->DTO \u8f6c\u6362\u8fc7\u7a0b\u4e2d\u53d1\u73b0\u53c2\u6570\u5f02\u5e38: sourceList \u548c resultType \u4e0d\u80fd\u4e3anull!");
        }
        try {
            return MapperUtils.mapList(this.sqlToyContext, sourceList, resultType, ignoreProperties);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u5c06\u5bf9\u8c61:" + sourceList.get(0).getClass().getName() + " \u5c5e\u6027\u6570\u636e\u590d\u5236\u5230:" + resultType.getName() + " \u53d1\u751f\u5f02\u5e38!" + e.getMessage(), e);
        }
    }

    protected <T extends Serializable> Page<T> convertType(Page sourcePage, Class<T> resultType, String ... ignoreProperties) {
        if (sourcePage == null) {
            return null;
        }
        Page<T> result = new Page<T>();
        result.setPageNo(sourcePage.getPageNo());
        result.setPageSize(sourcePage.getPageSize());
        result.setRecordCount(sourcePage.getRecordCount());
        result.setSkipQueryCount(sourcePage.getSkipQueryCount());
        if (sourcePage.getRows().isEmpty()) {
            return result;
        }
        result.setRows(this.convertType(sourcePage.getRows(), resultType, ignoreProperties));
        return result;
    }

    protected <T> List<QueryResult<T>> parallQuery(List<ParallQuery> parallQueryList, String[] paramNames, Object[] paramValues) {
        return this.parallQuery(parallQueryList, paramNames, paramValues, null);
    }

    protected <T> List<QueryResult<T>> parallQuery(List<ParallQuery> parallQueryList, Map<String, Object> paramsMap, ParallelConfig parallelConfig) {
        return this.parallQuery(parallQueryList, null, new Object[]{new IgnoreKeyCaseMap<String, Object>(paramsMap)}, parallelConfig);
    }

    protected List<ColumnMeta> getTableColumns(String catalog, String schema, String tableName, DataSource dataSource) {
        return this.dialectFactory.getTableColumns(this.sqlToyContext, catalog, schema, tableName, this.getDataSource(dataSource));
    }

    protected List<TableMeta> getTables(String catalog, String schema, String tableName, DataSource dataSource) {
        return this.dialectFactory.getTables(this.sqlToyContext, catalog, schema, tableName, this.getDataSource(dataSource));
    }

    protected <T> List<QueryResult<T>> parallQuery(List<ParallQuery> parallQueryList, String[] paramNames, Object[] paramValues, ParallelConfig parallelConfig) {
        if (parallQueryList == null || parallQueryList.isEmpty()) {
            return null;
        }
        ParallelConfig parallConfig = parallelConfig;
        if (parallConfig == null) {
            parallConfig = new ParallelConfig();
        }
        if (parallConfig.getMaxThreads() == null) {
            parallConfig.maxThreads(10);
        }
        int thread = parallConfig.getMaxThreads();
        if (parallQueryList.size() < thread) {
            thread = parallQueryList.size();
        }
        ArrayList<QueryResult<T>> results = new ArrayList<QueryResult<T>>();
        ExecutorService pool = null;
        try {
            pool = Executors.newFixedThreadPool(thread);
            ArrayList<Future<ParallQueryResult>> futureResult = new ArrayList<Future<ParallQueryResult>>();
            for (ParallQuery query : parallQueryList) {
                SqlToyConfig sqlToyConfig = this.sqlToyContext.getSqlToyConfig(new QueryExecutor(query.getExtend().sql).resultType(query.getExtend().resultType), SqlType.search, this.getDialect(query.getExtend().dataSource));
                Future<ParallQueryResult> future = query.getExtend().selfCondition ? pool.submit(new ParallQueryExecutor(this.sqlToyContext, this.dialectFactory, sqlToyConfig, query, query.getExtend().names, query.getExtend().values, this.getDataSource(query.getExtend().dataSource, sqlToyConfig))) : pool.submit(new ParallQueryExecutor(this.sqlToyContext, this.dialectFactory, sqlToyConfig, query, paramNames, paramValues, this.getDataSource(query.getExtend().dataSource, sqlToyConfig)));
                futureResult.add(future);
            }
            pool.shutdown();
            if (parallConfig.getMaxWaitSeconds() != null) {
                pool.awaitTermination(parallConfig.getMaxWaitSeconds().intValue(), TimeUnit.SECONDS);
            } else {
                pool.awaitTermination(SqlToyConstants.PARALLEL_MAXWAIT_SECONDS, TimeUnit.SECONDS);
            }
            int index = 0;
            for (Future future : futureResult) {
                ++index;
                ParallQueryResult item = (ParallQueryResult)future.get();
                if (item != null && !item.isSuccess()) {
                    throw new DataAccessException("\u7b2c:{} \u4e2asql\u6267\u884c\u5f02\u5e38:{}!", index, item.getMessage());
                }
                results.add(item.getResult());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DataAccessException("\u5e76\u884c\u67e5\u8be2\u6267\u884c\u9519\u8bef:" + e.getMessage(), e);
        }
        finally {
            if (pool != null) {
                pool.shutdownNow();
            }
        }
        return results;
    }

    protected String getDialect(DataSource dataSource) {
        if (StringUtil.isNotBlank(this.sqlToyContext.getDialect())) {
            return this.sqlToyContext.getDialect();
        }
        return DataSourceUtils.getDialect(this.sqlToyContext, this.getDataSource(dataSource));
    }

    private void setEntitySharding(QueryExecutor queryExecutor, EntityMeta entityMeta) {
        if (entityMeta.getShardingConfig() != null) {
            if (entityMeta.getShardingConfig().getShardingDBStrategy() != null) {
                queryExecutor.getInnerModel().dbSharding = entityMeta.getShardingConfig().getShardingDBStrategy();
            }
            if (entityMeta.getShardingConfig().getShardingTableStrategy() != null) {
                ArrayList<ShardingStrategyConfig> shardingConfig = new ArrayList<ShardingStrategyConfig>();
                shardingConfig.add(entityMeta.getShardingConfig().getShardingTableStrategy());
                queryExecutor.getInnerModel().tableShardings = shardingConfig;
            }
        }
    }
}

