/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.plugins.nosql;

import java.util.List;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.config.model.SqlToyConfig;
import org.sagacity.sqltoy.model.Page;
import org.sagacity.sqltoy.model.QueryExecutor;
import org.sagacity.sqltoy.model.inner.DataSetResult;
import org.sagacity.sqltoy.model.inner.QueryExecutorExtend;
import org.sagacity.sqltoy.plugins.nosql.ElasticSearchUtils;
import org.sagacity.sqltoy.utils.MongoElasticUtils;
import org.sagacity.sqltoy.utils.QueryExecutorBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSqlPlugin {
    protected static final Logger logger = LoggerFactory.getLogger(ElasticSqlPlugin.class);

    public static Page findPage(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, Page pageModel, QueryExecutor queryExecutor) throws Exception {
        QueryExecutorExtend extend = queryExecutor.getInnerModel();
        QueryExecutorBuilder.initQueryExecutor(sqlToyContext, extend, sqlToyConfig, false);
        Object realSql = MongoElasticUtils.wrapES(sqlToyConfig, extend.getParamsName(), extend.getParamsValue(sqlToyContext, sqlToyConfig)).trim();
        realSql = (String)realSql + " limit " + (pageModel.getPageNo() - 1L) * (long)pageModel.getPageSize() + "," + pageModel.getPageSize();
        if (sqlToyContext.isDebug()) {
            if (logger.isDebugEnabled()) {
                logger.debug("findPageByElastic sql=" + (String)realSql);
            } else {
                System.out.println("findPageByElastic sql=" + (String)realSql);
            }
        }
        Page page = new Page();
        page.setPageNo(pageModel.getPageNo());
        page.setPageSize(pageModel.getPageSize());
        DataSetResult result = ElasticSearchUtils.executeQuery(sqlToyContext, sqlToyConfig, (String)realSql, (Class)extend.resultType, extend.humpMapLabel);
        page.setRows(result.getRows());
        page.setRecordCount(result.getRecordCount());
        return page;
    }

    public static List<?> findTop(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, QueryExecutor queryExecutor, Integer topSize) throws Exception {
        QueryExecutorExtend extend = queryExecutor.getInnerModel();
        QueryExecutorBuilder.initQueryExecutor(sqlToyContext, extend, sqlToyConfig, false);
        Object realSql = MongoElasticUtils.wrapES(sqlToyConfig, extend.getParamsName(), extend.getParamsValue(sqlToyContext, sqlToyConfig)).trim();
        if (topSize != null) {
            realSql = (String)realSql + " limit " + topSize;
        }
        if (sqlToyContext.isDebug()) {
            if (logger.isDebugEnabled()) {
                logger.debug("findTopByElastic sql=" + (String)realSql);
            } else {
                System.out.println("findTopByElastic sql=" + (String)realSql);
            }
        }
        DataSetResult result = ElasticSearchUtils.executeQuery(sqlToyContext, sqlToyConfig, (String)realSql, (Class)extend.resultType, extend.humpMapLabel);
        return result.getRows();
    }
}

