/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.plugins.id.macro.impl;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sagacity.sqltoy.model.IgnoreKeyCaseMap;
import org.sagacity.sqltoy.plugins.id.macro.AbstractMacro;
import org.sagacity.sqltoy.utils.BeanUtil;
import org.sagacity.sqltoy.utils.CollectionUtil;
import org.sagacity.sqltoy.utils.DateUtil;
import org.sagacity.sqltoy.utils.StringUtil;

public class SqlLoop
extends AbstractMacro {
    private static final Pattern paramPattern = Pattern.compile("\\:sqlToyLoopAsKey_\\d+A(\\.[a-zA-Z\u4e00-\u9fa5][0-9a-zA-Z\u4e00-\u9fa5_]*)*\\W");
    private boolean skipBlank = true;

    public SqlLoop() {
    }

    public SqlLoop(boolean skipBlank) {
        this.skipBlank = skipBlank;
    }

    @Override
    public String execute(String[] params, IgnoreKeyCaseMap<String, Object> keyValues) {
        Object key;
        if (params == null || params.length < 2 || keyValues == null || keyValues.size() == 0) {
            return " ";
        }
        for (int i = 0; i < params.length; ++i) {
            String varStr = params[i].trim();
            if (varStr.startsWith("'") && varStr.endsWith("'") || varStr.startsWith("\"") && varStr.endsWith("\"") || varStr.startsWith("{") && varStr.endsWith("}")) {
                varStr = varStr.substring(1, varStr.length() - 1);
            }
            params[i] = varStr;
        }
        String loopParam = params[0].trim();
        if (loopParam.startsWith(":")) {
            loopParam = loopParam.substring(1).trim();
        }
        String loopContent = params[1];
        String linkSign = params.length > 2 ? params[2] : " ";
        Object[] loopValues = CollectionUtil.convertArray(keyValues.get(loopParam));
        if (loopValues == null || loopValues.length == 0) {
            return " @blank(:" + loopParam + ") ";
        }
        int start = 0;
        int end = loopValues.length;
        if (params.length > 3) {
            start = Integer.parseInt(params[3].trim());
        }
        if (start > loopValues.length - 1) {
            return " @blank(:" + loopParam + ") ";
        }
        if (params.length > 4) {
            end = Integer.parseInt(params[4].trim());
        }
        if (end >= loopValues.length) {
            end = loopValues.length;
        }
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<Object[]> regParamValues = new ArrayList<Object[]>();
        String lowContent = loopContent.toLowerCase();
        Enumeration keyEnums = keyValues.keys();
        int index = 0;
        while (keyEnums.hasMoreElements()) {
            key = ((String)keyEnums.nextElement()).toLowerCase();
            if (!lowContent.contains(":" + (String)key + "[i]") && !lowContent.contains(":" + (String)key + "[index]")) continue;
            keys.add((String)key);
            loopContent = loopContent.replaceAll("(?i)\\:" + (String)key + "\\[index\\]", ":sqlToyLoopAsKey_" + index + "A");
            loopContent = loopContent.replaceAll("(?i)\\:" + (String)key + "\\[i\\]", ":sqlToyLoopAsKey_" + index + "A");
            regParamValues.add(CollectionUtil.convertArray(keyValues.get(key)));
            ++index;
        }
        StringBuilder result = new StringBuilder();
        result.append(" @blank(:" + loopParam + ") ");
        index = 0;
        Map<String, String[]> loopParamNamesMap = SqlLoop.parseParams(loopContent);
        for (int i = start; i < end; ++i) {
            Object loopVar = loopValues[i];
            if (this.skipBlank && !StringUtil.isNotBlank(loopVar)) continue;
            String loopStr = loopContent;
            if (index > 0) {
                result.append(" ");
                result.append(linkSign);
            }
            result.append(" ");
            for (int j = 0; j < keys.size(); ++j) {
                key = ":sqlToyLoopAsKey_" + j + "A";
                String[] loopParamNames = loopParamNamesMap.get(key);
                if (loopParamNames.length == 0) {
                    loopStr = loopStr.replaceAll((String)key, SqlLoop.toString(((Object[])regParamValues.get(j))[i]));
                    continue;
                }
                Object[] loopParamValues = BeanUtil.reflectBeanToAry(((Object[])regParamValues.get(j))[i], loopParamNames);
                for (int k = 0; k < loopParamNames.length; ++k) {
                    loopStr = loopStr.replaceAll(((String)key).concat(".").concat(loopParamNames[k]), SqlLoop.toString(loopParamValues[k]));
                }
            }
            result.append(loopStr);
            ++index;
        }
        result.append(" ");
        return result.toString();
    }

    private static String toString(Object paramValue) {
        String valueStr = paramValue instanceof Date || paramValue instanceof LocalDateTime ? DateUtil.formatDate(paramValue, "yyyy-MM-dd HH:mm:ss") : (paramValue instanceof LocalDate ? DateUtil.formatDate(paramValue, "yyyy-MM-dd") : (paramValue instanceof LocalTime ? DateUtil.formatDate(paramValue, "HH:mm:ss") : "" + paramValue));
        return valueStr;
    }

    public static Map<String, String[]> parseParams(String template) {
        HashMap<String, String[]> paramsMap = new HashMap<String, String[]>();
        Matcher m = paramPattern.matcher(template.concat(" "));
        while (m.find()) {
            String group = m.group();
            int dotIndex = (group = group.substring(0, group.length() - 1)).indexOf(".");
            if (dotIndex != -1) {
                String key = group.substring(0, dotIndex);
                String[] items = (String[])paramsMap.get(key);
                if (items == null) {
                    paramsMap.put(key, new String[]{group.substring(dotIndex + 1)});
                    continue;
                }
                String[] newItems = new String[items.length + 1];
                newItems[items.length] = group.substring(dotIndex + 1);
                System.arraycopy(items, 0, newItems, 0, items.length);
                paramsMap.put(key, newItems);
                continue;
            }
            paramsMap.put(group, new String[0]);
        }
        return paramsMap;
    }
}

