/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.link;

import java.io.Serializable;
import java.util.Map;
import javax.sql.DataSource;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.config.model.SqlToyConfig;
import org.sagacity.sqltoy.config.model.SqlType;
import org.sagacity.sqltoy.link.BaseLink;
import org.sagacity.sqltoy.model.IgnoreKeyCaseMap;
import org.sagacity.sqltoy.model.QueryExecutor;
import org.sagacity.sqltoy.utils.StringUtil;

public class Execute
extends BaseLink {
    private static final long serialVersionUID = 6336692505147861983L;
    private String sql;
    private Serializable entity;
    private Boolean autoCommit = false;
    private String[] paramsNamed;
    private Object[] paramsValue;

    public Execute(SqlToyContext sqlToyContext, DataSource dataSource) {
        super(sqlToyContext, dataSource);
    }

    public Execute dataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        this.defaultDataSource = false;
        return this;
    }

    public Execute entity(Serializable entity) {
        this.entity = entity;
        return this;
    }

    public Execute names(String ... paramsNamed) {
        this.paramsNamed = paramsNamed;
        return this;
    }

    public Execute values(Object ... paramsValue) {
        if (paramsValue != null && paramsValue.length == 1 && paramsValue[0] != null && paramsValue[0] instanceof Map) {
            this.entity = paramsValue[0] instanceof IgnoreKeyCaseMap ? (IgnoreKeyCaseMap)paramsValue[0] : new IgnoreKeyCaseMap((Map)paramsValue[0]);
        } else {
            this.paramsValue = paramsValue;
        }
        return this;
    }

    public Execute autoCommit(Boolean autoCommit) {
        this.autoCommit = autoCommit;
        return this;
    }

    public Execute sql(String sql) {
        this.sql = sql;
        return this;
    }

    public Long submit() {
        if (StringUtil.isBlank(this.sql)) {
            throw new IllegalArgumentException("execute operate sql is null!");
        }
        SqlToyConfig sqlToyConfig = this.sqlToyContext.getSqlToyConfig(this.sql, SqlType.update, super.getDialect());
        QueryExecutor queryExecute = this.build();
        return this.dialectFactory.executeSql(this.sqlToyContext, sqlToyConfig, queryExecute, null, this.autoCommit, this.getDataSource(sqlToyConfig));
    }

    private QueryExecutor build() {
        QueryExecutor queryExecutor = null;
        queryExecutor = this.entity != null ? new QueryExecutor(this.sql, this.entity) : new QueryExecutor(this.sql).names(this.paramsNamed).values(this.paramsValue);
        return queryExecutor;
    }
}

