/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.dialect.utils;

import java.util.HashSet;
import org.sagacity.sqltoy.config.model.EntityMeta;
import org.sagacity.sqltoy.config.model.FieldMeta;
import org.sagacity.sqltoy.config.model.PKStrategy;
import org.sagacity.sqltoy.dialect.utils.DialectExtUtils;
import org.sagacity.sqltoy.utils.ReservedWordsUtil;

public class SqliteDialectUtils {
    public static boolean isAssignPKValue(PKStrategy pkStrategy) {
        if (pkStrategy == null) {
            return true;
        }
        if (pkStrategy.equals((Object)PKStrategy.SEQUENCE)) {
            return false;
        }
        return !pkStrategy.equals((Object)PKStrategy.IDENTITY);
    }

    public static String getSaveOrUpdateSql(Integer dbType, EntityMeta entityMeta, String[] forceUpdateFields, String tableName) {
        String realTable = entityMeta.getSchemaTable(tableName, dbType);
        if (entityMeta.getIdArray() == null) {
            return DialectExtUtils.generateInsertSql(dbType, entityMeta, entityMeta.getIdStrategy(), "ifnull", null, false, realTable);
        }
        boolean allIds = entityMeta.getRejectIdFieldArray() == null;
        StringBuilder sql = allIds ? new StringBuilder("replace into ") : new StringBuilder("insert into ");
        StringBuilder values = new StringBuilder();
        sql.append(realTable);
        sql.append(" (");
        int n = entityMeta.getFieldsArray().length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                sql.append(",");
                values.append(",");
            }
            String fieldName = entityMeta.getFieldsArray()[i];
            FieldMeta fieldMeta = entityMeta.getFieldMeta(fieldName);
            sql.append(ReservedWordsUtil.convertWord(fieldMeta.getColumnName(), dbType));
            if (null != fieldMeta.getDefaultValue()) {
                values.append("ifnull(?,");
                DialectExtUtils.processDefaultValue(values, dbType, fieldMeta, fieldMeta.getDefaultValue());
                values.append(")");
                continue;
            }
            values.append("?");
        }
        sql.append(") values (").append((CharSequence)values).append(") ");
        if (!allIds) {
            sql.append(" ON CONFLICT (");
            int n2 = entityMeta.getIdArray().length;
            for (int i = 0; i < n2; ++i) {
                if (i > 0) {
                    sql.append(",");
                }
                String columnName = entityMeta.getColumnName(entityMeta.getIdArray()[i]);
                sql.append(ReservedWordsUtil.convertWord(columnName, dbType));
            }
            sql.append(" ) DO UPDATE SET ");
            HashSet<String> fupc = new HashSet<String>();
            if (forceUpdateFields != null) {
                for (String field : forceUpdateFields) {
                    fupc.add(ReservedWordsUtil.convertWord(entityMeta.getColumnName(field), dbType));
                }
            }
            int n3 = entityMeta.getRejectIdFieldArray().length;
            for (int i = 0; i < n3; ++i) {
                String columnName = entityMeta.getColumnName(entityMeta.getRejectIdFieldArray()[i]);
                columnName = ReservedWordsUtil.convertWord(columnName, dbType);
                if (i > 0) {
                    sql.append(",");
                }
                sql.append(columnName).append("=");
                if (fupc.contains(columnName)) {
                    sql.append("excluded.").append(columnName);
                    continue;
                }
                sql.append("ifnull(excluded.");
                sql.append(columnName).append(",");
                sql.append(columnName).append(")");
            }
        }
        return sql.toString();
    }
}

