/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.dialect.utils;

import java.io.Serializable;
import java.sql.Connection;
import java.util.HashSet;
import java.util.List;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.callback.DecryptHandler;
import org.sagacity.sqltoy.callback.GenerateSavePKStrategy;
import org.sagacity.sqltoy.callback.GenerateSqlHandler;
import org.sagacity.sqltoy.callback.ReflectPropsHandler;
import org.sagacity.sqltoy.config.model.EntityMeta;
import org.sagacity.sqltoy.config.model.FieldMeta;
import org.sagacity.sqltoy.config.model.OperateType;
import org.sagacity.sqltoy.config.model.PKStrategy;
import org.sagacity.sqltoy.config.model.SqlToyConfig;
import org.sagacity.sqltoy.config.model.SqlToyResult;
import org.sagacity.sqltoy.dialect.model.SavePKStrategy;
import org.sagacity.sqltoy.dialect.utils.DialectExtUtils;
import org.sagacity.sqltoy.dialect.utils.DialectUtils;
import org.sagacity.sqltoy.model.QueryExecutor;
import org.sagacity.sqltoy.model.QueryResult;
import org.sagacity.sqltoy.model.inner.QueryExecutorExtend;
import org.sagacity.sqltoy.utils.ReservedWordsUtil;

public class PostgreSqlDialectUtils {
    public static final String NVL_FUNCTION = "COALESCE";

    public static QueryResult getRandomResult(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, QueryExecutor queryExecutor, DecryptHandler decryptHandler, Long totalCount, Long randomCount, Connection conn, Integer dbType, String dialect, int fetchSize, int maxRows) throws Exception {
        String innerSql = sqlToyConfig.isHasFast() ? sqlToyConfig.getFastSql(dialect) : sqlToyConfig.getSql(dialect);
        boolean hasOrderOrUnion = DialectUtils.hasOrderByOrUnion(innerSql);
        StringBuilder sql = new StringBuilder();
        if (sqlToyConfig.isHasFast()) {
            sql.append(sqlToyConfig.getFastPreSql(dialect));
            if (!sqlToyConfig.isIgnoreBracket()) {
                sql.append(" (");
            }
        }
        if (hasOrderOrUnion) {
            sql.append("select sag_random_table.* from (");
        }
        sql.append(innerSql);
        if (hasOrderOrUnion) {
            sql.append(") sag_random_table ");
        }
        sql.append(" order by random() limit ");
        sql.append(randomCount);
        if (sqlToyConfig.isHasFast()) {
            if (!sqlToyConfig.isIgnoreBracket()) {
                sql.append(") ");
            }
            sql.append(sqlToyConfig.getFastTailSql(dialect));
        }
        SqlToyResult queryParam = DialectUtils.wrapPageSqlParams(sqlToyContext, sqlToyConfig, queryExecutor, sql.toString(), null, null, dialect);
        QueryExecutorExtend extend = queryExecutor.getInnerModel();
        queryParam = DialectUtils.doInterceptors(sqlToyContext, sqlToyConfig, extend.entityClass == null ? OperateType.random : OperateType.singleTable, queryParam, extend.entityClass, dbType);
        return DialectUtils.findBySql(sqlToyContext, sqlToyConfig, queryParam.getSql(), queryParam.getParamsValue(), extend, decryptHandler, conn, dbType, 0, fetchSize, maxRows);
    }

    public static Object save(SqlToyContext sqlToyContext, Serializable entity, Connection conn, final Integer dbType, String tableName) throws Exception {
        EntityMeta entityMeta = sqlToyContext.getEntityMeta(entity.getClass());
        PKStrategy pkStrategy = entityMeta.getIdStrategy();
        Object sequence = "nextval('" + entityMeta.getSequence() + "')";
        if (pkStrategy != null && pkStrategy.equals((Object)PKStrategy.IDENTITY)) {
            pkStrategy = PKStrategy.SEQUENCE;
            sequence = "DEFAULT";
        }
        boolean isAssignPK = PostgreSqlDialectUtils.isAssignPKValue(pkStrategy);
        String insertSql = DialectExtUtils.generateInsertSql(dbType, entityMeta, pkStrategy, NVL_FUNCTION, (String)sequence, isAssignPK, tableName);
        return DialectUtils.save(sqlToyContext, entityMeta, pkStrategy, isAssignPK, insertSql, entity, new GenerateSqlHandler(){

            @Override
            public String generateSql(EntityMeta entityMeta, String[] forceUpdateField) {
                PKStrategy pkStrategy = entityMeta.getIdStrategy();
                Object sequence = "nextval('" + entityMeta.getSequence() + "')";
                if (pkStrategy != null && pkStrategy.equals((Object)PKStrategy.IDENTITY)) {
                    pkStrategy = PKStrategy.SEQUENCE;
                    sequence = "DEFAULT";
                }
                return DialectExtUtils.generateInsertSql(dbType, entityMeta, pkStrategy, PostgreSqlDialectUtils.NVL_FUNCTION, (String)sequence, PostgreSqlDialectUtils.isAssignPKValue(pkStrategy), null);
            }
        }, new GenerateSavePKStrategy(){

            @Override
            public SavePKStrategy generate(EntityMeta entityMeta) {
                return new SavePKStrategy(entityMeta.getIdStrategy(), PostgreSqlDialectUtils.isAssignPKValue(entityMeta.getIdStrategy()));
            }
        }, conn, dbType);
    }

    public static Long saveAll(SqlToyContext sqlToyContext, List<?> entities, int batchSize, ReflectPropsHandler reflectPropsHandler, Connection conn, Integer dbType, Boolean autoCommit, String tableName) throws Exception {
        EntityMeta entityMeta = sqlToyContext.getEntityMeta(entities.get(0).getClass());
        PKStrategy pkStrategy = entityMeta.getIdStrategy();
        Object sequence = "nextval('" + entityMeta.getSequence() + "')";
        if (pkStrategy != null && pkStrategy.equals((Object)PKStrategy.IDENTITY)) {
            pkStrategy = PKStrategy.SEQUENCE;
            sequence = "DEFAULT";
        }
        boolean isAssignPK = PostgreSqlDialectUtils.isAssignPKValue(pkStrategy);
        String insertSql = DialectExtUtils.generateInsertSql(dbType, entityMeta, pkStrategy, NVL_FUNCTION, (String)sequence, isAssignPK, tableName);
        return DialectUtils.saveAll(sqlToyContext, entityMeta, pkStrategy, isAssignPK, insertSql, entities, batchSize, reflectPropsHandler, conn, dbType, autoCommit);
    }

    public static Long saveOrUpdateAll(final SqlToyContext sqlToyContext, List<?> entities, int batchSize, ReflectPropsHandler reflectPropsHandler, String[] forceUpdateFields, Connection conn, final Integer dbType, String dialect, Boolean autoCommit, final String tableName) throws Exception {
        EntityMeta entityMeta = sqlToyContext.getEntityMeta(entities.get(0).getClass());
        return DialectUtils.saveOrUpdateAll(sqlToyContext, entities, batchSize, entityMeta, forceUpdateFields, new GenerateSqlHandler(){

            @Override
            public String generateSql(EntityMeta entityMeta, String[] forceUpdateFields) {
                PKStrategy pkStrategy = entityMeta.getIdStrategy();
                Object sequence = "nextval('" + entityMeta.getSequence() + "')";
                if (pkStrategy != null && pkStrategy.equals((Object)PKStrategy.IDENTITY)) {
                    pkStrategy = PKStrategy.SEQUENCE;
                    sequence = "DEFAULT";
                }
                return DialectUtils.getSaveOrUpdateSql(sqlToyContext.getUnifyFieldsHandler(), dbType, entityMeta, pkStrategy, forceUpdateFields, null, PostgreSqlDialectUtils.NVL_FUNCTION, (String)sequence, PostgreSqlDialectUtils.isAssignPKValue(pkStrategy), tableName);
            }
        }, reflectPropsHandler, conn, dbType, autoCommit);
    }

    @Deprecated
    public static String getSaveOrUpdateSql(Integer dbType, EntityMeta entityMeta, PKStrategy pkStrategy, boolean isAssignPK, String sequence, String[] forceUpdateFields, String tableName) {
        String columnName;
        int i;
        String realTable = entityMeta.getSchemaTable(tableName, dbType);
        if (entityMeta.getIdArray() == null) {
            return DialectExtUtils.generateInsertSql(dbType, entityMeta, entityMeta.getIdStrategy(), NVL_FUNCTION, null, false, realTable);
        }
        boolean allIds = entityMeta.getRejectIdFieldArray() == null;
        StringBuilder sql = new StringBuilder("insert into ");
        StringBuilder values = new StringBuilder();
        sql.append(realTable);
        sql.append(" AS t1 (");
        boolean isStart = true;
        int n = entityMeta.getFieldsArray().length;
        for (i = 0; i < n; ++i) {
            String fieldName = entityMeta.getFieldsArray()[i];
            FieldMeta fieldMeta = entityMeta.getFieldMeta(fieldName);
            columnName = ReservedWordsUtil.convertWord(fieldMeta.getColumnName(), dbType);
            if (!isStart) {
                sql.append(",");
                values.append(",");
            }
            if (fieldMeta.isPK()) {
                if (pkStrategy.equals((Object)PKStrategy.IDENTITY)) {
                    if (!isAssignPK) continue;
                    sql.append(columnName);
                    values.append("?");
                    isStart = false;
                    continue;
                }
                if (pkStrategy.equals((Object)PKStrategy.SEQUENCE)) {
                    sql.append(columnName);
                    if (isAssignPK) {
                        values.append(NVL_FUNCTION);
                        values.append("(?,").append(sequence).append(")");
                    } else {
                        values.append(sequence);
                    }
                    isStart = false;
                    continue;
                }
                sql.append(columnName);
                values.append("?");
                isStart = false;
                continue;
            }
            sql.append(columnName);
            if (null != fieldMeta.getDefaultValue()) {
                values.append(NVL_FUNCTION);
                values.append("(?,");
                DialectExtUtils.processDefaultValue(values, dbType, fieldMeta, fieldMeta.getDefaultValue());
                values.append(")");
            } else {
                values.append("?");
            }
            isStart = false;
        }
        sql.append(") values (");
        sql.append((CharSequence)values);
        sql.append(") ");
        if (!allIds) {
            sql.append(" ON CONFLICT (");
            n = entityMeta.getIdArray().length;
            for (i = 0; i < n; ++i) {
                if (i > 0) {
                    sql.append(",");
                }
                columnName = entityMeta.getColumnName(entityMeta.getIdArray()[i]);
                sql.append(ReservedWordsUtil.convertWord(columnName, dbType));
            }
            sql.append(" ) DO UPDATE SET ");
            HashSet<String> fupc = new HashSet<String>();
            if (forceUpdateFields != null) {
                for (String field : forceUpdateFields) {
                    fupc.add(ReservedWordsUtil.convertWord(entityMeta.getColumnName(field), dbType));
                }
            }
            int n2 = entityMeta.getRejectIdFieldArray().length;
            for (int i2 = 0; i2 < n2; ++i2) {
                columnName = entityMeta.getColumnName(entityMeta.getRejectIdFieldArray()[i2]);
                columnName = ReservedWordsUtil.convertWord(columnName, dbType);
                if (i2 > 0) {
                    sql.append(",");
                }
                sql.append(columnName).append("=");
                if (fupc.contains(columnName)) {
                    sql.append("excluded.").append(columnName);
                    continue;
                }
                sql.append("COALESCE(excluded.");
                sql.append(columnName).append(",t1.");
                sql.append(columnName).append(")");
            }
        }
        return sql.toString();
    }

    public static boolean isAssignPKValue(PKStrategy pkStrategy) {
        if (pkStrategy == null) {
            return true;
        }
        if (pkStrategy.equals((Object)PKStrategy.SEQUENCE)) {
            return false;
        }
        return !pkStrategy.equals((Object)PKStrategy.IDENTITY);
    }
}

