/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.dialect.utils;

import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.callback.CallableStatementResultHandler;
import org.sagacity.sqltoy.callback.DecryptHandler;
import org.sagacity.sqltoy.callback.PreparedStatementResultHandler;
import org.sagacity.sqltoy.config.model.EntityMeta;
import org.sagacity.sqltoy.config.model.OperateType;
import org.sagacity.sqltoy.config.model.PKStrategy;
import org.sagacity.sqltoy.config.model.SqlToyConfig;
import org.sagacity.sqltoy.config.model.SqlToyResult;
import org.sagacity.sqltoy.config.model.SqlType;
import org.sagacity.sqltoy.dialect.utils.DefaultDialectUtils;
import org.sagacity.sqltoy.dialect.utils.DialectUtils;
import org.sagacity.sqltoy.model.ColumnMeta;
import org.sagacity.sqltoy.model.LockMode;
import org.sagacity.sqltoy.model.QueryExecutor;
import org.sagacity.sqltoy.model.QueryResult;
import org.sagacity.sqltoy.model.StoreResult;
import org.sagacity.sqltoy.model.TableMeta;
import org.sagacity.sqltoy.model.inner.QueryExecutorExtend;
import org.sagacity.sqltoy.utils.ResultUtils;
import org.sagacity.sqltoy.utils.SqlUtil;
import org.sagacity.sqltoy.utils.StringUtil;

public class OracleDialectUtils {
    public static Serializable load(SqlToyContext sqlToyContext, Serializable entity, List<Class> cascadeTypes, LockMode lockMode, Connection conn, Integer dbType, String dialect, String tableName) throws Exception {
        EntityMeta entityMeta = sqlToyContext.getEntityMeta(entity.getClass());
        SqlToyConfig sqlToyConfig = sqlToyContext.getSqlToyConfig(entityMeta.getLoadSql(tableName), SqlType.search, dialect);
        String loadSql = sqlToyConfig.getSql(dialect);
        loadSql = loadSql.concat(OracleDialectUtils.getLockSql(loadSql, dbType, lockMode));
        return DialectUtils.load(sqlToyContext, sqlToyConfig, loadSql, entityMeta, entity, cascadeTypes, conn, dbType);
    }

    public static List<?> loadAll(SqlToyContext sqlToyContext, List<?> entities, List<Class> cascadeTypes, LockMode lockMode, Connection conn, Integer dbType, String tableName, int fetchSize, int maxRows) throws Exception {
        return DialectUtils.loadAll(sqlToyContext, entities, cascadeTypes, lockMode, conn, dbType, tableName, (sql, dbTypeValue, lockedMode) -> OracleDialectUtils.getLockSql(sql, dbTypeValue, lockedMode), fetchSize, maxRows);
    }

    public static QueryResult findPageBySql(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, QueryExecutor queryExecutor, DecryptHandler decryptHandler, Long pageNo, Integer pageSize, Connection conn, Integer dbType, String dialect, int fetchSize, int maxRows) throws Exception {
        StringBuilder sql = new StringBuilder();
        boolean isNamed = sqlToyConfig.isNamedParam();
        boolean hasOrderBy = SqlUtil.hasOrderBy(sqlToyConfig.isHasFast() ? sqlToyConfig.getFastSql(dialect) : sqlToyConfig.getSql(dialect), true);
        if (sqlToyConfig.isHasFast()) {
            sql.append(sqlToyConfig.getFastPreSql(dialect));
            if (!sqlToyConfig.isIgnoreBracket()) {
                sql.append(" (");
            }
        }
        if (hasOrderBy) {
            sql.append(" select SAG_Paginationtable.* from (");
        }
        sql.append(sqlToyConfig.isHasFast() ? sqlToyConfig.getFastSql(dialect) : sqlToyConfig.getSql(dialect));
        if (hasOrderBy) {
            sql.append(") SAG_Paginationtable ");
        }
        sql.append(" offset ");
        sql.append(isNamed ? ":pageFirstParamName" : "?");
        sql.append(" rows fetch next ");
        sql.append(isNamed ? ":pageLastParamName" : "?");
        sql.append(" rows only ");
        if (sqlToyConfig.isHasFast()) {
            if (!sqlToyConfig.isIgnoreBracket()) {
                sql.append(") ");
            }
            sql.append(sqlToyConfig.getFastTailSql(dialect));
        }
        SqlToyResult queryParam = DialectUtils.wrapPageSqlParams(sqlToyContext, sqlToyConfig, queryExecutor, sql.toString(), (pageNo - 1L) * (long)pageSize.intValue(), pageSize, dialect);
        QueryExecutorExtend extend = queryExecutor.getInnerModel();
        queryParam = DialectUtils.doInterceptors(sqlToyContext, sqlToyConfig, extend.entityClass == null ? OperateType.page : OperateType.singleTable, queryParam, extend.entityClass, dbType);
        return DialectUtils.findBySql(sqlToyContext, sqlToyConfig, queryParam.getSql(), queryParam.getParamsValue(), extend, decryptHandler, conn, dbType, 0, fetchSize, maxRows);
    }

    public static QueryResult findTopBySql(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, QueryExecutor queryExecutor, DecryptHandler decryptHandler, Integer topSize, Connection conn, Integer dbType, String dialect, int fetchSize, int maxRows) throws Exception {
        StringBuilder sql = new StringBuilder();
        boolean hasOrderBy = SqlUtil.hasOrderBy(sqlToyConfig.isHasFast() ? sqlToyConfig.getFastSql(dialect) : sqlToyConfig.getSql(dialect), true);
        if (sqlToyConfig.isHasFast()) {
            sql.append(sqlToyConfig.getFastPreSql(dialect));
            if (!sqlToyConfig.isIgnoreBracket()) {
                sql.append(" (");
            }
        }
        if (hasOrderBy) {
            sql.append("select SAG_Paginationtable.* from (");
        }
        sql.append(sqlToyConfig.isHasFast() ? sqlToyConfig.getFastSql(dialect) : sqlToyConfig.getSql(dialect));
        if (hasOrderBy) {
            sql.append(") SAG_Paginationtable ");
        }
        sql.append(" fetch first ");
        sql.append(topSize);
        sql.append(" rows only");
        if (sqlToyConfig.isHasFast()) {
            if (!sqlToyConfig.isIgnoreBracket()) {
                sql.append(") ");
            }
            sql.append(sqlToyConfig.getFastTailSql(dialect));
        }
        SqlToyResult queryParam = DialectUtils.wrapPageSqlParams(sqlToyContext, sqlToyConfig, queryExecutor, sql.toString(), null, null, dialect);
        QueryExecutorExtend extend = queryExecutor.getInnerModel();
        queryParam = DialectUtils.doInterceptors(sqlToyContext, sqlToyConfig, extend.entityClass == null ? OperateType.top : OperateType.singleTable, queryParam, extend.entityClass, dbType);
        return DialectUtils.findBySql(sqlToyContext, sqlToyConfig, queryParam.getSql(), queryParam.getParamsValue(), extend, decryptHandler, conn, dbType, 0, fetchSize, maxRows);
    }

    public static QueryResult getRandomResult(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, QueryExecutor queryExecutor, DecryptHandler decryptHandler, Long totalCount, Long randomCount, Connection conn, Integer dbType, String dialect, int fetchSize, int maxRows) throws Exception {
        String innerSql = sqlToyConfig.isHasFast() ? sqlToyConfig.getFastSql(dialect) : sqlToyConfig.getSql(dialect);
        boolean hasOrderOrUnion = DialectUtils.hasOrderByOrUnion(innerSql);
        StringBuilder sql = new StringBuilder();
        if (sqlToyConfig.isHasFast()) {
            sql.append(sqlToyConfig.getFastPreSql(dialect));
            if (!sqlToyConfig.isIgnoreBracket()) {
                sql.append(" (");
            }
        }
        if (hasOrderOrUnion) {
            sql.append("select * from (");
            sql.append(" select sag_random_table.* from ( ");
            sql.append(innerSql);
            sql.append(") sag_random_table ");
            sql.append(" order by dbms_random.random )");
        } else {
            sql.append("select sag_random_table.* from ( ");
            sql.append(innerSql);
            sql.append(" order by dbms_random.random) sag_random_table ");
        }
        sql.append(" where rownum<=");
        sql.append(randomCount);
        if (sqlToyConfig.isHasFast()) {
            if (!sqlToyConfig.isIgnoreBracket()) {
                sql.append(") ");
            }
            sql.append(sqlToyConfig.getFastTailSql(dialect));
        }
        SqlToyResult queryParam = DialectUtils.wrapPageSqlParams(sqlToyContext, sqlToyConfig, queryExecutor, sql.toString(), null, null, dialect);
        QueryExecutorExtend extend = queryExecutor.getInnerModel();
        queryParam = DialectUtils.doInterceptors(sqlToyContext, sqlToyConfig, extend.entityClass == null ? OperateType.random : OperateType.singleTable, queryParam, extend.entityClass, dbType);
        return DialectUtils.findBySql(sqlToyContext, sqlToyConfig, queryParam.getSql(), queryParam.getParamsValue(), extend, decryptHandler, conn, dbType, 0, fetchSize, maxRows);
    }

    public static StoreResult executeStore(final SqlToyConfig sqlToyConfig, final SqlToyContext sqlToyContext, final String storeSql, final Object[] inParamValues, final Integer[] outParamTypes, final Connection conn, final Integer dbType, final int fetchSize) throws Exception {
        CallableStatement callStat = null;
        ResultSet rs = null;
        return (StoreResult)SqlUtil.callableStatementProcess(null, callStat, rs, new CallableStatementResultHandler(){

            @Override
            public void execute(Object obj, CallableStatement callStat, ResultSet rs) throws Exception {
                int outCount;
                callStat = conn.prepareCall(storeSql);
                if (fetchSize > 0) {
                    callStat.setFetchSize(fetchSize);
                }
                SqlUtil.setParamsValue(sqlToyContext.getTypeHandler(), conn, dbType, callStat, inParamValues, null, 0);
                int cursorIndex = -1;
                int cursorCnt = 0;
                int inCount = inParamValues == null ? 0 : inParamValues.length;
                int n = outCount = outParamTypes == null ? 0 : outParamTypes.length;
                if (outCount != 0) {
                    for (int i = 0; i < outCount; ++i) {
                        callStat.registerOutParameter(i + inCount + 1, (int)outParamTypes[i]);
                        if (-10 != outParamTypes[i]) continue;
                        ++cursorCnt;
                        cursorIndex = i;
                    }
                }
                callStat.execute();
                StoreResult storeResult = new StoreResult();
                if (cursorIndex != -1) {
                    rs = (ResultSet)callStat.getObject(inCount + cursorIndex + 1);
                    QueryResult tempResult = ResultUtils.processResultSet(sqlToyContext, sqlToyConfig, conn, rs, null, null, null, 0);
                    storeResult.setLabelNames(tempResult.getLabelNames());
                    storeResult.setLabelTypes(tempResult.getLabelTypes());
                    storeResult.setRows(tempResult.getRows());
                }
                if (outCount != 0) {
                    Object[] outParams = new Object[outCount - cursorCnt];
                    int index = 0;
                    for (int i = 0; i < outCount; ++i) {
                        if (-10 == outParamTypes[i]) continue;
                        outParams[index] = callStat.getObject(i + inCount + 1);
                        ++index;
                    }
                    storeResult.setOutResult(outParams);
                }
                this.setResult(storeResult);
            }
        });
    }

    public static String getLockSql(String sql, Integer dbType, LockMode lockMode) {
        if (lockMode == null || SqlUtil.hasLock(sql, dbType)) {
            return "";
        }
        if (lockMode == LockMode.UPGRADE_NOWAIT) {
            return " for update nowait ";
        }
        if (lockMode == LockMode.UPGRADE_SKIPLOCK) {
            return " for update skip locked";
        }
        return " for update ";
    }

    public static List<ColumnMeta> getTableColumns(String catalog, String schema, final String tableName, Connection conn, Integer dbType, String dialect) throws Exception {
        List<ColumnMeta> tableColumns = DefaultDialectUtils.getTableColumns(catalog, schema, tableName, conn, dbType, dialect);
        String sql = "SELECT COLUMN_NAME,COMMENTS FROM USER_COL_COMMENTS WHERE TABLE_NAME=?";
        PreparedStatement pst = conn.prepareStatement(sql);
        ResultSet rs = null;
        Map colMap = (Map)SqlUtil.preparedStatementProcess(null, pst, rs, new PreparedStatementResultHandler(){

            @Override
            public void execute(Object rowData, PreparedStatement pst, ResultSet rs) throws Exception {
                pst.setString(1, tableName);
                rs = pst.executeQuery();
                HashMap<String, String> colComments = new HashMap<String, String>();
                while (rs.next()) {
                    String comment = rs.getString("COMMENTS");
                    if (comment == null) continue;
                    colComments.put(rs.getString("COLUMN_NAME").toUpperCase(), comment);
                }
                this.setResult(colComments);
            }
        });
        for (ColumnMeta col : tableColumns) {
            col.setComments((String)colMap.get(col.getColName().toUpperCase()));
        }
        return tableColumns;
    }

    public static List<TableMeta> getTables(String catalog, String schema, final String tableName, Connection conn, Integer dbType, String dialect) throws Exception {
        String sql = "select * from user_tab_comments";
        if (StringUtil.isNotBlank(tableName)) {
            sql = sql.concat(" where TABLE_NAME like ?");
        }
        PreparedStatement pst = conn.prepareStatement(sql);
        ResultSet rs = null;
        return (List)SqlUtil.preparedStatementProcess(null, pst, rs, new PreparedStatementResultHandler(){

            @Override
            public void execute(Object rowData, PreparedStatement pst, ResultSet rs) throws Exception {
                if (StringUtil.isNotBlank(tableName)) {
                    if (tableName.contains("%")) {
                        pst.setString(1, tableName);
                    } else {
                        pst.setString(1, "%" + tableName + "%");
                    }
                }
                rs = pst.executeQuery();
                ArrayList<TableMeta> tables = new ArrayList<TableMeta>();
                while (rs.next()) {
                    TableMeta tableMeta = new TableMeta();
                    tableMeta.setTableName(rs.getString("TABLE_NAME"));
                    tableMeta.setType(rs.getString("TABLE_TYPE"));
                    tableMeta.setRemarks(rs.getString("COMMENTS"));
                    tables.add(tableMeta);
                }
                this.setResult(tables);
            }
        });
    }

    public static boolean isAssignPKValue(PKStrategy pkStrategy) {
        return true;
    }
}

