/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.dialect.utils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import org.sagacity.sqltoy.SqlToyConstants;
import org.sagacity.sqltoy.config.model.EntityMeta;
import org.sagacity.sqltoy.config.model.FieldMeta;
import org.sagacity.sqltoy.config.model.PKStrategy;
import org.sagacity.sqltoy.model.IgnoreKeyCaseMap;
import org.sagacity.sqltoy.utils.DateUtil;
import org.sagacity.sqltoy.utils.ReservedWordsUtil;
import org.sagacity.sqltoy.utils.StringUtil;

public class DialectExtUtils {
    public static String generateInsertSql(Integer dbType, EntityMeta entityMeta, PKStrategy pkStrategy, String isNullFunction, String sequence, boolean isAssignPK, String tableName) {
        int columnSize = entityMeta.getFieldsArray().length;
        StringBuilder sql = new StringBuilder(columnSize * 20 + 30);
        StringBuilder values = new StringBuilder(columnSize * 2 - 1);
        sql.append("insert into ");
        sql.append(entityMeta.getSchemaTable(tableName, dbType));
        sql.append(" (");
        boolean isStart = true;
        boolean isSupportNULL = !StringUtil.isBlank(isNullFunction);
        boolean isString = false;
        for (int i = 0; i < columnSize; ++i) {
            String field = entityMeta.getFieldsArray()[i];
            FieldMeta fieldMeta = entityMeta.getFieldMeta(field);
            isString = false;
            if ("java.lang.string".equals(fieldMeta.getFieldType())) {
                isString = true;
            }
            String columnName = ReservedWordsUtil.convertWord(fieldMeta.getColumnName(), dbType);
            if (fieldMeta.isPK()) {
                if (pkStrategy.equals((Object)PKStrategy.IDENTITY)) {
                    if (!isAssignPK) continue;
                    if (!isStart) {
                        sql.append(",");
                        values.append(",");
                    }
                    sql.append(columnName);
                    values.append("?");
                    isStart = false;
                    continue;
                }
                if (pkStrategy.equals((Object)PKStrategy.SEQUENCE)) {
                    if (!isStart) {
                        sql.append(",");
                        values.append(",");
                    }
                    sql.append(columnName);
                    if (isAssignPK && isSupportNULL) {
                        values.append(isNullFunction);
                        values.append("(?,").append(sequence).append(")");
                    } else {
                        values.append(sequence);
                    }
                    isStart = false;
                    continue;
                }
                if (!isStart) {
                    sql.append(",");
                    values.append(",");
                }
                sql.append(columnName);
                values.append("?");
                isStart = false;
                continue;
            }
            if (!isStart) {
                sql.append(",");
                values.append(",");
            }
            sql.append(columnName);
            if (dbType == 160 && isString) {
                values.append("cast(? as string)");
            } else {
                values.append("?");
            }
            isStart = false;
        }
        sql.append(") ");
        sql.append(" values (");
        sql.append((CharSequence)values);
        sql.append(")");
        return sql.toString();
    }

    public static void processDefaultValue(StringBuilder sql, int dbType, FieldMeta fieldMeta, String defaultValue) {
        String fieldType = fieldMeta.getFieldType();
        if ("java.lang.string".equals(fieldType)) {
            if (!defaultValue.startsWith("'")) {
                sql.append("'");
            }
            sql.append(defaultValue);
            if (!defaultValue.endsWith("'")) {
                sql.append("'");
            }
        } else {
            String tmpValue = SqlToyConstants.getDefaultValue(dbType, defaultValue);
            if (tmpValue.startsWith("'") && tmpValue.endsWith("'")) {
                sql.append(tmpValue);
            } else if ("java.time.localdate".equals(fieldType) || "java.time.localdatetime".equals(fieldType) || "java.time.localtime".equals(fieldType) || "java.util.date".equals(fieldType) || "java.sql.date".equals(fieldType) || "java.sql.time".equals(fieldType) || "java.sql.timestamp".equals(fieldType)) {
                String dateStr = "'" + tmpValue + "'";
                if (dbType == 10 || dbType == 11 || dbType == 20) {
                    dateStr = "java.time.localtime".equals(fieldType) || "java.sql.time".equals(fieldType) ? (dbType == 20 ? "time(" + dateStr + ")" : "to_date(" + dateStr + ",'HH24:mi:ss')") : ("java.time.localdate".equals(fieldType) ? "to_date(" + dateStr + ",'yyyy-MM-dd')" : "to_date(" + dateStr + ",'yyyy-MM-dd HH24:mi:ss')");
                }
                sql.append(dateStr);
            } else {
                sql.append(tmpValue);
            }
        }
    }

    public static String wrapUniqueSql(EntityMeta entityMeta, String[] realParamNamed, Integer dbType, String tableName) {
        StringBuilder queryStr = new StringBuilder("select 1 ");
        if (null != entityMeta.getIdArray()) {
            for (String idFieldName : entityMeta.getIdArray()) {
                queryStr.append(",");
                queryStr.append(ReservedWordsUtil.convertWord(entityMeta.getColumnName(idFieldName), dbType));
            }
        }
        queryStr.append(" from ");
        queryStr.append(entityMeta.getSchemaTable(tableName, dbType));
        queryStr.append(" where  ");
        for (int i = 0; i < realParamNamed.length; ++i) {
            if (i > 0) {
                queryStr.append(" and ");
            }
            queryStr.append(ReservedWordsUtil.convertWord(entityMeta.getColumnName(realParamNamed[i]), dbType)).append("=? ");
        }
        return queryStr.toString();
    }

    public static String mergeIgnore(Integer dbType, EntityMeta entityMeta, PKStrategy pkStrategy, String fromTable, String isNullFunction, String sequence, boolean isAssignPK, String tableName) {
        boolean allIds;
        String columnName;
        String realTable = entityMeta.getSchemaTable(tableName, dbType);
        if (entityMeta.getIdArray() == null) {
            return DialectExtUtils.generateInsertSql(dbType, entityMeta, pkStrategy, isNullFunction, sequence, isAssignPK, realTable);
        }
        boolean isSupportNUL = !StringUtil.isBlank(isNullFunction);
        int columnSize = entityMeta.getFieldsArray().length;
        StringBuilder sql = new StringBuilder(columnSize * 30 + 100);
        sql.append("merge into ");
        sql.append(realTable);
        sql.append(" ta ");
        sql.append(" using (select ");
        for (int i = 0; i < columnSize; ++i) {
            columnName = entityMeta.getColumnName(entityMeta.getFieldsArray()[i]);
            columnName = ReservedWordsUtil.convertWord(columnName, dbType);
            if (i > 0) {
                sql.append(",");
            }
            sql.append("? as ");
            sql.append(columnName);
        }
        if (StringUtil.isNotBlank(fromTable)) {
            sql.append(" from ").append(fromTable);
        }
        sql.append(") tv on (");
        StringBuilder idColumns = new StringBuilder();
        int n = entityMeta.getIdArray().length;
        for (int i = 0; i < n; ++i) {
            columnName = entityMeta.getColumnName(entityMeta.getIdArray()[i]);
            columnName = ReservedWordsUtil.convertWord(columnName, dbType);
            if (i > 0) {
                sql.append(" and ");
                idColumns.append(",");
            }
            sql.append(" ta.").append(columnName).append("=tv.").append(columnName);
            idColumns.append("ta.").append(columnName);
        }
        sql.append(" ) ");
        StringBuilder insertRejIdCols = new StringBuilder();
        StringBuilder insertRejIdColValues = new StringBuilder();
        boolean bl = allIds = entityMeta.getRejectIdFieldArray() == null;
        if (!allIds) {
            int rejectIdColumnSize = entityMeta.getRejectIdFieldArray().length;
            for (int i = 0; i < rejectIdColumnSize; ++i) {
                FieldMeta fieldMeta = entityMeta.getFieldMeta(entityMeta.getRejectIdFieldArray()[i]);
                columnName = ReservedWordsUtil.convertWord(fieldMeta.getColumnName(), dbType);
                if (i > 0) {
                    insertRejIdCols.append(",");
                    insertRejIdColValues.append(",");
                }
                insertRejIdCols.append(columnName);
                insertRejIdColValues.append("tv.").append(columnName);
            }
        }
        sql.append(" when not matched then insert (");
        String idsColumnStr = idColumns.toString();
        if (allIds) {
            sql.append(idsColumnStr.replaceAll("ta.", ""));
            sql.append(") values (");
            sql.append(idsColumnStr.replaceAll("ta.", "tv."));
        } else {
            sql.append(insertRejIdCols.toString());
            if (pkStrategy.equals((Object)PKStrategy.SEQUENCE)) {
                columnName = entityMeta.getColumnName(entityMeta.getIdArray()[0]);
                columnName = ReservedWordsUtil.convertWord(columnName, dbType);
                sql.append(",");
                sql.append(columnName);
                sql.append(") values (");
                sql.append((CharSequence)insertRejIdColValues).append(",");
                if (isAssignPK && isSupportNUL) {
                    sql.append(isNullFunction);
                    sql.append("(tv.").append(columnName).append(",");
                    sql.append(sequence).append(") ");
                } else {
                    sql.append(sequence);
                }
            } else if (pkStrategy.equals((Object)PKStrategy.IDENTITY)) {
                columnName = entityMeta.getColumnName(entityMeta.getIdArray()[0]);
                columnName = ReservedWordsUtil.convertWord(columnName, dbType);
                if (isAssignPK) {
                    sql.append(",");
                    sql.append(columnName);
                }
                sql.append(") values (");
                sql.append((CharSequence)insertRejIdColValues);
                if (isAssignPK) {
                    sql.append(",").append("tv.").append(columnName);
                }
            } else {
                sql.append(",");
                sql.append(idsColumnStr.replaceAll("ta.", ""));
                sql.append(") values (");
                sql.append((CharSequence)insertRejIdColValues).append(",");
                sql.append(idsColumnStr.replaceAll("ta.", "tv."));
            }
        }
        sql.append(")");
        return sql.toString();
    }

    public static String insertIgnore(Integer dbType, EntityMeta entityMeta, PKStrategy pkStrategy, String isNullFunction, String sequence, boolean isAssignPK, String tableName) {
        String columnName;
        int i;
        int columnSize = entityMeta.getFieldsArray().length;
        StringBuilder sql = new StringBuilder(columnSize * 20 + 30);
        StringBuilder values = new StringBuilder(columnSize * 2 - 1);
        sql.append("insert into ");
        sql.append(entityMeta.getSchemaTable(tableName, dbType));
        sql.append(" (");
        boolean isStart = true;
        for (i = 0; i < columnSize; ++i) {
            String field = entityMeta.getFieldsArray()[i];
            FieldMeta fieldMeta = entityMeta.getFieldMeta(field);
            columnName = ReservedWordsUtil.convertWord(fieldMeta.getColumnName(), dbType);
            if (!isStart) {
                sql.append(",");
                values.append(",");
            }
            if (fieldMeta.isPK()) {
                if (pkStrategy.equals((Object)PKStrategy.IDENTITY)) {
                    if (!isAssignPK) continue;
                    sql.append(columnName);
                    values.append("?");
                    isStart = false;
                    continue;
                }
                if (pkStrategy.equals((Object)PKStrategy.SEQUENCE)) {
                    sql.append(columnName);
                    values.append(isNullFunction).append("(?,").append(sequence).append(")");
                    isStart = false;
                    continue;
                }
                sql.append(columnName);
                values.append("?");
                isStart = false;
                continue;
            }
            sql.append(columnName);
            values.append("?");
            isStart = false;
        }
        sql.append(") values ( ");
        sql.append((CharSequence)values);
        sql.append(")");
        if (entityMeta.getIdArray() != null) {
            sql.append(" ON CONFLICT (");
            int n = entityMeta.getIdArray().length;
            for (i = 0; i < n; ++i) {
                if (i > 0) {
                    sql.append(",");
                }
                columnName = entityMeta.getColumnName(entityMeta.getIdArray()[i]);
                sql.append(ReservedWordsUtil.convertWord(columnName, dbType));
            }
            sql.append(" ) DO NOTHING ");
        }
        return sql.toString();
    }

    public static String getInsertDefaultValue(IgnoreKeyCaseMap<String, Object> createUnifyFields, Integer dbType, FieldMeta fieldMeta) {
        if (createUnifyFields == null || createUnifyFields.isEmpty() || !createUnifyFields.containsKey(fieldMeta.getFieldName())) {
            return fieldMeta.getDefaultValue();
        }
        Object unifyFieldValue = createUnifyFields.get(fieldMeta.getFieldName());
        if (unifyFieldValue != null) {
            if (unifyFieldValue instanceof String) {
                return (String)unifyFieldValue;
            }
            if (unifyFieldValue instanceof Number) {
                return unifyFieldValue.toString();
            }
            String fieldType = fieldMeta.getFieldType();
            if ("java.time.localdate".equals(fieldType)) {
                return DateUtil.formatDate(unifyFieldValue, "yyyy-MM-dd");
            }
            if ("java.time.localtime".equals(fieldType) || "java.sql.time".equals(fieldType)) {
                return DateUtil.formatDate(unifyFieldValue, "HH:mm:ss");
            }
            if ("java.time.localdatetime".equals(fieldType) || "java.sql.timestamp".equals(fieldType) || "java.util.date".equals(fieldType) || "java.sql.date".equals(fieldType)) {
                return DateUtil.formatDate(unifyFieldValue, "yyyy-MM-dd HH:mm:ss");
            }
            if (unifyFieldValue instanceof Date || unifyFieldValue instanceof LocalDate || unifyFieldValue instanceof LocalDateTime) {
                if ("java.lang.integer".equals(fieldType) || "int".equals(fieldType)) {
                    return DateUtil.formatDate(unifyFieldValue, "yyyyMMdd");
                }
                if ("java.lang.long".equals(fieldType) || "java.math.biginteger".equals(fieldType) || "long".equals(fieldType)) {
                    return DateUtil.formatDate(unifyFieldValue, "yyyyMMddHHmmss");
                }
                if ("java.lang.string".equals(fieldType)) {
                    if (fieldMeta.getLength() >= 19) {
                        return DateUtil.formatDate(unifyFieldValue, "yyyy-MM-dd HH:mm:ss");
                    }
                    if (fieldMeta.getLength() >= 14) {
                        return DateUtil.formatDate(unifyFieldValue, "yyyyMMddHHmmss");
                    }
                    if (fieldMeta.getLength() >= 8) {
                        return DateUtil.formatDate(unifyFieldValue, "yyyyMMdd");
                    }
                }
            }
        }
        return fieldMeta.getDefaultValue();
    }
}

