/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.dialect.utils;

import java.sql.Connection;
import java.util.HashSet;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.callback.DecryptHandler;
import org.sagacity.sqltoy.config.model.EntityMeta;
import org.sagacity.sqltoy.config.model.FieldMeta;
import org.sagacity.sqltoy.config.model.OperateType;
import org.sagacity.sqltoy.config.model.PKStrategy;
import org.sagacity.sqltoy.config.model.SqlToyConfig;
import org.sagacity.sqltoy.config.model.SqlToyResult;
import org.sagacity.sqltoy.dialect.utils.DialectExtUtils;
import org.sagacity.sqltoy.dialect.utils.DialectUtils;
import org.sagacity.sqltoy.model.IgnoreKeyCaseMap;
import org.sagacity.sqltoy.model.QueryExecutor;
import org.sagacity.sqltoy.model.QueryResult;
import org.sagacity.sqltoy.model.inner.QueryExecutorExtend;
import org.sagacity.sqltoy.plugins.IUnifyFieldsHandler;
import org.sagacity.sqltoy.utils.ReservedWordsUtil;
import org.sagacity.sqltoy.utils.StringUtil;

public class DB2DialectUtils {
    public static QueryResult getRandomResult(SqlToyContext sqlToyContext, SqlToyConfig sqlToyConfig, QueryExecutor queryExecutor, DecryptHandler decryptHandler, Long totalCount, Long randomCount, Connection conn, Integer dbType, String dialect, int fetchSize, int maxRows) throws Exception {
        boolean hasOrderOrUnion;
        String innerSql = sqlToyConfig.isHasFast() ? sqlToyConfig.getFastSql(dialect) : sqlToyConfig.getSql(dialect);
        StringBuilder sql = new StringBuilder();
        if (sqlToyConfig.isHasFast()) {
            sql.append(sqlToyConfig.getFastPreSql(dialect));
            if (!sqlToyConfig.isIgnoreBracket()) {
                sql.append(" (");
            }
        }
        if (hasOrderOrUnion = DialectUtils.hasOrderByOrUnion(innerSql)) {
            sql.append("select sag_random_table.* from (");
        }
        sql.append(innerSql);
        if (hasOrderOrUnion) {
            sql.append(") sag_random_table ");
        }
        sql.append(" order by rand() fetch first ");
        sql.append(randomCount);
        sql.append(" rows only ");
        if (sqlToyConfig.isHasFast()) {
            if (!sqlToyConfig.isIgnoreBracket()) {
                sql.append(") ");
            }
            sql.append(sqlToyConfig.getFastTailSql(dialect));
        }
        SqlToyResult queryParam = DialectUtils.wrapPageSqlParams(sqlToyContext, sqlToyConfig, queryExecutor, sql.toString(), null, null, dialect);
        QueryExecutorExtend extend = queryExecutor.getInnerModel();
        queryParam = DialectUtils.doInterceptors(sqlToyContext, sqlToyConfig, extend.entityClass == null ? OperateType.random : OperateType.singleTable, queryParam, extend.entityClass, dbType);
        return DialectUtils.findBySql(sqlToyContext, sqlToyConfig, queryParam.getSql(), queryParam.getParamsValue(), extend, decryptHandler, conn, dbType, 0, fetchSize, maxRows);
    }

    public static String getSaveOrUpdateSql(IUnifyFieldsHandler unifyFieldsHandler, Integer dbType, EntityMeta entityMeta, PKStrategy pkStrategy, String[] forceUpdateFields, String fromTable, String isNullFunction, String sequence, boolean isAssignPK, String tableName) {
        boolean allIds;
        String columnName;
        FieldMeta fieldMeta;
        String realTable = entityMeta.getSchemaTable(tableName, dbType);
        if (entityMeta.getIdArray() == null) {
            return DialectExtUtils.generateInsertSql(dbType, entityMeta, pkStrategy, isNullFunction, sequence, isAssignPK, realTable);
        }
        IgnoreKeyCaseMap<String, Object> createUnifyFields = null;
        if (unifyFieldsHandler != null && unifyFieldsHandler.createUnifyFields() != null && !unifyFieldsHandler.createUnifyFields().isEmpty()) {
            createUnifyFields = new IgnoreKeyCaseMap<String, Object>();
            createUnifyFields.putAll(unifyFieldsHandler.createUnifyFields());
        }
        int columnSize = entityMeta.getFieldsArray().length;
        StringBuilder sql = new StringBuilder(columnSize * 30 + 100);
        sql.append("merge into ");
        sql.append(realTable);
        sql.append(" ta ");
        sql.append(" using (select ");
        for (int i = 0; i < columnSize; ++i) {
            fieldMeta = entityMeta.getFieldMeta(entityMeta.getFieldsArray()[i]);
            columnName = ReservedWordsUtil.convertWord(fieldMeta.getColumnName(), dbType);
            DB2DialectUtils.wrapSelectFields(sql, i, columnName, fieldMeta.getType(), fieldMeta.getLength());
        }
        if (StringUtil.isNotBlank(fromTable)) {
            sql.append(" from ").append(fromTable);
        }
        sql.append(") tv on (");
        StringBuilder idColumns = new StringBuilder();
        int n = entityMeta.getIdArray().length;
        for (int i = 0; i < n; ++i) {
            columnName = entityMeta.getColumnName(entityMeta.getIdArray()[i]);
            columnName = ReservedWordsUtil.convertWord(columnName, dbType);
            if (i > 0) {
                sql.append(" and ");
                idColumns.append(",");
            }
            sql.append(" ta.").append(columnName).append("=tv.").append(columnName);
            idColumns.append("ta.").append(columnName);
        }
        sql.append(" ) ");
        StringBuilder insertRejIdCols = new StringBuilder();
        StringBuilder insertRejIdColValues = new StringBuilder();
        boolean bl = allIds = entityMeta.getRejectIdFieldArray() == null;
        if (!allIds) {
            sql.append(" when matched then update set ");
            int rejectIdColumnSize = entityMeta.getRejectIdFieldArray().length;
            HashSet<String> fupc = new HashSet<String>();
            if (forceUpdateFields != null) {
                for (String field : forceUpdateFields) {
                    fupc.add(ReservedWordsUtil.convertWord(entityMeta.getColumnName(field), dbType));
                }
            }
            for (int i = 0; i < rejectIdColumnSize; ++i) {
                fieldMeta = entityMeta.getFieldMeta(entityMeta.getRejectIdFieldArray()[i]);
                columnName = ReservedWordsUtil.convertWord(fieldMeta.getColumnName(), dbType);
                if (i > 0) {
                    sql.append(",");
                    insertRejIdCols.append(",");
                    insertRejIdColValues.append(",");
                }
                sql.append(" ta.").append(columnName).append("=");
                if (fupc.contains(columnName)) {
                    sql.append("tv.").append(columnName);
                } else {
                    sql.append(isNullFunction);
                    sql.append("(tv.").append(columnName);
                    sql.append(",ta.").append(columnName);
                    sql.append(")");
                }
                insertRejIdCols.append(columnName);
                String defaultValue = DialectExtUtils.getInsertDefaultValue(createUnifyFields, dbType, fieldMeta);
                if (null != defaultValue) {
                    insertRejIdColValues.append(isNullFunction);
                    insertRejIdColValues.append("(tv.").append(columnName).append(",");
                    DialectExtUtils.processDefaultValue(insertRejIdColValues, dbType, fieldMeta, defaultValue);
                    insertRejIdColValues.append(")");
                    continue;
                }
                insertRejIdColValues.append("tv.").append(columnName);
            }
        }
        sql.append(" when not matched then insert (");
        String idsColumnStr = idColumns.toString();
        if (allIds) {
            sql.append(idsColumnStr.replaceAll("ta.", ""));
            sql.append(") values (");
            sql.append(idsColumnStr.replaceAll("ta.", "tv."));
        } else {
            sql.append(insertRejIdCols.toString());
            if (pkStrategy.equals((Object)PKStrategy.SEQUENCE)) {
                columnName = entityMeta.getColumnName(entityMeta.getIdArray()[0]);
                columnName = ReservedWordsUtil.convertWord(columnName, dbType);
                sql.append(",");
                sql.append(columnName);
                sql.append(") values (");
                sql.append((CharSequence)insertRejIdColValues).append(",");
                if (isAssignPK) {
                    sql.append(isNullFunction);
                    sql.append("(tv.").append(columnName).append(",");
                    sql.append(sequence).append(") ");
                } else {
                    sql.append(sequence);
                }
            } else if (pkStrategy.equals((Object)PKStrategy.IDENTITY)) {
                columnName = entityMeta.getColumnName(entityMeta.getIdArray()[0]);
                columnName = ReservedWordsUtil.convertWord(columnName, dbType);
                if (isAssignPK) {
                    sql.append(",");
                    sql.append(columnName);
                }
                sql.append(") values (");
                sql.append((CharSequence)insertRejIdColValues);
                if (isAssignPK) {
                    sql.append(",").append("tv.").append(columnName);
                }
            } else {
                sql.append(",");
                sql.append(idsColumnStr.replaceAll("ta.", ""));
                sql.append(") values (");
                sql.append((CharSequence)insertRejIdColValues).append(",");
                sql.append(idsColumnStr.replaceAll("ta.", "tv."));
            }
        }
        sql.append(")");
        return sql.toString();
    }

    public static String getSaveIgnoreExistSql(Integer dbType, EntityMeta entityMeta, PKStrategy pkStrategy, String fromTable, String isNullFunction, String sequence, boolean isAssignPK, String tableName) {
        boolean allIds;
        String columnName;
        FieldMeta fieldMeta;
        String realTable = entityMeta.getSchemaTable(tableName, dbType);
        if (entityMeta.getIdArray() == null) {
            return DialectExtUtils.generateInsertSql(dbType, entityMeta, pkStrategy, isNullFunction, sequence, isAssignPK, realTable);
        }
        int columnSize = entityMeta.getFieldsArray().length;
        StringBuilder sql = new StringBuilder(columnSize * 30 + 100);
        sql.append("merge into ");
        sql.append(realTable);
        sql.append(" ta ");
        sql.append(" using (select ");
        for (int i = 0; i < columnSize; ++i) {
            fieldMeta = entityMeta.getFieldMeta(entityMeta.getFieldsArray()[i]);
            columnName = ReservedWordsUtil.convertWord(fieldMeta.getColumnName(), dbType);
            DB2DialectUtils.wrapSelectFields(sql, i, columnName, fieldMeta.getType(), fieldMeta.getLength());
        }
        if (StringUtil.isNotBlank(fromTable)) {
            sql.append(" from ").append(fromTable);
        }
        sql.append(") tv on (");
        StringBuilder idColumns = new StringBuilder();
        int n = entityMeta.getIdArray().length;
        for (int i = 0; i < n; ++i) {
            columnName = entityMeta.getColumnName(entityMeta.getIdArray()[i]);
            columnName = ReservedWordsUtil.convertWord(columnName, dbType);
            if (i > 0) {
                sql.append(" and ");
                idColumns.append(",");
            }
            sql.append(" ta.").append(columnName).append("=tv.").append(columnName);
            idColumns.append("ta.").append(columnName);
        }
        sql.append(" ) ");
        StringBuilder insertRejIdCols = new StringBuilder();
        StringBuilder insertRejIdColValues = new StringBuilder();
        boolean bl = allIds = entityMeta.getRejectIdFieldArray() == null;
        if (!allIds) {
            int rejectIdColumnSize = entityMeta.getRejectIdFieldArray().length;
            for (int i = 0; i < rejectIdColumnSize; ++i) {
                fieldMeta = entityMeta.getFieldMeta(entityMeta.getRejectIdFieldArray()[i]);
                columnName = ReservedWordsUtil.convertWord(fieldMeta.getColumnName(), dbType);
                if (i > 0) {
                    insertRejIdCols.append(",");
                    insertRejIdColValues.append(",");
                }
                insertRejIdCols.append(columnName);
                insertRejIdColValues.append("tv.").append(columnName);
            }
        }
        sql.append(" when not matched then insert (");
        String idsColumnStr = idColumns.toString();
        if (allIds) {
            sql.append(idsColumnStr.replaceAll("ta.", ""));
            sql.append(") values (");
            sql.append(idsColumnStr.replaceAll("ta.", "tv."));
        } else {
            sql.append(insertRejIdCols.toString());
            if (pkStrategy.equals((Object)PKStrategy.SEQUENCE)) {
                columnName = entityMeta.getColumnName(entityMeta.getIdArray()[0]);
                columnName = ReservedWordsUtil.convertWord(columnName, dbType);
                sql.append(",");
                sql.append(columnName);
                sql.append(") values (");
                sql.append((CharSequence)insertRejIdColValues).append(",");
                if (isAssignPK) {
                    sql.append(isNullFunction);
                    sql.append("(tv.").append(columnName).append(",");
                    sql.append(sequence).append(") ");
                } else {
                    sql.append(sequence);
                }
            } else if (pkStrategy.equals((Object)PKStrategy.IDENTITY)) {
                columnName = entityMeta.getColumnName(entityMeta.getIdArray()[0]);
                columnName = ReservedWordsUtil.convertWord(columnName, dbType);
                if (isAssignPK) {
                    sql.append(",");
                    sql.append(columnName);
                }
                sql.append(") values (");
                sql.append((CharSequence)insertRejIdColValues);
                if (isAssignPK) {
                    sql.append(",").append("tv.").append(columnName);
                }
            } else {
                sql.append(",");
                sql.append(idsColumnStr.replaceAll("ta.", ""));
                sql.append(") values (");
                sql.append((CharSequence)insertRejIdColValues).append(",");
                sql.append(idsColumnStr.replaceAll("ta.", "tv."));
            }
        }
        sql.append(")");
        return sql.toString();
    }

    private static void wrapSelectFields(StringBuilder sql, int index, String columnName, int fieldType, int length) {
        if (index > 0) {
            sql.append(",");
        }
        if (fieldType == 12) {
            sql.append("cast(? as varchar(" + length + "))");
        } else if (fieldType == 1) {
            sql.append("cast(? as char(" + length + "))");
        } else if (fieldType == 91) {
            sql.append("cast(? as date)");
        } else if (fieldType == 2) {
            sql.append("cast(? as numeric)");
        } else if (fieldType == 3) {
            sql.append("cast(? as decimal)");
        } else if (fieldType == 4 || fieldType == -5 || fieldType == -6) {
            sql.append("cast(? as integer)");
        } else if (fieldType == 93) {
            sql.append("cast(? as timestamp)");
        } else if (fieldType == 8) {
            sql.append("cast(? as double)");
        } else if (fieldType == 6) {
            sql.append("cast(? as float)");
        } else if (fieldType == 92) {
            sql.append("cast(? as time)");
        } else if (fieldType == 2005) {
            sql.append("cast(? as clob(" + length + "))");
        } else if (fieldType == 16) {
            sql.append("cast(? as boolean)");
        } else if (fieldType == -2) {
            sql.append("cast(? as BINARY LARGE OBJECT(" + length + "))");
        } else if (fieldType == 2004) {
            sql.append("cast(? as blob(" + length + "))");
        } else {
            sql.append("?");
        }
        sql.append(" as ");
        sql.append(columnName);
    }
}

