/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sagacity.sqltoy.config.model.SqlExecuteLog;
import org.sagacity.sqltoy.config.model.SqlExecuteTrace;
import org.sagacity.sqltoy.model.OverTimeSql;
import org.sagacity.sqltoy.plugins.OverTimeSqlHandler;
import org.sagacity.sqltoy.utils.DateUtil;
import org.sagacity.sqltoy.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlExecuteStat {
    private static final Logger logger = LoggerFactory.getLogger(SqlExecuteStat.class);
    private static boolean debug = false;
    private static int printSqlTimeoutMillis = 18000;
    private static final Pattern ARG_PATTERN = Pattern.compile("\\W\\?\\W");
    private static ThreadLocal<SqlExecuteTrace> threadLocal = new InheritableThreadLocal<SqlExecuteTrace>();
    public static OverTimeSqlHandler overTimeSqlHandler;

    public static void start(String sqlId, String type, Boolean debugPrint) {
        threadLocal.set(new SqlExecuteTrace(sqlId, type, debugPrint == null ? debug : debugPrint));
    }

    public static void error(Exception exception) {
        if (threadLocal.get() != null) {
            threadLocal.get().setError(exception.getMessage());
        }
    }

    public static void showSql(String topic, String sql, Object[] paramValues) {
        try {
            if (threadLocal.get() != null) {
                threadLocal.get().addSqlLog(topic, sql, paramValues);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setDialect(String dialect) {
        if (threadLocal.get() != null) {
            threadLocal.get().setDialect(dialect);
        }
    }

    public static void debug(String topic, String message, Object ... args) {
        try {
            if (threadLocal.get() != null) {
                threadLocal.get().addLog(topic, message, args);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void destroyLog() {
        try {
            SqlExecuteTrace sqlTrace = threadLocal.get();
            if (sqlTrace == null) {
                return;
            }
            long runTime = sqlTrace.getExecuteTime();
            long overTime = runTime - (long)printSqlTimeoutMillis;
            if (overTime >= 0L) {
                sqlTrace.setOverTime(true);
                sqlTrace.addLog("slowSql\u6267\u884c\u8d85\u65f6", "\u8017\u65f6(\u6beb\u79d2):{} >={} (\u9600\u503c)!", runTime, printSqlTimeoutMillis);
            } else {
                sqlTrace.addLog("\u6267\u884c\u603b\u65f6\u957f", "\u8017\u65f6:{} \u6beb\u79d2 !", runTime);
            }
            SqlExecuteStat.printLogs(sqlTrace);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void printLogs(SqlExecuteTrace sqlTrace) {
        boolean errorLog = false;
        String reportStatus = "\u6210\u529f!";
        if (sqlTrace.isOverTime()) {
            errorLog = true;
            reportStatus = "\u6267\u884c\u8017\u65f6\u8d85\u9600\u503c!";
        }
        if (sqlTrace.isError()) {
            errorLog = true;
            reportStatus = "\u53d1\u751f\u5f02\u5e38\u9519\u8bef!";
        }
        if (!errorLog && !sqlTrace.isPrint()) {
            return;
        }
        String uid = sqlTrace.getUid();
        StringBuilder result = new StringBuilder();
        String optType = sqlTrace.getType();
        String codeTrace = SqlExecuteStat.getFirstTrace();
        result.append("\n/*|----------------------\u5f00\u59cb\u6267\u884c\u62a5\u544a\u8f93\u51fa --------------------------------------------------*/");
        result.append("\n/*|\u4efb \u52a1 ID: " + uid);
        result.append("\n/*|\u6267\u884c\u7ed3\u679c: " + reportStatus);
        result.append("\n/*|\u6570\u636e\u65b9\u8a00: " + sqlTrace.getDialect());
        result.append("\n/*|\u6267\u884c\u7c7b\u578b: " + optType);
        result.append("\n/*|\u4ee3\u7801\u5b9a\u4f4d: " + codeTrace);
        if (sqlTrace.getId() != null) {
            result.append("\n/*|\u5bf9\u5e94sqlId: " + sqlTrace.getId());
        }
        List<SqlExecuteLog> executeLogs = sqlTrace.getExecuteLogs();
        int step = 0;
        Object[] args = null;
        String sql = null;
        for (SqlExecuteLog log : executeLogs) {
            ++step;
            int logType = log.getType();
            String topic = log.getTopic();
            String content = log.getContent();
            args = log.getArgs();
            if (logType == 0) {
                result.append("\n/*|---- \u8fc7\u7a0b: " + step + "," + topic + "----------------");
                if (optType.startsWith("save") || optType.startsWith("deleteAll") || optType.startsWith("batchUpdate")) {
                    result.append("\n/*|     \u5185\u90e8sql: ").append(SqlExecuteStat.fitSqlParams(content, args));
                    result.append("\n/*|     save(All)|saveOrUpdate(All)|deleleAll|batchUpdate\u7b49\u4e0d\u8f93\u51fasql\u6267\u884c\u53c2\u6570");
                    continue;
                }
                sql = SqlExecuteStat.fitSqlParams(content, args);
                result.append("\n/*|     \u6a21\u62df\u5165\u53c2\u540esql: ").append(sql);
                result.append("\n/*|     sql\u53c2\u6570: ");
                if (args != null && args.length > 0) {
                    StringBuilder paramStr = new StringBuilder();
                    for (int i = 0; i < args.length; ++i) {
                        if (i > 0) {
                            paramStr.append(",");
                        }
                        paramStr.append("p[" + i + "]=" + args[i]);
                    }
                    result.append((CharSequence)paramStr);
                    continue;
                }
                result.append("\u65e0\u53c2\u6570");
                continue;
            }
            result.append("\n/*|---- \u8fc7\u7a0b: " + step + "," + (null == topic ? "" : topic) + (String)(null == content ? "" : ":" + StringUtil.fillArgs(content, args)));
        }
        result.append("\n/*|----------------------\u5b8c\u6210\u6267\u884c\u62a5\u544a\u8f93\u51fa --------------------------------------------------*/");
        result.append("\n");
        if (sqlTrace.isError()) {
            logger.error(result.toString());
        } else if (sqlTrace.isOverTime()) {
            logger.warn(result.toString());
            if (overTimeSqlHandler != null) {
                overTimeSqlHandler.log(new OverTimeSql(sqlTrace.getId(), sql, sqlTrace.getExecuteTime(), codeTrace));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug(result.toString());
        } else {
            System.out.println(result.toString());
        }
    }

    public static void destroy() {
        SqlExecuteStat.destroyLog();
        threadLocal.remove();
        threadLocal.set(null);
    }

    public static void setDebug(boolean debug) {
        SqlExecuteStat.debug = debug;
    }

    public static void setOverTimeSqlHandler(OverTimeSqlHandler overTimeSqlHandler) {
        SqlExecuteStat.overTimeSqlHandler = overTimeSqlHandler;
    }

    public static void setPrintSqlTimeoutMillis(int printSqlTimeoutMillis) {
        SqlExecuteStat.printSqlTimeoutMillis = printSqlTimeoutMillis;
    }

    private static String fitSqlParams(String sql, Object[] params) {
        if (sql == null || params == null || params.length == 0) {
            return sql;
        }
        StringBuilder lastSql = new StringBuilder();
        Matcher matcher = ARG_PATTERN.matcher(sql.concat(" "));
        int start = 0;
        int index = 0;
        int paramSize = params.length;
        while (matcher.find(start)) {
            int end = matcher.start() + 1;
            lastSql.append(sql.substring(start, end));
            if (index < paramSize) {
                Object paramValue = params[index];
                if (paramValue instanceof CharSequence) {
                    lastSql.append("'" + paramValue + "'");
                } else if (paramValue instanceof Timestamp) {
                    lastSql.append("'" + DateUtil.formatDate(paramValue, "yyyy-MM-dd HH:mm:ss.SSS") + "'");
                } else if (paramValue instanceof Date || paramValue instanceof LocalDateTime) {
                    lastSql.append("'" + DateUtil.formatDate(paramValue, "yyyy-MM-dd HH:mm:ss") + "'");
                } else if (paramValue instanceof LocalDate) {
                    lastSql.append("'" + DateUtil.formatDate(paramValue, "yyyy-MM-dd") + "'");
                } else if (paramValue instanceof LocalTime) {
                    lastSql.append("'" + DateUtil.formatDate(paramValue, "HH:mm:ss") + "'");
                } else if (paramValue instanceof Object[]) {
                    lastSql.append(SqlExecuteStat.combineArray((Object[])paramValue));
                } else if (paramValue instanceof Collection) {
                    lastSql.append(SqlExecuteStat.combineArray(((Collection)paramValue).toArray()));
                } else {
                    lastSql.append("" + paramValue);
                }
            } else {
                return sql;
            }
            start = matcher.end() - 1;
            ++index;
        }
        lastSql.append(sql.substring(start));
        return lastSql.toString();
    }

    private static String combineArray(Object[] array) {
        if (array == null || array.length == 0) {
            return " null ";
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            Object value;
            if (i > 0) {
                result.append(",");
            }
            if ((value = array[i]) instanceof CharSequence) {
                result.append("'" + value + "'");
                continue;
            }
            if (value instanceof Timestamp) {
                result.append("'" + DateUtil.formatDate(value, "yyyy-MM-dd HH:mm:ss.SSS") + "'");
                continue;
            }
            if (value instanceof Date || value instanceof LocalDateTime) {
                result.append("'" + DateUtil.formatDate(value, "yyyy-MM-dd HH:mm:ss") + "'");
                continue;
            }
            if (value instanceof LocalDate) {
                result.append("'" + DateUtil.formatDate(value, "yyyy-MM-dd") + "'");
                continue;
            }
            if (value instanceof LocalTime) {
                result.append("'" + DateUtil.formatDate(value, "HH:mm:ss") + "'");
                continue;
            }
            result.append("" + value);
        }
        return result.toString();
    }

    public static String getFirstTrace() {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        String className = null;
        int lineNumber = 0;
        String method = null;
        int length = stackTraceElements.length;
        for (int i = length - 1; i > 0; --i) {
            StackTraceElement traceElement = stackTraceElements[i];
            className = traceElement.getClassName();
            if (!className.startsWith("org.sagacity.sqltoy")) continue;
            method = traceElement.getMethodName();
            lineNumber = traceElement.getLineNumber();
            if (i + 1 >= length) break;
            traceElement = stackTraceElements[i + 1];
            className = traceElement.getClassName();
            method = traceElement.getMethodName();
            lineNumber = traceElement.getLineNumber();
            break;
        }
        return className + "." + method + "[\u4ee3\u7801\u7b2c:" + lineNumber + " \u884c]";
    }

    public static Long getExecuteTime() {
        SqlExecuteTrace sqlTrace = threadLocal.get();
        if (sqlTrace != null) {
            return sqlTrace.getExecuteTime();
        }
        return -1L;
    }

    public static SqlExecuteTrace get() {
        return threadLocal.get();
    }

    public static void set(SqlExecuteTrace sqlTrace) {
        threadLocal.set(sqlTrace);
    }
}

