/*
 * Decompiled with CFR 0.152.
 */
package com.ruishanio;

import com.ruishanio.Base62;
import com.ruishanio.KsuidComponents;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;

public class Ksuid {
    private static final int EPOCH = 1400000000;
    private static final int TIMESTAMP_LENGTH = 4;
    private static final int PAYLOAD_LENGTH = 16;
    private static final int MAX_ENCODED_LENGTH = 27;
    private static SecureRandom random;

    public Ksuid() {
        random = new SecureRandom();
    }

    public String generate() throws IOException {
        KsuidGenerator uid = new KsuidGenerator(random);
        return uid.nextId();
    }

    public String generate(int timestamp) throws IOException {
        KsuidGenerator uid = new KsuidGenerator(random);
        byte[] ts = ByteBuffer.allocate(4).putInt(timestamp - 1400000000).array();
        return uid.nextId(ts);
    }

    public String print(String ksuid) {
        KsuidParser parser = new KsuidParser();
        return parser.print(ksuid);
    }

    public KsuidComponents parse(String ksuid) {
        KsuidParser parser = new KsuidParser();
        return parser.parse(ksuid);
    }

    class KsuidParser {
        KsuidParser() {
        }

        private long decodeTimestamp(byte[] decodedKsuid) {
            byte[] timestamp = new byte[4];
            System.arraycopy(decodedKsuid, 0, timestamp, 0, 4);
            return ByteBuffer.wrap(timestamp).getInt() + 1400000000;
        }

        private byte[] decodePayload(byte[] decodedKsuid) {
            byte[] payload = new byte[16];
            System.arraycopy(decodedKsuid, 4, payload, 0, decodedKsuid.length - 4);
            return payload;
        }

        String print(String ksuid) {
            KsuidComponents ksuidComponents = this.parse(ksuid);
            ZonedDateTime utc = Instant.ofEpochSecond(ksuidComponents.getTimestamp()).atZone(ZoneId.of("UTC"));
            return String.format("Time: %s\nTimestamp: %d\nPayload: %s", utc, ksuidComponents.getTimestamp(), Arrays.toString(ksuidComponents.getPayload()));
        }

        KsuidComponents parse(String ksuid) {
            Base62 base62 = Base62.createInstance();
            byte[] buffer = base62.decode(ksuid.getBytes());
            long timestamp = this.decodeTimestamp(buffer);
            byte[] payload = this.decodePayload(buffer);
            return new KsuidComponents(ksuid, timestamp, payload);
        }
    }

    class KsuidGenerator {
        private final SecureRandom random;

        KsuidGenerator(SecureRandom random) {
            this.random = random;
        }

        private byte[] makeTimestamp() {
            long utc = ZonedDateTime.now(ZoneOffset.UTC).toInstant().toEpochMilli() / 1000L;
            int timestamp = (int)(utc - 1400000000L);
            return ByteBuffer.allocate(4).putInt(timestamp).array();
        }

        private byte[] makePayload() {
            byte[] bytes = new byte[16];
            this.random.nextBytes(bytes);
            return bytes;
        }

        String nextId() throws IOException, RuntimeException {
            return this.nextId(this.makeTimestamp());
        }

        String nextId(byte[] timestamp) throws IOException, RuntimeException {
            byte[] payload = this.makePayload();
            Base62 base62 = Base62.createInstance();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            output.write(timestamp);
            output.write(payload);
            String uid = new String(base62.encode(output.toByteArray()));
            if (uid.length() > 27) {
                return uid.substring(0, 27);
            }
            return uid;
        }
    }
}

