/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.spatial.jts;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.spatial.SpatialOps;
import com.querydsl.spatial.jts.JTSGeometryCollectionExpression;
import com.querydsl.spatial.jts.JTSGeometryExpressions;
import com.querydsl.spatial.jts.JTSPointExpression;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.Point;
import javax.annotation.Nullable;

public abstract class JTSMultiSurfaceExpression<T extends GeometryCollection>
extends JTSGeometryCollectionExpression<T> {
    private static final long serialVersionUID = 4133386816772862010L;
    @Nullable
    private volatile transient JTSPointExpression<Point> centroid;
    @Nullable
    private volatile transient JTSPointExpression<Point> pointOnSurface;
    @Nullable
    private volatile transient NumberExpression<Double> area;

    public JTSMultiSurfaceExpression(Expression<T> mixin) {
        super(mixin);
    }

    public NumberExpression<Double> area() {
        if (this.area == null) {
            this.area = Expressions.numberOperation(Double.class, (Operator)SpatialOps.AREA, (Expression[])new Expression[]{this.mixin});
        }
        return this.area;
    }

    public JTSPointExpression<Point> centroid() {
        if (this.centroid == null) {
            this.centroid = JTSGeometryExpressions.pointOperation(SpatialOps.CENTROID, this.mixin);
        }
        return this.centroid;
    }

    public JTSPointExpression<Point> pointOnSurface() {
        if (this.pointOnSurface == null) {
            this.pointOnSurface = JTSGeometryExpressions.pointOperation(SpatialOps.POINT_ON_SURFACE, this.mixin);
        }
        return this.pointOnSurface;
    }
}

