/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa.impl;

import com.google.common.collect.Maps;
import com.querydsl.jpa.BatooTemplates;
import com.querydsl.jpa.DataNucleusTemplates;
import com.querydsl.jpa.EclipseLinkTemplates;
import com.querydsl.jpa.HQLTemplates;
import com.querydsl.jpa.JPQLTemplates;
import com.querydsl.jpa.OpenJPATemplates;
import java.util.Map;
import javax.persistence.EntityManager;

public final class JPAProvider {
    private static final Map<Class<?>, JPQLTemplates> mappings = Maps.newHashMap();
    private static final Map<String, JPQLTemplates> templatesByName = Maps.newHashMap();

    private static void addMapping(String className, JPQLTemplates templates) {
        try {
            mappings.put(Class.forName(className), templates);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static JPQLTemplates getTemplates(EntityManager em) {
        for (Map.Entry<Class<?>, JPQLTemplates> entry : mappings.entrySet()) {
            if (!entry.getKey().isAssignableFrom(em.getDelegate().getClass())) continue;
            return entry.getValue();
        }
        for (String key : em.getEntityManagerFactory().getProperties().keySet()) {
            key = key.toLowerCase();
            for (Map.Entry<String, JPQLTemplates> entry : templatesByName.entrySet()) {
                if (!key.contains(entry.getKey())) continue;
                return entry.getValue();
            }
        }
        return JPQLTemplates.DEFAULT;
    }

    private JPAProvider() {
    }

    static {
        JPAProvider.addMapping("org.batoo.jpa.core.impl.manager.EntityManagerImpl", BatooTemplates.DEFAULT);
        JPAProvider.addMapping("org.hibernate.Session", HQLTemplates.DEFAULT);
        JPAProvider.addMapping("org.hibernate.ejb.HibernateEntityManager", HQLTemplates.DEFAULT);
        JPAProvider.addMapping("org.eclipse.persistence.jpa.JpaEntityManager", EclipseLinkTemplates.DEFAULT);
        JPAProvider.addMapping("org.apache.openjpa.persistence.OpenJPAEntityManager", OpenJPATemplates.DEFAULT);
        JPAProvider.addMapping("org.datanucleus.jpa.EntityManagerImpl", DataNucleusTemplates.DEFAULT);
        JPAProvider.addMapping("org.datanucleus.ObjectManager", DataNucleusTemplates.DEFAULT);
        JPAProvider.addMapping("org.datanucleus.ObjectManagerImpl", DataNucleusTemplates.DEFAULT);
        templatesByName.put("batoo", BatooTemplates.DEFAULT);
        templatesByName.put("eclipselink", EclipseLinkTemplates.DEFAULT);
        templatesByName.put("hibernate", HQLTemplates.DEFAULT);
        templatesByName.put("openjpa", OpenJPATemplates.DEFAULT);
        templatesByName.put("datanucleus", DataNucleusTemplates.DEFAULT);
    }
}

