/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.MethodType;
import com.qiniu.storage.ApiUpload;
import com.qiniu.storage.ApiUtils;

public class ApiUploadV1MakeBlock
extends ApiUpload {
    public ApiUploadV1MakeBlock(Client client) {
        super(client);
    }

    public Response request(Request request) throws QiniuException {
        return new Response(this.requestByClient(request));
    }

    public static class Response
    extends ApiUpload.Response {
        protected Response(com.qiniu.http.Response response) throws QiniuException {
            super(response);
        }

        public String getCtx() {
            return this.getStringValueFromDataMap("ctx");
        }

        public String getChecksum() {
            return this.getStringValueFromDataMap("checksum");
        }

        public Long getOffset() {
            return this.getLongValueFromDataMap("offset");
        }

        public String getHost() {
            return this.getStringValueFromDataMap("host");
        }

        public Long getCrc32() {
            return this.getLongValueFromDataMap("crc32");
        }

        public Long getExpiredAt() {
            return this.getLongValueFromDataMap("expired_at");
        }
    }

    public static class Request
    extends ApiUpload.Request {
        private Integer blockSize;

        public Request(String urlPrefix, String token, Integer blockSize) {
            super(urlPrefix);
            this.setToken(token);
            this.setMethod(MethodType.POST);
            this.blockSize = blockSize;
        }

        public Request setFirstChunkData(byte[] data, int offset, int size, String contentType) {
            super.setBody(data, offset, size, contentType);
            return this;
        }

        @Override
        protected void buildPath() throws QiniuException {
            if (this.blockSize == null) {
                ApiUtils.throwInvalidRequestParamException("block size");
            }
            this.addPathSegment("mkblk");
            this.addPathSegment(this.blockSize + "");
            super.buildPath();
        }

        @Override
        protected void buildBodyInfo() throws QiniuException {
            if (!this.hasBody()) {
                ApiUtils.throwInvalidRequestParamException("block data");
            }
        }
    }
}

