/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.checks.AbstractOptionCheck;
import com.puppycrawl.tools.checkstyle.checks.whitespace.PadOption;

abstract class AbstractParenPadCheck
extends AbstractOptionCheck<PadOption> {
    public static final String WS_FOLLOWED = "ws.followed";
    public static final String WS_NOT_FOLLOWED = "ws.notFollowed";
    public static final String WS_PRECEDED = "ws.preceded";
    public static final String WS_NOT_PRECEDED = "ws.notPreceded";

    AbstractParenPadCheck() {
        super(PadOption.NOSPACE, PadOption.class);
    }

    protected void processLeft(DetailAST ast) {
        String line = this.getLines()[ast.getLineNo() - 1];
        int after = ast.getColumnNo() + 1;
        if (after < line.length()) {
            if (PadOption.NOSPACE == this.getAbstractOption() && Character.isWhitespace(line.charAt(after))) {
                this.log(ast.getLineNo(), after, WS_FOLLOWED, "(");
            } else if (PadOption.SPACE == this.getAbstractOption() && !Character.isWhitespace(line.charAt(after)) && line.charAt(after) != ')') {
                this.log(ast.getLineNo(), after, WS_NOT_FOLLOWED, "(");
            }
        }
    }

    protected void processRight(DetailAST ast) {
        String line = this.getLines()[ast.getLineNo() - 1];
        int before = ast.getColumnNo() - 1;
        if (before >= 0) {
            if (PadOption.NOSPACE == this.getAbstractOption() && Character.isWhitespace(line.charAt(before)) && !Utils.whitespaceBefore(before, line)) {
                this.log(ast.getLineNo(), before, WS_PRECEDED, ")");
            } else if (PadOption.SPACE == this.getAbstractOption() && !Character.isWhitespace(line.charAt(before)) && line.charAt(before) != '(') {
                this.log(ast.getLineNo(), ast.getColumnNo(), WS_NOT_PRECEDED, ")");
            }
        }
    }
}

