/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FastStack;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.api.LocalizedMessage;
import com.puppycrawl.tools.checkstyle.checks.ClassResolver;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@Deprecated
public abstract class AbstractTypeAwareCheck
extends Check {
    private final Set<String> imports = Sets.newHashSet();
    private FullIdent packageFullIdent;
    private String currentClass;
    private ClassResolver classResolver;
    private final FastStack<Map<String, ClassInfo>> typeParams = FastStack.newInstance();
    private boolean logLoadErrors = true;
    private boolean suppressLoadErrors;

    public final void setLogLoadErrors(boolean logLoadErrors) {
        this.logLoadErrors = logLoadErrors;
    }

    public final void setSuppressLoadErrors(boolean suppressLoadErrors) {
        this.suppressLoadErrors = suppressLoadErrors;
    }

    protected abstract void processAST(DetailAST var1);

    @Override
    public final int[] getRequiredTokens() {
        return new int[]{16, 30, 14, 15, 154};
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.packageFullIdent = FullIdent.createFullIdent(null);
        this.imports.clear();
        this.imports.add("java.lang.*");
        this.classResolver = null;
        this.currentClass = "";
        this.typeParams.clear();
    }

    @Override
    public final void visitToken(DetailAST ast) {
        if (ast.getType() == 16) {
            this.processPackage(ast);
        } else if (ast.getType() == 30) {
            this.processImport(ast);
        } else if (ast.getType() == 14 || ast.getType() == 15 || ast.getType() == 154) {
            this.processClass(ast);
        } else {
            if (ast.getType() == 9) {
                this.processTypeParams(ast);
            }
            this.processAST(ast);
        }
    }

    @Override
    public final void leaveToken(DetailAST ast) {
        if (ast.getType() == 14 || ast.getType() == 154) {
            int dotIdx = this.currentClass.lastIndexOf("$");
            if (dotIdx == -1) {
                dotIdx = this.currentClass.lastIndexOf(".");
            }
            this.currentClass = dotIdx == -1 ? "" : this.currentClass.substring(0, dotIdx);
            this.typeParams.pop();
        } else if (ast.getType() == 9) {
            this.typeParams.pop();
        } else if (ast.getType() != 16 && ast.getType() != 30) {
            this.leaveAST(ast);
        }
    }

    protected void leaveAST(DetailAST ast) {
    }

    protected boolean isUnchecked(Class<?> exception) {
        return this.isSubclass(exception, RuntimeException.class) || this.isSubclass(exception, Error.class);
    }

    protected boolean isSubclass(Class<?> child, Class<?> parent) {
        return parent != null && child != null && parent.isAssignableFrom(child);
    }

    private ClassResolver getClassResolver() {
        if (this.classResolver == null) {
            this.classResolver = new ClassResolver(this.getClassLoader(), this.packageFullIdent.getText(), this.imports);
        }
        return this.classResolver;
    }

    protected final Class<?> resolveClass(String className, String currentClass) {
        try {
            return this.getClassResolver().resolve(className, currentClass);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    protected final Class<?> tryLoadClass(Token ident, String currentClass) {
        Class<?> clazz = this.resolveClass(ident.getText(), currentClass);
        if (clazz == null) {
            this.logLoadError(ident);
        }
        return clazz;
    }

    protected abstract void logLoadError(Token var1);

    protected final void logLoadErrorImpl(int lineNo, int columnNo, String msgKey, Object ... values) {
        if (!this.logLoadErrors) {
            LocalizedMessage msg = new LocalizedMessage(lineNo, columnNo, this.getMessageBundle(), msgKey, values, this.getSeverityLevel(), this.getId(), this.getClass(), null);
            throw new RuntimeException(msg.getMessage());
        }
        if (!this.suppressLoadErrors) {
            this.log(lineNo, columnNo, msgKey, values);
        }
    }

    private void processPackage(DetailAST ast) {
        DetailAST nameAST = ast.getLastChild().getPreviousSibling();
        this.packageFullIdent = FullIdent.createFullIdent(nameAST);
    }

    private void processImport(DetailAST ast) {
        FullIdent name = FullIdent.createFullIdentBelow(ast);
        if (name != null) {
            this.imports.add(name.getText());
        }
    }

    private void processTypeParams(DetailAST ast) {
        DetailAST params = ast.findFirstToken(165);
        HashMap paramsMap = Maps.newHashMap();
        this.typeParams.push(paramsMap);
        if (params == null) {
            return;
        }
        for (DetailAST child = params.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getType() != 166) continue;
            DetailAST param = child;
            String alias = param.findFirstToken(58).getText();
            DetailAST bounds = param.findFirstToken(168);
            if (bounds == null) continue;
            FullIdent name = FullIdent.createFullIdentBelow(bounds);
            ClassInfo ci = this.createClassInfo(new Token(name), this.getCurrentClassName());
            paramsMap.put(alias, ci);
        }
    }

    private void processClass(DetailAST ast) {
        DetailAST ident = ast.findFirstToken(58);
        this.currentClass = this.currentClass + ("".equals(this.currentClass) ? "" : "$") + ident.getText();
        this.processTypeParams(ast);
    }

    protected final String getCurrentClassName() {
        return this.currentClass;
    }

    protected final ClassInfo createClassInfo(Token name, String surroundingClass) {
        ClassInfo ci = this.findClassAlias(name.getText());
        if (ci != null) {
            return new ClassAlias(name, ci);
        }
        return new RegularClass(name, surroundingClass, this);
    }

    protected final ClassInfo findClassAlias(String name) {
        Map<String, ClassInfo> paramMap;
        ClassInfo ci = null;
        for (int i = this.typeParams.size() - 1; i >= 0 && (ci = (paramMap = this.typeParams.peek(i)).get(name)) == null; --i) {
        }
        return ci;
    }

    protected static class Token {
        private final int column;
        private final int line;
        private final String text;

        public Token(String text, int line, int column) {
            this.text = text;
            this.line = line;
            this.column = column;
        }

        public Token(FullIdent fullIdent) {
            this.text = fullIdent.getText();
            this.line = fullIdent.getLineNo();
            this.column = fullIdent.getColumnNo();
        }

        public int getLineNo() {
            return this.line;
        }

        public int getColumnNo() {
            return this.column;
        }

        public String getText() {
            return this.text;
        }

        public String toString() {
            return "Token[" + this.getText() + "(" + this.getLineNo() + "x" + this.getColumnNo() + ")]";
        }
    }

    private static class ClassAlias
    extends ClassInfo {
        private final ClassInfo classInfo;

        ClassAlias(Token name, ClassInfo classInfo) {
            super(name);
            this.classInfo = classInfo;
        }

        @Override
        public final Class<?> getClazz() {
            return this.classInfo.getClazz();
        }

        public String toString() {
            return "ClassAlias[alias " + this.getName() + " for " + this.classInfo + "]";
        }
    }

    private static final class RegularClass
    extends ClassInfo {
        private final String surroundingClass;
        private boolean isLoadable = true;
        private Class<?> classObj;
        private final AbstractTypeAwareCheck check;

        private RegularClass(Token name, String surroundingClass, AbstractTypeAwareCheck check) {
            super(name);
            this.surroundingClass = surroundingClass;
            this.check = check;
        }

        private boolean isLoadable() {
            return this.isLoadable;
        }

        @Override
        public Class<?> getClazz() {
            if (this.isLoadable() && this.classObj == null) {
                this.setClazz(this.check.tryLoadClass(this.getName(), this.surroundingClass));
            }
            return this.classObj;
        }

        private void setClazz(Class<?> classObj) {
            this.classObj = classObj;
            this.isLoadable = classObj != null;
        }

        public String toString() {
            return "RegularClass[name=" + this.getName() + ", in class=" + this.surroundingClass + ", loadable=" + this.isLoadable + ", class=" + this.classObj + "]";
        }
    }

    protected static abstract class ClassInfo {
        private final Token name;

        public final Token getName() {
            return this.name;
        }

        public abstract Class<?> getClazz();

        protected ClassInfo(Token className) {
            if (className == null) {
                throw new NullPointerException("ClassInfo's name should be non-null");
            }
            this.name = className;
        }
    }
}

