/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.Utils;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.beanutils.ConversionException;

public abstract class AbstractFormatCheck
extends Check {
    private int compileFlags;
    private Pattern regexp;
    private String format;

    public AbstractFormatCheck(String defaultFormat) throws ConversionException {
        this(defaultFormat, 0);
    }

    public AbstractFormatCheck(String defaultFormat, int compileFlags) throws ConversionException {
        this.updateRegexp(defaultFormat, compileFlags);
    }

    public final void setFormat(String format) throws ConversionException {
        this.updateRegexp(format, this.compileFlags);
    }

    public final void setCompileFlags(int compileFlags) {
        this.updateRegexp(this.format, compileFlags);
    }

    public final Pattern getRegexp() {
        return this.regexp;
    }

    public final String getFormat() {
        return this.format;
    }

    private void updateRegexp(String format, int compileFlagsParam) {
        try {
            this.regexp = Utils.getPattern(format, compileFlagsParam);
            this.format = format;
            this.compileFlags |= compileFlagsParam;
        }
        catch (PatternSyntaxException e) {
            throw new ConversionException("unable to parse " + format, (Throwable)e);
        }
    }
}

