/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.google.common.collect.Lists;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.checks.AbstractTypeAwareCheck;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedundantThrowsCheck
extends AbstractTypeAwareCheck {
    private boolean mAllowUnchecked;
    private boolean mAllowSubclasses;

    public void setAllowUnchecked(boolean aAllowUnchecked) {
        this.mAllowUnchecked = aAllowUnchecked;
    }

    public void setAllowSubclasses(boolean aAllowSubclasses) {
        this.mAllowSubclasses = aAllowSubclasses;
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{16, 30, 14, 15, 154, 9, 8};
    }

    @Override
    protected final void processAST(DetailAST aAST) {
        LinkedList knownExcs = Lists.newLinkedList();
        DetailAST throwsAST = aAST.findFirstToken(81);
        if (throwsAST != null) {
            for (DetailAST child = throwsAST.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getType() != 58 && child.getType() != 59) continue;
                FullIdent fi = FullIdent.createFullIdent(child);
                this.checkException(fi, knownExcs);
            }
        }
    }

    @Override
    protected final void logLoadError(AbstractTypeAwareCheck.Token aIdent) {
        this.logLoadErrorImpl(aIdent.getLineNo(), aIdent.getColumnNo(), "redundant.throws.classInfo", aIdent.getText());
    }

    private void checkException(FullIdent aExc, List<AbstractTypeAwareCheck.ClassInfo> aKnownExcs) {
        AbstractTypeAwareCheck.ClassInfo newClassInfo = this.createClassInfo(new AbstractTypeAwareCheck.Token(aExc), this.getCurrentClassName());
        if (!this.mAllowUnchecked && this.isUnchecked(newClassInfo.getClazz())) {
            this.log(aExc.getLineNo(), aExc.getColumnNo(), "redundant.throws.unchecked", aExc.getText());
        }
        boolean shouldAdd = true;
        Iterator<AbstractTypeAwareCheck.ClassInfo> known = aKnownExcs.iterator();
        while (known.hasNext()) {
            AbstractTypeAwareCheck.ClassInfo ci = known.next();
            AbstractTypeAwareCheck.Token fi = ci.getName();
            if (ci.getClazz() == newClassInfo.getClazz()) {
                shouldAdd = false;
                this.log(aExc.getLineNo(), aExc.getColumnNo(), "redundant.throws.duplicate", aExc.getText());
                continue;
            }
            if (this.mAllowSubclasses) continue;
            if (this.isSubclass(ci.getClazz(), newClassInfo.getClazz())) {
                known.remove();
                this.log(fi.getLineNo(), fi.getColumnNo(), "redundant.throws.subclass", fi.getText(), aExc.getText());
                continue;
            }
            if (!this.isSubclass(newClassInfo.getClazz(), ci.getClazz())) continue;
            shouldAdd = false;
            this.log(aExc.getLineNo(), aExc.getColumnNo(), "redundant.throws.subclass", aExc.getText(), fi.getText());
        }
        if (shouldAdd) {
            aKnownExcs.add(newClassInfo);
        }
    }
}

