/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.puppycrawl.tools.checkstyle.api.AbstractLoader;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.FastStack;
import com.puppycrawl.tools.checkstyle.checks.imports.Guard;
import com.puppycrawl.tools.checkstyle.checks.imports.PkgControl;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

final class ImportControlLoader
extends AbstractLoader {
    private static final String DTD_PUBLIC_ID_1_0 = "-//Puppy Crawl//DTD Import Control 1.0//EN";
    private static final String DTD_PUBLIC_ID_1_1 = "-//Puppy Crawl//DTD Import Control 1.1//EN";
    private static final String DTD_RESOURCE_NAME_1_0 = "com/puppycrawl/tools/checkstyle/checks/imports/import_control_1_0.dtd";
    private static final String DTD_RESOURCE_NAME_1_1 = "com/puppycrawl/tools/checkstyle/checks/imports/import_control_1_1.dtd";
    private final FastStack<PkgControl> mStack = FastStack.newInstance();
    private static final Map<String, String> DTD_RESOURCE_BY_ID = new HashMap<String, String>();

    private ImportControlLoader() throws ParserConfigurationException, SAXException {
        super(DTD_RESOURCE_BY_ID);
    }

    public void startElement(String aNamespaceURI, String aLocalName, String aQName, Attributes aAtts) throws SAXException {
        if ("import-control".equals(aQName)) {
            String pkg = this.safeGet(aAtts, "pkg");
            this.mStack.push(new PkgControl(pkg));
        } else if ("subpackage".equals(aQName)) {
            assert (this.mStack.size() > 0);
            String name = this.safeGet(aAtts, "name");
            this.mStack.push(new PkgControl(this.mStack.peek(), name));
        } else if ("allow".equals(aQName) || "disallow".equals(aQName)) {
            Guard g;
            boolean regex;
            assert (this.mStack.size() > 0);
            boolean isAllow = "allow".equals(aQName);
            boolean isLocalOnly = aAtts.getValue("local-only") != null;
            String pkg = aAtts.getValue("pkg");
            boolean bl = regex = aAtts.getValue("regex") != null;
            if (pkg != null) {
                boolean exactMatch = aAtts.getValue("exact-match") != null;
                g = new Guard(isAllow, isLocalOnly, pkg, exactMatch, regex);
            } else {
                String clazz = this.safeGet(aAtts, "class");
                g = new Guard(isAllow, isLocalOnly, clazz, regex);
            }
            PkgControl pc = this.mStack.peek();
            pc.addGuard(g);
        }
    }

    public void endElement(String aNamespaceURI, String aLocalName, String aQName) {
        if ("subpackage".equals(aQName)) {
            assert (this.mStack.size() > 1);
            this.mStack.pop();
        }
    }

    static PkgControl load(URI aUri) throws CheckstyleException {
        InputStream is = null;
        try {
            is = aUri.toURL().openStream();
        }
        catch (MalformedURLException e) {
            throw new CheckstyleException("syntax error in url " + aUri, e);
        }
        catch (IOException e) {
            throw new CheckstyleException("unable to find " + aUri, e);
        }
        InputSource source = new InputSource(is);
        return ImportControlLoader.load(source, aUri);
    }

    private static PkgControl load(InputSource aSource, URI aUri) throws CheckstyleException {
        try {
            ImportControlLoader loader = new ImportControlLoader();
            loader.parseInputSource(aSource);
            return loader.getRoot();
        }
        catch (ParserConfigurationException e) {
            throw new CheckstyleException("unable to parse " + aUri, e);
        }
        catch (SAXException e) {
            throw new CheckstyleException("unable to parse " + aUri + " - " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new CheckstyleException("unable to read " + aUri, e);
        }
    }

    private PkgControl getRoot() {
        assert (this.mStack.size() == 1);
        return this.mStack.peek();
    }

    private String safeGet(Attributes aAtts, String aName) throws SAXException {
        String retVal = aAtts.getValue(aName);
        if (retVal == null) {
            throw new SAXException("missing attibute " + aName);
        }
        return retVal;
    }

    static {
        DTD_RESOURCE_BY_ID.put(DTD_PUBLIC_ID_1_0, DTD_RESOURCE_NAME_1_0);
        DTD_RESOURCE_BY_ID.put(DTD_PUBLIC_ID_1_1, DTD_RESOURCE_NAME_1_1);
    }
}

