/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.tiff;

import org.monte.media.math.Rational;
import org.monte.media.tiff.IFDDataType;
import org.monte.media.tiff.TagSet;
import org.monte.media.tiff.ValueFormatter;

public class TIFFTag {
    public static final int ASCII_MASK = 1 << IFDDataType.ASCII.getTypeNumber();
    public static final int BYTE_MASK = 1 << IFDDataType.BYTE.getTypeNumber();
    public static final int DOUBLE_MASK = 1 << IFDDataType.DOUBLE.getTypeNumber();
    public static final int FLOAT_MASK = 1 << IFDDataType.FLOAT.getTypeNumber();
    public static final int IFD_MASK = 1 << IFDDataType.IFD.getTypeNumber();
    public static final int LONG_MASK = 1 << IFDDataType.LONG.getTypeNumber();
    public static final int SHORT_MASK = 1 << IFDDataType.SHORT.getTypeNumber();
    public static final int RATIONAL_MASK = 1 << IFDDataType.RATIONAL.getTypeNumber();
    public static final int SBYTE_MASK = 1 << IFDDataType.BYTE.getTypeNumber();
    public static final int SLONG_MASK = 1 << IFDDataType.SLONG.getTypeNumber();
    public static final int SSHORT_MASK = 1 << IFDDataType.SSHORT.getTypeNumber();
    public static final int SRATIONAL_MASK = 1 << IFDDataType.SRATIONAL.getTypeNumber();
    public static final int UNDEFINED_MASK = 1 << IFDDataType.UNDEFINED.getTypeNumber();
    public static final int ALL_MASK = -1;
    private String name;
    private int number;
    private int dataTypes;
    private TagSet tagSet;
    private ValueFormatter formatter;

    public TIFFTag(String name, int number, int dataTypes, ValueFormatter formatter) {
        this.name = name;
        this.number = number;
        this.dataTypes = dataTypes;
        this.formatter = formatter;
    }

    public TIFFTag(String name, int number, int dataTypes) {
        this(name, number, dataTypes, null);
    }

    void setTagSet(TagSet tagSet) {
        this.tagSet = tagSet;
    }

    public int getNumber() {
        return this.number;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSynthetic() {
        return this.number < 0;
    }

    public IFDDataType getType(Object data) {
        int m = this.dataTypes;
        if (data != null && data.getClass().isArray()) {
            data = ((Object[])data)[0];
        }
        for (int i = 0; i < 32; ++i) {
            if ((m & 1) == 1) {
                switch (IFDDataType.valueOf(i)) {
                    case ASCII: {
                        if (data != null && !(data instanceof String)) break;
                        return IFDDataType.ASCII;
                    }
                    case BYTE: {
                        if (data != null && !(data instanceof Short)) break;
                        return IFDDataType.BYTE;
                    }
                    case DOUBLE: {
                        if (data != null && !(data instanceof Double)) break;
                        return IFDDataType.DOUBLE;
                    }
                    case FLOAT: {
                        if (data != null && !(data instanceof Float)) break;
                        return IFDDataType.FLOAT;
                    }
                    case IFD: {
                        if (data != null && !(data instanceof Long)) break;
                        return IFDDataType.IFD;
                    }
                    case LONG: {
                        if (data != null && !(data instanceof Long)) break;
                        return IFDDataType.LONG;
                    }
                    case RATIONAL: {
                        if (data != null && !(data instanceof Rational)) break;
                        return IFDDataType.RATIONAL;
                    }
                    case SBYTE: {
                        if (data != null && !(data instanceof Byte)) break;
                        return IFDDataType.SBYTE;
                    }
                    case SHORT: {
                        if (data != null && !(data instanceof Integer)) break;
                        return IFDDataType.SHORT;
                    }
                    case SLONG: {
                        if (data != null && !(data instanceof Integer)) break;
                        return IFDDataType.SLONG;
                    }
                    case SRATIONAL: {
                        if (data != null && !(data instanceof Rational)) break;
                        return IFDDataType.SRATIONAL;
                    }
                    case SSHORT: {
                        if (data != null && !(data instanceof Short)) break;
                        return IFDDataType.SSHORT;
                    }
                    case UNDEFINED: {
                        if (data != null && !(data instanceof Byte)) break;
                        return IFDDataType.UNDEFINED;
                    }
                }
                return IFDDataType.valueOf(i);
            }
            m >>= 1;
        }
        return IFDDataType.UNDEFINED;
    }

    public Object prettyFormat(Object data) {
        return this.formatter == null ? data : this.formatter.prettyFormat(data);
    }

    public Object format(Object data) {
        return this.formatter == null ? data : this.formatter.format(data);
    }

    public String toString() {
        return this.name;
    }

    public String getDescription(Object data) {
        return this.formatter == null ? null : this.formatter.descriptionFormat(data);
    }
}

