/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.jmf.codec.video;

import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import org.monte.media.avi.ZMBVCodecCore;
import org.monte.media.jmf.codec.video.AbstractVideoDecoder;

public class ZMBVDecoder
extends AbstractVideoDecoder {
    protected static final int bMask = 255;
    protected static final int gMask = 65280;
    protected static final int rMask = 0xFF0000;
    private int[] pixels;
    private int[] prevPixels;
    private long previousSequenceNumber = 0L;
    private ZMBVCodecCore state;

    public ZMBVDecoder() {
        this.supportedInputFormats = new VideoFormat[]{new VideoFormat("ZMBV")};
        this.defaultOutputFormats = new VideoFormat[]{new RGBFormat(null, -1, Format.intArray, -1.0f, 32, 0xFF0000, 65280, 255, 1, -1, 0, -1)};
        this.pluginName = "DosBox Screen Capture \"ZMBV\"";
    }

    @Override
    protected Format[] getMatchingOutputFormats(Format input) {
        if (this.supportedInputFormats[0].matches(input)) {
            VideoFormat inf = (VideoFormat)input;
            Dimension s = inf.getSize();
            RGBFormat outf = new RGBFormat(s, s.width < 0 || s.height < 0 ? -1 : s.width * s.height, Format.intArray, inf.getFrameRate(), 32, 0xFF0000, 65280, 255, 1, s.width, 0, 0);
            return new Format[]{outf};
        }
        return new Format[0];
    }

    public int process(Buffer input, Buffer output) {
        if (input.isDiscard()) {
            output.setDiscard(true);
            return 0;
        }
        if (input.isEOM()) {
            output.setEOM(true);
            output.setData(null);
            return 0;
        }
        output.copy(input);
        output.setFormat((Format)this.outputFormat);
        output.setData((Object)this.pixels);
        output.setOffset(0);
        output.setLength(this.pixels.length);
        byte[] inDat = (byte[])input.getData();
        int[] swap = this.prevPixels;
        this.prevPixels = this.pixels;
        this.pixels = swap;
        long sequenceNumber = input.getSequenceNumber();
        boolean framesWereSkipped = sequenceNumber != this.previousSequenceNumber + 1L;
        boolean isKeyframe = this.state.decode(inDat, input.getOffset(), input.getLength(), this.pixels, this.prevPixels, this.outputFormat.getSize().width, this.outputFormat.getSize().height, framesWereSkipped);
        if (framesWereSkipped && !isKeyframe) {
            output.setDiscard(true);
        } else {
            this.previousSequenceNumber = sequenceNumber;
        }
        ZMBVDecoder.setFlag(output, 16, isKeyframe);
        return 0;
    }

    @Override
    public void close() {
        this.pixels = null;
        this.state = null;
    }

    @Override
    public void open() throws ResourceUnavailableException {
        this.state = new ZMBVCodecCore();
        this.pixels = null;
        this.pixels = new int[this.outputFormat.getSize().width * this.outputFormat.getSize().height];
        this.prevPixels = new int[this.outputFormat.getSize().width * this.outputFormat.getSize().height];
    }
}

