/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.jpeg;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.HashSet;
import java.util.Stack;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageOutputStream;

public class JFIFOutputStream
extends OutputStream {
    private final HashSet<Integer> standaloneMarkers = new HashSet();
    private final HashSet<Integer> doubleSegMarkers = new HashSet();
    public static final int SOI_MARKER = 65496;
    public static final int EOI_MARKER = 65497;
    public static final int TEM_MARKER = 65281;
    public static final int SOS_MARKER = 65498;
    public static final int APP1_MARKER = 65505;
    public static final int APP2_MARKER = 65506;
    public static final int JPG0_MARKER = 65520;
    public static final int JPG1_MARKER = 65521;
    public static final int JPG2_MARKER = 65522;
    public static final int JPG3_MARKER = 65523;
    public static final int JPG4_MARKER = 65524;
    public static final int JPG5_MARKER = 65525;
    public static final int JPG6_MARKER = 65526;
    public static final int JPG7_MARKER = 65527;
    public static final int JPG8_MARKER = 65528;
    public static final int JPG9_MARKER = 65529;
    public static final int JPGA_MARKER = 65530;
    public static final int JPGB_MARKER = 65531;
    public static final int JPGC_MARKER = 65532;
    public static final int JPGD_MARKER = 65533;
    public static final int SOF0_MARKER = 65472;
    public static final int SOF1_MARKER = 65473;
    public static final int SOF2_MARKER = 65474;
    public static final int SOF3_MARKER = 65475;
    public static final int SOF5_MARKER = 65477;
    public static final int SOF6_MARKER = 65478;
    public static final int SOF7_MARKER = 65479;
    public static final int SOF9_MARKER = 65481;
    public static final int SOFA_MARKER = 65482;
    public static final int SOFB_MARKER = 65483;
    public static final int SOFD_MARKER = 65485;
    public static final int SOFE_MARKER = 65486;
    public static final int SOFF_MARKER = 65487;
    public static final int RST0_MARKER = 65488;
    public static final int RST1_MARKER = 65489;
    public static final int RST2_MARKER = 65490;
    public static final int RST3_MARKER = 65491;
    public static final int RST4_MARKER = 65492;
    public static final int RST5_MARKER = 65493;
    public static final int RST6_MARKER = 65494;
    public static final int RST7_MARKER = 65495;
    private ImageOutputStream out;
    private long streamOffset;
    private Stack<Segment> stack = new Stack();

    public JFIFOutputStream(ImageOutputStream out) throws IOException {
        this.out = out;
        out.setByteOrder(ByteOrder.BIG_ENDIAN);
        this.streamOffset = out.getStreamPosition();
        for (int i = 65488; i <= 65495; ++i) {
            this.standaloneMarkers.add(i);
        }
        this.standaloneMarkers.add(65496);
        this.standaloneMarkers.add(65497);
        this.standaloneMarkers.add(65281);
        this.standaloneMarkers.add(65520);
        this.standaloneMarkers.add(65521);
        this.standaloneMarkers.add(65522);
        this.standaloneMarkers.add(65523);
        this.standaloneMarkers.add(65524);
        this.standaloneMarkers.add(65525);
        this.standaloneMarkers.add(65526);
        this.standaloneMarkers.add(65527);
        this.standaloneMarkers.add(65528);
        this.standaloneMarkers.add(65529);
        this.standaloneMarkers.add(65530);
        this.standaloneMarkers.add(65531);
        this.standaloneMarkers.add(65532);
        this.standaloneMarkers.add(65533);
        this.standaloneMarkers.add(0);
        this.doubleSegMarkers.add(65498);
    }

    public JFIFOutputStream(File imgFile) throws IOException {
        this(new FileImageOutputStream(imgFile));
    }

    public long getStreamPosition() throws IOException {
        return this.out.getStreamPosition() - this.streamOffset;
    }

    public void seek(long newPosition) throws IOException {
        this.out.seek(newPosition + this.streamOffset);
    }

    public void pushSegment(int marker) throws IOException {
        this.stack.push(new Segment(marker));
    }

    public void popSegment() throws IOException {
        Segment seg = this.stack.pop();
        seg.finish();
    }

    public long getSegmentOffset() throws IOException {
        if (this.stack.peek() == null) {
            return -1L;
        }
        return this.stack.peek().offset;
    }

    public long getSegmentLength() throws IOException {
        if (this.stack.peek() == null) {
            return -1L;
        }
        return this.getStreamPosition() - this.stack.peek().offset - 2L;
    }

    public void finish() throws IOException {
        while (!this.stack.empty()) {
            this.popSegment();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.finish();
        }
        finally {
            this.out.close();
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.stack.size() == 0 || this.standaloneMarkers.contains(this.stack.peek().marker)) {
            this.writeStuffed(b, off, len);
        } else {
            this.writeNonstuffed(b, off, len);
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.stack.size() == 0 || this.standaloneMarkers.contains(this.stack.peek().marker)) {
            this.writeStuffed(b);
        } else {
            this.writeNonstuffed(b);
        }
    }

    private void writeNonstuffed(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    private void writeNonstuffed(int b) throws IOException {
        this.out.write(b);
    }

    private void writeStuffed(byte[] b, int off, int len) throws IOException {
        int n = off + len;
        for (int i = off; i < n; ++i) {
            if (b[i] != -1) continue;
            this.out.write(b, off, i - off + 1);
            this.out.write(0);
            off = i + 1;
        }
        if (n - off > 0) {
            this.out.write(b, off, n - off);
        }
    }

    private void writeStuffed(int b) throws IOException {
        this.out.write(255);
        if (b == 255) {
            this.out.write(0);
        }
    }

    private class Segment {
        protected int marker;
        protected long offset;
        protected boolean finished;

        public Segment(int marker) throws IOException {
            this.marker = marker;
            if (marker != 0) {
                JFIFOutputStream.this.out.writeShort(marker);
                this.offset = JFIFOutputStream.this.getStreamPosition();
                if (!JFIFOutputStream.this.standaloneMarkers.contains(marker)) {
                    JFIFOutputStream.this.out.writeShort(0);
                }
            }
        }

        public void finish() throws IOException {
            if (!this.finished) {
                if (!JFIFOutputStream.this.standaloneMarkers.contains(this.marker)) {
                    long size = JFIFOutputStream.this.getStreamPosition() - this.offset;
                    if (size > 65535L) {
                        throw new IOException("Segment \"" + this.marker + "\" is too large: " + size);
                    }
                    long pointer = JFIFOutputStream.this.getStreamPosition();
                    JFIFOutputStream.this.seek(this.offset);
                    JFIFOutputStream.this.out.writeShort((short)size);
                    JFIFOutputStream.this.seek(pointer);
                }
                this.finished = true;
            }
        }
    }
}

