/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.anim;

import java.awt.image.BufferedImage;
import org.monte.media.AbstractVideoCodec;
import org.monte.media.Buffer;
import org.monte.media.BufferFlag;
import org.monte.media.Format;
import org.monte.media.FormatKeys;
import org.monte.media.anim.AmigaVideoFormatKeys;
import org.monte.media.image.BitmapImage;

public class BitmapCodec
extends AbstractVideoCodec {
    public BitmapCodec() {
        super(new Format[]{new Format(new Object[]{AmigaVideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, AmigaVideoFormatKeys.MimeTypeKey, "x-iff/anim", AmigaVideoFormatKeys.EncodingKey, "op5", AmigaVideoFormatKeys.DataClassKey, byte[].class, AmigaVideoFormatKeys.FixedFrameRateKey, false})}, new Format[]{new Format(new Object[]{AmigaVideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, AmigaVideoFormatKeys.MimeTypeKey, "Java", AmigaVideoFormatKeys.EncodingKey, "image", AmigaVideoFormatKeys.FixedFrameRateKey, false})});
        this.name = "ILBM Codec";
    }

    @Override
    public int process(Buffer in, Buffer out) {
        BitmapImage bitmap;
        out.setMetaTo(in);
        if (in.isFlag(BufferFlag.DISCARD)) {
            return 0;
        }
        out.format = this.outputFormat;
        BufferedImage pixmap = (BufferedImage)in.data;
        Format vf = this.outputFormat;
        BitmapImage bitmapImage = bitmap = out.data instanceof BitmapImage ? (BitmapImage)out.data : null;
        if (bitmap == null || bitmap.getWidth() != ((Integer)vf.get(AmigaVideoFormatKeys.WidthKey)).intValue() || bitmap.getHeight() != ((Integer)vf.get(AmigaVideoFormatKeys.HeightKey)).intValue() || bitmap.getDepth() != ((Integer)vf.get(AmigaVideoFormatKeys.DepthKey)).intValue()) {
            bitmap = new BitmapImage((Integer)vf.get(AmigaVideoFormatKeys.WidthKey), (Integer)vf.get(AmigaVideoFormatKeys.HeightKey), (Integer)vf.get(AmigaVideoFormatKeys.DepthKey), pixmap.getColorModel());
            out.data = bitmap;
        }
        bitmap.setPlanarColorModel(pixmap.getColorModel());
        bitmap.convertFromChunky(pixmap);
        return 0;
    }
}

