/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.enumerations;

import com.orientechnologies.orient.core.record.ORecord;
import java.io.Serializable;
import java.util.Iterator;

public class OObjectEnumLazyIterator<TYPE extends Enum>
implements Iterator<TYPE>,
Serializable {
    private static final long serialVersionUID = -4012483076050044405L;
    private final ORecord sourceRecord;
    private final Iterator<? extends Object> underlying;
    private final Class<Enum> enumClass;

    public OObjectEnumLazyIterator(Class<Enum> iEnumClass, ORecord iSourceRecord, Iterator<? extends Object> iIterator) {
        this.sourceRecord = iSourceRecord;
        this.underlying = iIterator;
        this.enumClass = iEnumClass;
    }

    @Override
    public TYPE next() {
        Object value = this.underlying.next();
        if (value instanceof Number) {
            return (TYPE)this.enumClass.getEnumConstants()[((Number)value).intValue()];
        }
        return (TYPE)Enum.valueOf(this.enumClass, value.toString());
    }

    @Override
    public boolean hasNext() {
        return this.underlying.hasNext();
    }

    @Override
    public void remove() {
        this.underlying.remove();
        if (this.sourceRecord != null) {
            this.sourceRecord.setDirty();
        }
    }
}

