/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.graph.migration;

import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexFactory;
import com.orientechnologies.orient.core.index.OIndexManagerProxy;
import com.orientechnologies.orient.core.index.OIndexes;
import com.orientechnologies.orient.core.index.OSimpleKeyIndexDefinition;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeRIDSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class OGraphMigration {
    private final ODatabaseDocument database;
    private final OCommandOutputListener commandOutputListener;

    public OGraphMigration(ODatabaseDocument database, OCommandOutputListener commandOutputListener) {
        this.database = database;
        this.commandOutputListener = commandOutputListener;
    }

    public void execute() {
        List vertexes = this.database.query((OQuery)new OSQLSynchQuery("select from V"), new Object[0]);
        if (this.commandOutputListener != null) {
            this.commandOutputListener.onMessage(vertexes.size() + " vertexes were fetched to process.");
        }
        for (int i = 0; i < vertexes.size(); ++i) {
            ODocument vertex = (ODocument)vertexes.get(i);
            for (String fieldName : vertex.fieldNames()) {
                Object oldValue;
                if (!fieldName.startsWith("in_") && !fieldName.startsWith("out_") || !((oldValue = vertex.field(fieldName)) instanceof OMVRBTreeRIDSet)) continue;
                OMVRBTreeRIDSet oldTree = (OMVRBTreeRIDSet)oldValue;
                ORidBag bag = new ORidBag();
                bag.addAll((Collection)oldTree);
                vertex.field(fieldName, (Object)bag);
            }
            vertex.save();
            if (this.commandOutputListener == null || i % 10000 != 0) continue;
            this.commandOutputListener.onMessage(i + " vertexes were processed.");
        }
        if (this.commandOutputListener != null) {
            this.commandOutputListener.onMessage("All vertexes were processed, looking for manual indexes to update.");
        }
        OIndexManagerProxy indexManager = this.database.getMetadata().getIndexManager();
        boolean indexWasMigrated = false;
        for (OIndex index : indexManager.getIndexes()) {
            ODocument config = index.getConfiguration();
            ODocument metadata = index.getMetadata();
            if (config.field("blueprintsIndexClass") == null || metadata != null) continue;
            if (this.commandOutputListener != null) {
                this.commandOutputListener.onMessage("Index " + index.getName() + " uses out of dated index format and will be updated.");
            }
            OIndexFactory factory = OIndexes.getFactory((String)OClass.INDEX_TYPE.DICTIONARY.toString(), null);
            OIndex recordKeyValueIndex = this.database.getMetadata().getIndexManager().createIndex("__@recordmap@___" + index.getName(), OClass.INDEX_TYPE.DICTIONARY.toString(), (OIndexDefinition)new OSimpleKeyIndexDefinition(factory.getLastVersion(), new OType[]{OType.LINK, OType.STRING}), null, null, null);
            OIndexCursor cursor = index.cursor();
            Map.Entry entry = cursor.nextEntry();
            while (entry != null) {
                String keyTemp = entry.getKey().toString();
                OIdentifiable identifiable = (OIdentifiable)entry.getValue();
                recordKeyValueIndex.put((Object)new OCompositeKey(new Object[]{identifiable.getIdentity(), keyTemp}), (OIdentifiable)identifiable.getIdentity());
                entry = cursor.nextEntry();
            }
            metadata = new ODocument();
            metadata.field("blueprintsIndexClass", config.field("blueprintsIndexClass"));
            metadata.field("record_map_name", (Object)recordKeyValueIndex.getName());
            config.field("metadata", (Object)metadata);
            indexWasMigrated = true;
            if (this.commandOutputListener == null) continue;
            this.commandOutputListener.onMessage("Index " + index.getName() + " structure was updated.");
        }
        if (indexWasMigrated) {
            indexManager.save();
        }
        if (this.commandOutputListener != null) {
            this.commandOutputListener.onMessage("Graph database update is completed");
        }
    }
}

