/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl.transformer;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.etl.OETLProcessor;
import com.orientechnologies.orient.etl.transformer.OAbstractTransformer;
import com.orientechnologies.orient.etl.transformer.OTransformException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Deprecated
public class OCSVTransformer
extends OAbstractTransformer {
    private char separator = (char)44;
    private boolean columnsOnFirstLine = true;
    private List<String> columnNames = null;
    private List<OType> columnTypes = null;
    private long skipFrom = -1L;
    private long skipTo = -1L;
    private long line = -1L;
    private String nullValue;
    private Character stringCharacter = Character.valueOf('\"');
    private boolean unicode = true;

    public static boolean isFinite(float value) {
        return Math.abs(value) <= Float.MAX_VALUE;
    }

    @Override
    public ODocument getConfiguration() {
        return new ODocument().fromJSON("{parameters:[" + this.getCommonConfigurationParameters() + ",{separator:{optional:true,description:'Column separator'}}," + "{columnsOnFirstLine:{optional:true,description:'Columns are described in the first line'}}," + "{columns:{optional:true,description:'Columns array containing names, and optionally type after :'}}," + "{nullValue:{optional:true,description:'Value to consider as NULL. Default is not declared'}}," + "{unicode:{optional:true,description:'Support unicode values as \\u<code>'}}," + "{stringCharacter:{optional:true,description:'String character delimiter. Use \"\" to do not use any delimitator'}}," + "{skipFrom:{optional:true,description:'Line number where start to skip',type:'int'}}," + "{skipTo:{optional:true,description:'Line number where skip ends',type:'int'}}" + "],input:['String'],output:'ODocument'}");
    }

    @Override
    public void configure(OETLProcessor iProcessor, ODocument iConfiguration, OCommandContext iContext) {
        super.configure(iProcessor, iConfiguration, iContext);
        if (iConfiguration.containsField("separator")) {
            this.separator = iConfiguration.field("separator").toString().charAt(0);
        }
        if (iConfiguration.containsField("columnsOnFirstLine")) {
            this.columnsOnFirstLine = (Boolean)iConfiguration.field("columnsOnFirstLine");
        }
        if (iConfiguration.containsField("columns")) {
            List columns = (List)iConfiguration.field("columns");
            this.columnNames = new ArrayList<String>(columns.size());
            this.columnTypes = new ArrayList<OType>(columns.size());
            for (String c : columns) {
                String[] parts = c.split(":");
                this.columnNames.add(parts[0]);
                if (parts.length > 1) {
                    this.columnTypes.add(OType.valueOf((String)parts[1].toUpperCase()));
                    continue;
                }
                this.columnTypes.add(OType.ANY);
            }
        }
        if (iConfiguration.containsField("skipFrom")) {
            this.skipFrom = ((Number)iConfiguration.field("skipFrom")).longValue();
        }
        if (iConfiguration.containsField("skipTo")) {
            this.skipTo = ((Number)iConfiguration.field("skipTo")).longValue();
        }
        if (iConfiguration.containsField("nullValue")) {
            this.nullValue = (String)iConfiguration.field("nullValue");
        }
        if (iConfiguration.containsField("unicode")) {
            this.unicode = (Boolean)iConfiguration.field("unicode");
        }
        if (iConfiguration.containsField("stringCharacter")) {
            String value = iConfiguration.field("stringCharacter").toString();
            this.stringCharacter = value.isEmpty() ? null : Character.valueOf(value.charAt(0));
        }
    }

    @Override
    public String getName() {
        return "csv";
    }

    @Override
    public Object executeTransform(Object input) {
        if (this.skipTransform()) {
            return null;
        }
        this.log(OETLProcessor.LOG_LEVELS.DEBUG, "parsing=%s", input);
        List fields = OStringSerializerHelper.smartSplit((String)input.toString(), (char[])new char[]{this.separator}, (int)0, (int)-1, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)this.unicode, (char[])new char[0]);
        if (!this.isColumnNamesCorrect(fields)) {
            return null;
        }
        ODocument doc = new ODocument();
        for (int i = 0; i < this.columnNames.size() && i < fields.size(); ++i) {
            String fieldName = this.columnNames.get(i);
            Object fieldValue = null;
            try {
                OType fieldType;
                String fieldStringValue = this.getCellContent((String)fields.get(i));
                OType oType = fieldType = this.columnTypes != null ? this.columnTypes.get(i) : null;
                if (fieldType != null && fieldType != OType.ANY) {
                    fieldValue = this.processKnownType(doc, i, fieldName, fieldStringValue, fieldType);
                } else if (fieldStringValue != null) {
                    fieldValue = this.determineTheType(fieldStringValue);
                }
                doc.field(fieldName, fieldValue);
                continue;
            }
            catch (Exception e) {
                this.processor.getStats().incrementErrors();
                this.log(OETLProcessor.LOG_LEVELS.ERROR, "Error on setting document field %s=%s (cause=%s)", fieldName, fieldValue, e.toString());
            }
        }
        this.log(OETLProcessor.LOG_LEVELS.DEBUG, "document=%s", doc);
        return doc;
    }

    private Object processKnownType(ODocument doc, int i, String fieldName, String fieldStringValue, OType fieldType) {
        Object fieldValue = this.getCellContent(fieldStringValue);
        try {
            fieldValue = OType.convert((Object)fieldValue, (Class)fieldType.getDefaultJavaType());
            doc.field(fieldName, fieldValue);
        }
        catch (Exception e) {
            this.processor.getStats().incrementErrors();
            this.log(OETLProcessor.LOG_LEVELS.ERROR, "Error on converting row %d field '%s' (%d), value '%s' (class:%s) to type: %s", this.processor.getExtractor().getProgress(), fieldName, i, fieldValue, fieldValue.getClass().getName(), fieldType);
        }
        return fieldValue;
    }

    private Object determineTheType(String fieldStringValue) {
        Object fieldValue = this.transformToDate(fieldStringValue);
        if (fieldValue == null && (fieldValue = this.transformToNumeric(fieldStringValue)) == null) {
            fieldValue = fieldStringValue;
        }
        return fieldValue;
    }

    private Object transformToDate(String fieldStringValue) {
        Date fieldValue;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        df.setLenient(true);
        try {
            fieldValue = df.parse(fieldStringValue);
        }
        catch (ParseException pe) {
            fieldValue = null;
        }
        return fieldValue;
    }

    private Object transformToNumeric(String fieldStringValue) {
        Object fieldValue;
        if (fieldStringValue.isEmpty()) {
            return fieldStringValue;
        }
        char c = fieldStringValue.charAt(0);
        if (c != '-' && !Character.isDigit(c)) {
            return fieldStringValue;
        }
        try {
            if (fieldStringValue.contains(".") || fieldStringValue.contains(",")) {
                String numberAsString = fieldStringValue.replaceAll(",", ".");
                fieldValue = new Float(numberAsString);
                if (!this.isFinite((Float)fieldValue)) {
                    fieldValue = new Double(numberAsString);
                }
            } else {
                try {
                    fieldValue = new Integer(fieldStringValue);
                }
                catch (Exception e) {
                    fieldValue = new Long(fieldStringValue);
                }
            }
        }
        catch (NumberFormatException nf) {
            fieldValue = fieldStringValue;
        }
        return fieldValue;
    }

    private boolean isColumnNamesCorrect(List<String> fields) {
        if (this.columnNames == null) {
            if (!this.columnsOnFirstLine) {
                throw new OTransformException(this.getName() + ": columnsOnFirstLine=false and no columns declared");
            }
            this.columnNames = fields;
            for (int i = 0; i < this.columnNames.size(); ++i) {
                this.columnNames.set(i, this.getCellContent(this.columnNames.get(i)));
            }
            return false;
        }
        return !this.columnsOnFirstLine || this.line != 0L;
    }

    private boolean skipTransform() {
        ++this.line;
        return this.skipFrom > -1L && (this.skipTo > -1L ? this.line >= this.skipFrom && this.line <= this.skipTo : this.line >= this.skipFrom);
    }

    protected boolean isFinite(Float f) {
        return Math.abs(f.floatValue()) <= Float.MAX_VALUE;
    }

    public String getCellContent(String iValue) {
        if (iValue == null || iValue.isEmpty() || "NULL".equals(iValue)) {
            return null;
        }
        if (this.stringCharacter != null && iValue.length() > 1 && iValue.charAt(0) == this.stringCharacter.charValue() && iValue.charAt(iValue.length() - 1) == this.stringCharacter.charValue()) {
            return iValue.substring(1, iValue.length() - 1);
        }
        return iValue;
    }
}

