/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl.extractor;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.etl.OETLProcessor;
import com.orientechnologies.orient.etl.OExtractedItem;
import com.orientechnologies.orient.etl.extractor.OAbstractSourceExtractor;
import com.orientechnologies.orient.etl.extractor.OExtractorException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.NoSuchElementException;

public class ORowExtractor
extends OAbstractSourceExtractor {
    protected BufferedReader bReader;
    protected OExtractedItem next;
    protected boolean multiLine = true;
    protected String lineFeed = "\r\n";

    @Override
    public String getName() {
        return "row";
    }

    @Override
    public void configure(OETLProcessor iProcessor, ODocument iConfiguration, OCommandContext iContext) {
        super.configure(iProcessor, iConfiguration, iContext);
        if (iConfiguration.containsField("multiLine")) {
            this.multiLine = (Boolean)iConfiguration.field("multiLine");
        }
        if (iConfiguration.containsField("lineFeed")) {
            this.lineFeed = (String)iConfiguration.field("lineFeed");
        }
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        if (this.bReader == null) {
            return false;
        }
        try {
            this.next = this.fetchNext();
            return this.next != null;
        }
        catch (IOException e) {
            throw new OExtractorException(e);
        }
    }

    @Override
    public OExtractedItem next() {
        if (this.next != null) {
            OExtractedItem ret = this.next;
            this.next = null;
            return ret;
        }
        if (!this.hasNext()) {
            throw new NoSuchElementException("EOF");
        }
        try {
            return this.fetchNext();
        }
        catch (IOException e) {
            throw new OExtractorException(e);
        }
    }

    @Override
    public void extract(Reader iReader) {
        super.extract(iReader);
        this.bReader = new BufferedReader(this.reader);
    }

    @Override
    public void end() {
        if (this.bReader != null) {
            try {
                this.bReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.end();
    }

    @Override
    public String getUnit() {
        return "rows";
    }

    protected OExtractedItem fetchNext() throws IOException {
        if (!this.bReader.ready()) {
            return null;
        }
        String line = this.readLine();
        if (line == null || line.isEmpty()) {
            return null;
        }
        return new OExtractedItem(this.current++, line);
    }

    protected String readLine() throws IOException {
        if (this.multiLine) {
            StringBuilder sbLine = new StringBuilder();
            boolean isOpenQuote = false;
            do {
                String l;
                if (isOpenQuote) {
                    sbLine.append(this.lineFeed);
                }
                if ((l = this.bReader.readLine()) == null) break;
                sbLine.append(l);
                for (char c : l.toCharArray()) {
                    if ('\"' != c) continue;
                    isOpenQuote = !isOpenQuote;
                }
            } while (isOpenQuote);
            return sbLine.toString();
        }
        return this.bReader.readLine();
    }
}

