/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl.extractor;

import com.orientechnologies.apache.commons.csv.CSVFormat;
import com.orientechnologies.apache.commons.csv.CSVParser;
import com.orientechnologies.apache.commons.csv.CSVRecord;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.etl.OETLProcessor;
import com.orientechnologies.orient.etl.OExtractedItem;
import com.orientechnologies.orient.etl.extractor.OAbstractSourceExtractor;
import com.orientechnologies.orient.etl.extractor.OExtractorException;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class OCSVExtractor
extends OAbstractSourceExtractor {
    private static String NULL_STRING = "NULL";
    protected OExtractedItem next;
    private Map<String, OType> columnTypes = new HashMap<String, OType>();
    private long skipFrom = -1L;
    private long skipTo = -1L;
    private Character stringCharacter = Character.valueOf('\"');
    private boolean unicode = true;
    private Iterator<CSVRecord> recordIterator;
    private CSVFormat csvFormat;
    private String nullValue = NULL_STRING;
    private String dateFormat = "yyyy-MM-dd";

    @Override
    public ODocument getConfiguration() {
        return new ODocument().fromJSON("{parameters:[" + this.getCommonConfigurationParameters() + ",{separator:{optional:true,description:'Column separator'}}," + "{columnsOnFirstLine:{optional:true,description:'Columns are described in the first line'}}," + "{columns:{optional:true,description:'Columns array containing names, and optionally type after : (e.g.: name:String, age:int'}}," + "{nullValue:{optional:true,description:'Value to consider as NULL_STRING. Default is NULL'}}," + "{dateFormat:{optional:true,description:'Date format used to parde dates. Default is yyyy-MM-dd'}}," + "{quote:{optional:true,description:'String character delimiter. Use \"\" to do not use any delimitator'}}," + "{ignoreEmptyLines:{optional:true,description:'Ignore empty lines',type:'boolean'}}," + "{skipFrom:{optional:true,description:'Line number where start to skip',type:'int'}}," + "{skipTo:{optional:true,description:'Line number where skip ends',type:'int'}}" + "{predefinedFormat:{optional:true,description:'Name of standard csv format (from Apache commons-csv): DEFAULT, EXCEL, MYSQL, RFC4180, TDF',type:'String'}}" + "],input:['String'],output:'ODocument'}");
    }

    @Override
    public String getName() {
        return "csv";
    }

    @Override
    public String getUnit() {
        return "rows";
    }

    @Override
    public void configure(OETLProcessor iProcessor, ODocument iConfiguration, OCommandContext iContext) {
        String value;
        super.configure(iProcessor, iConfiguration, iContext);
        this.csvFormat = CSVFormat.newFormat(',').withNullString(NULL_STRING).withEscape('\\').withQuote('\"');
        if (iConfiguration.containsField("predefinedFormat")) {
            this.csvFormat = CSVFormat.valueOf(((String)iConfiguration.field("predefinedFormat")).toUpperCase());
        }
        if (iConfiguration.containsField("separator")) {
            this.csvFormat = this.csvFormat.withDelimiter(iConfiguration.field("separator").toString().charAt(0));
        }
        if (iConfiguration.containsField("dateFormat")) {
            this.dateFormat = (String)iConfiguration.field("dateFormat");
        }
        if (iConfiguration.containsField("ignoreEmptyLines")) {
            boolean ignoreEmptyLines = (Boolean)iConfiguration.field("ignoreEmptyLines");
            this.csvFormat = this.csvFormat.withIgnoreEmptyLines(ignoreEmptyLines);
        }
        if (iConfiguration.containsField("columnsOnFirstLine")) {
            Boolean columnsOnFirstLine = (Boolean)iConfiguration.field("columnsOnFirstLine");
            if (columnsOnFirstLine.equals(Boolean.TRUE)) {
                this.csvFormat = this.csvFormat.withHeader(new String[0]);
            }
        } else {
            this.csvFormat = this.csvFormat.withHeader(new String[0]);
        }
        if (iConfiguration.containsField("columns")) {
            List columns = (List)iConfiguration.field("columns");
            ArrayList<String> columnNames = new ArrayList<String>(columns.size());
            this.columnTypes = new HashMap<String, OType>(columns.size());
            for (String c : columns) {
                String[] parts = c.split(":");
                columnNames.add(parts[0]);
                if (parts.length > 1) {
                    this.columnTypes.put(parts[0], OType.valueOf((String)parts[1].toUpperCase()));
                    continue;
                }
                this.columnTypes.put(parts[0], OType.ANY);
            }
            this.log(OETLProcessor.LOG_LEVELS.INFO, "column types: %s", this.columnTypes);
            this.csvFormat = this.csvFormat.withHeader(columnNames.toArray(new String[0]));
        }
        if (iConfiguration.containsField("skipFrom")) {
            this.skipFrom = ((Number)iConfiguration.field("skipFrom")).longValue();
        }
        if (iConfiguration.containsField("skipTo")) {
            this.skipTo = ((Number)iConfiguration.field("skipTo")).longValue();
        }
        if (iConfiguration.containsField("nullValue")) {
            this.nullValue = (String)iConfiguration.field("nullValue");
            this.csvFormat = this.csvFormat.withNullString(this.nullValue);
        }
        if (iConfiguration.containsField("quote") && !(value = iConfiguration.field("quote").toString()).isEmpty()) {
            this.csvFormat = this.csvFormat.withQuote(value.charAt(0));
        }
    }

    @Override
    public void extract(Reader iReader) {
        super.extract(iReader);
        try {
            CSVParser parser = new CSVParser(iReader, this.csvFormat);
            this.recordIterator = parser.iterator();
        }
        catch (IOException e) {
            throw new OExtractorException(e);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.recordIterator.hasNext()) {
            CSVRecord csvRecord = this.recordIterator.next();
            while (this.shouldSkipRecord(csvRecord) && this.recordIterator.hasNext()) {
                csvRecord = this.recordIterator.next();
            }
            this.next = this.fetchNext(csvRecord);
            return true;
        }
        return false;
    }

    private boolean shouldSkipRecord(CSVRecord csvRecord) {
        return csvRecord.getRecordNumber() <= this.skipTo && csvRecord.getRecordNumber() >= this.skipFrom;
    }

    private OExtractedItem fetchNext(CSVRecord csvRecord) {
        ODocument doc = new ODocument();
        Map<String, String> recordAsMap = csvRecord.toMap();
        if (this.columnTypes.isEmpty()) {
            for (Map.Entry<String, String> en : recordAsMap.entrySet()) {
                String value = en.getValue();
                if (value == null || this.nullValue.equals(value) || value.isEmpty()) {
                    doc.field(en.getKey(), null, new OType[]{OType.ANY});
                    continue;
                }
                doc.field(en.getKey(), this.determineTheType(value));
            }
        } else {
            for (Map.Entry<String, OType> typeEntry : this.columnTypes.entrySet()) {
                String fieldName = typeEntry.getKey();
                OType fieldType = typeEntry.getValue();
                String fieldValueAsString = recordAsMap.get(fieldName);
                try {
                    Object fieldValue = OType.convert((Object)fieldValueAsString, (Class)fieldType.getDefaultJavaType());
                    doc.field(fieldName, fieldValue);
                }
                catch (Exception e) {
                    this.processor.getStats().incrementErrors();
                    this.log(OETLProcessor.LOG_LEVELS.ERROR, "Error on converting row %d field '%s' (%d), value '%s' (class:%s) to type: %s", csvRecord.getRecordNumber(), fieldName, fieldValueAsString, fieldValueAsString.getClass().getName(), fieldType);
                }
            }
        }
        this.log(OETLProcessor.LOG_LEVELS.DEBUG, "document=%s", doc);
        ++this.current;
        return new OExtractedItem(this.current, doc);
    }

    @Override
    public OExtractedItem next() {
        return this.next;
    }

    private Object determineTheType(String fieldStringValue) {
        Object fieldValue = this.transformToDate(fieldStringValue);
        if (fieldValue == null && (fieldValue = this.transformToNumeric(fieldStringValue)) == null) {
            fieldValue = fieldStringValue;
        }
        return fieldValue;
    }

    private Object transformToDate(String fieldStringValue) {
        Date fieldValue;
        SimpleDateFormat df = new SimpleDateFormat(this.dateFormat);
        df.setLenient(true);
        try {
            fieldValue = df.parse(fieldStringValue);
        }
        catch (ParseException pe) {
            fieldValue = null;
        }
        return fieldValue;
    }

    private Object transformToNumeric(String fieldStringValue) {
        Object fieldValue;
        if (fieldStringValue.isEmpty()) {
            return fieldStringValue;
        }
        char c = fieldStringValue.charAt(0);
        if (c != '-' && !Character.isDigit(c)) {
            return fieldStringValue;
        }
        try {
            if (fieldStringValue.contains(".") || fieldStringValue.contains(",")) {
                String numberAsString = fieldStringValue.replaceAll(",", ".");
                fieldValue = new Float(numberAsString);
                if (!this.isFinite((Float)fieldValue)) {
                    fieldValue = new Double(numberAsString);
                }
            } else {
                try {
                    fieldValue = new Integer(fieldStringValue);
                }
                catch (Exception e) {
                    fieldValue = new Long(fieldStringValue);
                }
            }
        }
        catch (NumberFormatException nf) {
            fieldValue = fieldStringValue;
        }
        return fieldValue;
    }

    protected boolean isFinite(Float f) {
        return Math.abs(f.floatValue()) <= Float.MAX_VALUE;
    }
}

