/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.serialization.types;

import com.orientechnologies.common.serialization.OBinaryConverter;
import com.orientechnologies.common.serialization.OBinaryConverterFactory;
import com.orientechnologies.common.serialization.types.OBinarySerializer;

public class OIntegerSerializer
implements OBinarySerializer<Integer> {
    private static final OBinaryConverter CONVERTER = OBinaryConverterFactory.getConverter();
    public static OIntegerSerializer INSTANCE = new OIntegerSerializer();
    public static final byte ID = 8;
    public static final int INT_SIZE = 4;

    @Override
    public int getObjectSize(Integer object) {
        return 4;
    }

    @Override
    public void serialize(Integer object, byte[] stream, int startPosition) {
        int value = object;
        stream[startPosition] = (byte)(value >>> 24 & 0xFF);
        stream[startPosition + 1] = (byte)(value >>> 16 & 0xFF);
        stream[startPosition + 2] = (byte)(value >>> 8 & 0xFF);
        stream[startPosition + 3] = (byte)(value >>> 0 & 0xFF);
    }

    @Override
    public Integer deserialize(byte[] stream, int startPosition) {
        return stream[startPosition] << 24 | (0xFF & stream[startPosition + 1]) << 16 | (0xFF & stream[startPosition + 2]) << 8 | 0xFF & stream[startPosition + 3];
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return 4;
    }

    @Override
    public byte getId() {
        return 8;
    }

    @Override
    public int getObjectSizeNative(byte[] stream, int startPosition) {
        return 4;
    }

    @Override
    public void serializeNative(Integer object, byte[] stream, int startPosition) {
        CONVERTER.putInt(stream, startPosition, object);
    }

    @Override
    public Integer deserializeNative(byte[] stream, int startPosition) {
        return CONVERTER.getInt(stream, startPosition);
    }

    @Override
    public boolean isFixedLength() {
        return true;
    }

    @Override
    public int getFixedLength() {
        return 4;
    }
}

