/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.serialization;

import com.orientechnologies.common.serialization.OBinaryConverter;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.misc.Unsafe;

public class OUnsafeBinaryConverter
implements OBinaryConverter {
    private static final Unsafe theUnsafe = (Unsafe)AccessController.doPrivileged(new PrivilegedAction<Object>(){

        @Override
        public Object run() {
            try {
                Field f = Unsafe.class.getDeclaredField("theUnsafe");
                f.setAccessible(true);
                return f.get(null);
            }
            catch (NoSuchFieldException e) {
                throw new Error();
            }
            catch (IllegalAccessException e) {
                throw new Error();
            }
        }
    });
    private static final long BYTE_ARRAY_OFFSET = theUnsafe.arrayBaseOffset(byte[].class);

    @Override
    public void putShort(byte[] buffer, int index, short value) {
        theUnsafe.putShort(buffer, (long)index + BYTE_ARRAY_OFFSET, value);
    }

    @Override
    public short getShort(byte[] buffer, int index) {
        return theUnsafe.getShort(buffer, (long)index + BYTE_ARRAY_OFFSET);
    }

    @Override
    public void putInt(byte[] buffer, int pointer, int value) {
        long position = (long)pointer + BYTE_ARRAY_OFFSET;
        theUnsafe.putInt(buffer, position, value);
    }

    @Override
    public int getInt(byte[] buffer, int pointer) {
        long position = (long)pointer + BYTE_ARRAY_OFFSET;
        return theUnsafe.getInt(buffer, position);
    }

    @Override
    public void putLong(byte[] buffer, int index, long value) {
        theUnsafe.putLong(buffer, (long)index + BYTE_ARRAY_OFFSET, value);
    }

    @Override
    public long getLong(byte[] buffer, int index) {
        return theUnsafe.getLong(buffer, (long)index + BYTE_ARRAY_OFFSET);
    }

    @Override
    public void putChar(byte[] buffer, int index, char character) {
        theUnsafe.putChar(buffer, (long)index + BYTE_ARRAY_OFFSET, character);
    }

    @Override
    public char getChar(byte[] buffer, int index) {
        return theUnsafe.getChar(buffer, (long)index + BYTE_ARRAY_OFFSET);
    }

    @Override
    public boolean nativeAccelerationUsed() {
        return true;
    }
}

